/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx.matchtime.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import osm.jp.gpx.AppParameters;
import osm.jp.gpx.ImportPicture;
import osm.jp.gpx.matchtime.gui.AboutDialog;
import osm.jp.gpx.matchtime.gui.DoDialog;
import osm.jp.gpx.matchtime.gui.ImageFileView;
import osm.jp.gpx.matchtime.gui.ImageFilter;
import osm.jp.gpx.matchtime.gui.ImagePreview;
import osm.jp.gpx.matchtime.gui.ParameterPanel;
import osm.jp.gpx.matchtime.gui.ParameterPanelFolder;
import osm.jp.gpx.matchtime.gui.ParameterPanelGpx;
import osm.jp.gpx.matchtime.gui.ParameterPanelImageFile;
import osm.jp.gpx.matchtime.gui.QuitDialog;

public class AdjustTime
extends JFrame {
    public static final String PROGRAM_NAME = "AdjustTime for JOSM";
    public static final String PROGRAM_VARSION = "4.01";
    public static final String PROGRAM_UPDATE = "2018/09/17";
    AppParameters params;
    SimpleDateFormat dfjp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    boolean fComponentsAdjusted = false;
    public ResourceBundle i18n = ResourceBundle.getBundle("i18n");
    JPanel cardPanel;
    JPanel[] cards;
    int cardPanelNo = 0;
    JPanel argsPanel;
    JScrollPane imageSPane;
    JLabel imageLabel;
    ButtonGroup baseTimeGroup;
    JRadioButton exifBase;
    JRadioButton fupdateBase;
    JCheckBox noFirstNode;
    JCheckBox gpxReuse;
    JTextArea textArea;
    ParameterPanelFolder arg1_srcFolder;
    ParameterPanelImageFile arg2_baseTimeImg;
    ParameterPanel arg3_basetime;
    JCheckBox outputIMG;
    JCheckBox outputIMG_all;
    JCheckBox exifON;
    JCheckBox gpxOutputWpt;
    JCheckBox gpxOverwriteMagvar;
    JCheckBox gpxOutputSpeed;
    ParameterPanelFolder arg5_outputFolder;
    ParameterPanelGpx arg4_gpxFolder;
    JPanel buttonPanel;
    JButton openButton;
    JButton zoomInButton;
    JButton zoomOutButton;
    JButton nextButton;
    JButton backButton;
    JButton doButton;
    MenuBar mainMenuBar;
    Menu menu1;
    MenuItem miDoNewFileList;
    MenuItem miDoDirSize;
    MenuItem miDoReadXML;
    MenuItem miExit;
    Menu menu3;
    MenuItem miAbout;
    ImageIcon refImage;

    public AdjustTime() throws IOException {
        this.dfjp.setTimeZone(TimeZone.getTimeZone("JST"));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setSize(this.getInsets().left + this.getInsets().right + 720, this.getInsets().top + this.getInsets().bottom + 480);
        this.setTitle("AdjustTime for JOSM v4.01");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        container.add((Component)mainPanel, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add(Box.createVerticalStrut(10), "South");
        southPanel.add(Box.createVerticalStrut(10), "North");
        container.add((Component)southPanel, "South");
        container.add(Box.createVerticalStrut(30), "North");
        container.add(Box.createHorizontalStrut(10), "West");
        container.add(Box.createHorizontalStrut(10), "East");
        this.params = new AppParameters();
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        mainPanel.add((Component)this.cardPanel, "Center");
        this.nextButton = new JButton(this.i18n.getString("button.next"));
        southPanel.add((Component)this.nextButton, "East");
        this.backButton = new JButton(this.i18n.getString("button.previous"));
        southPanel.add((Component)this.backButton, "West");
        this.cards = new JPanel[5];
        for (int i = 0; i < 5; ++i) {
            this.cards[i] = new JPanel();
            this.cardPanel.add((Component)this.cards[i], String.valueOf(i));
        }
        this.cardPanelNo = 0;
        int cardNo = 0;
        this.cards[cardNo].setLayout(new BorderLayout());
        JLabel label1 = new JLabel();
        label1.setText(this.i18n.getString("label.100"));
        this.cards[cardNo].add((Component)label1, "North");
        this.argsPanel = new JPanel();
        this.argsPanel.setLayout(new BoxLayout(this.argsPanel, 1));
        this.arg1_srcFolder = new ParameterPanelFolder(this.i18n.getString("label.110") + ": ", this.params.getProperty(AppParameters.IMG_SOURCE_FOLDER));
        this.argsPanel.add(this.arg1_srcFolder);
        this.cards[cardNo].add((Component)this.argsPanel, "Center");
        this.cards[++cardNo].setLayout(new BorderLayout());
        JLabel label2 = new JLabel();
        label2.setText(this.i18n.getString("label.200"));
        this.cards[cardNo].add((Component)label2, "North");
        this.argsPanel = new JPanel();
        this.argsPanel.setLayout(new BoxLayout(this.argsPanel, 1));
        this.arg2_baseTimeImg = new ParameterPanelImageFile(this.i18n.getString("label.210") + ": ", this.params.getProperty(AppParameters.IMG_BASE_FILE), this.arg1_srcFolder);
        this.argsPanel.add(this.arg2_baseTimeImg);
        this.baseTimeGroup = new ButtonGroup();
        this.exifBase = new JRadioButton(this.i18n.getString("label.220"));
        this.fupdateBase = new JRadioButton(this.i18n.getString("label.230"));
        this.baseTimeGroup.add(this.exifBase);
        this.baseTimeGroup.add(this.fupdateBase);
        this.argsPanel.add(this.exifBase);
        this.argsPanel.add(this.fupdateBase);
        if (this.params.getProperty(AppParameters.GPX_BASETIME).equals("EXIF_TIME")) {
            this.fupdateBase.setSelected(false);
            this.exifBase.setSelected(true);
        } else {
            this.fupdateBase.setSelected(true);
            this.exifBase.setSelected(false);
        }
        this.cards[cardNo].add((Component)this.argsPanel, "Center");
        this.cards[++cardNo].setLayout(new BorderLayout());
        this.argsPanel = new JPanel();
        this.argsPanel.setLayout(new GridLayout(2, 1));
        JLabel label3 = new JLabel();
        label3.setText(this.i18n.getString("label.300"));
        this.argsPanel.add(label3);
        String str310 = String.format("\u3000\u3000%s: ", this.i18n.getString("label.310"));
        this.arg3_basetime = new ParameterPanel(str310, "yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.argsPanel.add(this.arg3_basetime);
        this.cards[cardNo].add((Component)this.argsPanel, "North");
        this.imageLabel = new JLabel();
        this.imageSPane = new JScrollPane(this.imageLabel);
        this.cards[cardNo].add((Component)this.imageSPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.openButton = new JButton(AdjustTime.createImageIcon("images/Fit16.gif"));
        this.buttonPanel.add(this.openButton);
        this.zoomInButton = new JButton(AdjustTime.createImageIcon("images/ZoomIn16.gif"));
        this.buttonPanel.add(this.zoomInButton);
        this.zoomOutButton = new JButton(AdjustTime.createImageIcon("images/ZoomOut16.gif"));
        this.buttonPanel.add(this.zoomOutButton);
        this.cards[cardNo].add((Component)this.buttonPanel, "South");
        this.cards[++cardNo].setLayout(new BorderLayout());
        JLabel label4 = new JLabel();
        label4.setText(this.i18n.getString("label.400"));
        this.cards[cardNo].add((Component)label4, "North");
        JPanel tmpPanel4a = new JPanel();
        tmpPanel4a.setLayout(new BoxLayout(tmpPanel4a, 1));
        this.arg4_gpxFolder = new ParameterPanelGpx(this.i18n.getString("label.410") + ": ", this.params.getProperty(AppParameters.GPX_SOURCE_FOLDER));
        tmpPanel4a.add(this.arg4_gpxFolder);
        this.noFirstNode = new JCheckBox(this.i18n.getString("label.420"), this.params.getProperty(AppParameters.GPX_NO_FIRST_NODE).equals("ON"));
        tmpPanel4a.add(this.noFirstNode);
        this.gpxReuse = new JCheckBox(this.i18n.getString("label.430"), this.params.getProperty(AppParameters.GPX_REUSE).equals("ON"));
        this.gpxReuse.setEnabled(true);
        tmpPanel4a.add(this.gpxReuse);
        this.cards[cardNo].add((Component)tmpPanel4a, "Center");
        this.cards[++cardNo].setLayout(new BorderLayout());
        JLabel label5 = new JLabel();
        label5.setText(String.format("<html><p>5. %s</p><ul><li>%s</li><li>%s</li></ul>", this.i18n.getString("label.500"), this.i18n.getString("label.501"), this.i18n.getString("label.502")));
        this.cards[cardNo].add((Component)label5, "North");
        JPanel tmpPanel5 = new JPanel();
        tmpPanel5.setLayout(new BoxLayout(tmpPanel5, 1));
        this.outputIMG = new JCheckBox(this.i18n.getString("label.510"), Boolean.parseBoolean(this.params.getProperty(AppParameters.IMG_OUTPUT)));
        tmpPanel5.add(this.outputIMG);
        this.outputIMG_all = new JCheckBox(this.i18n.getString("label.520"), Boolean.parseBoolean(this.params.getProperty(AppParameters.IMG_OUTPUT_ALL)));
        tmpPanel5.add(this.outputIMG_all);
        this.arg5_outputFolder = new ParameterPanelFolder(this.i18n.getString("label.530") + ": ", this.params.getProperty(AppParameters.IMG_OUTPUT_FOLDER));
        tmpPanel5.add(this.arg5_outputFolder);
        this.exifON = new JCheckBox(this.i18n.getString("label.540"), Boolean.parseBoolean(this.params.getProperty(AppParameters.IMG_OUTPUT_EXIF)));
        tmpPanel5.add(this.exifON);
        this.gpxOutputWpt = new JCheckBox(this.i18n.getString("label.550"), Boolean.parseBoolean(this.params.getProperty(AppParameters.GPX_OUTPUT_WPT)));
        this.gpxOutputWpt.setEnabled(true);
        tmpPanel5.add(this.gpxOutputWpt);
        this.gpxOverwriteMagvar = new JCheckBox(this.i18n.getString("label.560"), Boolean.parseBoolean(this.params.getProperty(AppParameters.GPX_OVERWRITE_MAGVAR)));
        this.gpxOverwriteMagvar.setEnabled(true);
        tmpPanel5.add(this.gpxOverwriteMagvar);
        this.gpxOutputSpeed = new JCheckBox(this.i18n.getString("label.570"), Boolean.parseBoolean(this.params.getProperty(AppParameters.GPX_OUTPUT_SPEED)));
        this.gpxOutputSpeed.setEnabled(true);
        tmpPanel5.add(this.gpxOutputSpeed);
        this.cards[cardNo].add((Component)tmpPanel5, "Center");
        this.doButton = new JButton(this.i18n.getString("button.execute"), AdjustTime.createImageIcon("images/media_playback_start.png"));
        this.cards[cardNo].add((Component)this.doButton, "South");
        this.menu1 = new Menu("File");
        this.miExit = new MenuItem(this.i18n.getString("menu.quit"));
        this.miExit.setFont(new Font("Dialog", 0, 12));
        this.menu1.add(this.miExit);
        this.miAbout = new MenuItem("About...");
        this.miAbout.setFont(new Font("Dialog", 0, 12));
        this.menu3 = new Menu("Help");
        this.menu3.setFont(new Font("Dialog", 0, 12));
        this.menu3.add(this.miAbout);
        this.mainMenuBar = new MenuBar();
        this.mainMenuBar.setHelpMenu(this.menu3);
        this.mainMenuBar.add(this.menu1);
        this.mainMenuBar.add(this.menu3);
        this.setMenuBar(this.mainMenuBar);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.miAbout.addActionListener(lSymAction);
        this.miExit.addActionListener(lSymAction);
        this.openButton.addActionListener(lSymAction);
        this.zoomOutButton.addActionListener(lSymAction);
        this.zoomInButton.addActionListener(lSymAction);
        this.arg2_baseTimeImg.argField.addActionListener(lSymAction);
        this.arg2_baseTimeImg.openButton.addActionListener(lSymAction);
        this.doButton.addActionListener(lSymAction);
        this.outputIMG_all.addActionListener(lSymAction);
        this.exifON.addActionListener(lSymAction);
        this.gpxOutputSpeed.addActionListener(lSymAction);
        this.noFirstNode.addActionListener(lSymAction);
        this.gpxReuse.addActionListener(lSymAction);
        this.nextButton.addActionListener(lSymAction);
        this.backButton.addActionListener(lSymAction);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            try {
                AdjustTime.createAndShowGUI();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static void createAndShowGUI() throws IOException {
        new AdjustTime().setVisible(true);
    }

    @Override
    public void addNotify() {
        Component[] components;
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        for (Component component : components = this.getComponents()) {
            Point p = component.getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            component.setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    void DbMang_WindowClosing(WindowEvent event) {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    void miAbout_Action(ActionEvent event) {
        new AboutDialog((Frame)this, true).setVisible(true);
    }

    void miExit_Action(ActionEvent event) {
        new QuitDialog(this, true).setVisible(true);
    }

    public void imageView_Action(ActionEvent ev) {
        ImageIcon tmpIcon;
        String path;
        block6: {
            path = new File(this.arg1_srcFolder.getText(), this.arg2_baseTimeImg.getText()).getPath();
            File timeFile = new File(path);
            if (this.exifBase.isSelected()) {
                try {
                    ImageMetadata meta = Imaging.getMetadata((File)timeFile);
                    JpegImageMetadata jpegMetadata = (JpegImageMetadata)meta;
                    if (jpegMetadata == null) break block6;
                    TiffImageMetadata exif = jpegMetadata.getExif();
                    if (exif != null) {
                        String dateTimeOriginal = exif.getFieldValue(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL)[0];
                        long lastModifyTime = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss").parse(dateTimeOriginal).getTime();
                        this.arg3_basetime.argField.setText(this.dfjp.format(new Date(lastModifyTime)));
                        break block6;
                    }
                    this.arg3_basetime.argField.setText("exif == null");
                }
                catch (Exception meta) {}
            } else {
                long lastModifyTime = timeFile.lastModified();
                this.arg3_basetime.argField.setText(this.dfjp.format(new Date(lastModifyTime)));
            }
        }
        int size_x = this.imageSPane.getWidth() - 8;
        this.refImage = tmpIcon = new ImageIcon(path);
        if (tmpIcon.getIconWidth() > size_x) {
            this.refImage = new ImageIcon(tmpIcon.getImage().getScaledInstance(size_x, -1, 1));
        }
        this.imageLabel.setIcon(this.refImage);
        this.repaint();
    }

    public void zoomin_Action(ActionEvent ev) {
        if (this.refImage != null) {
            int size_x = this.imageLabel.getWidth();
            String path = new File(this.arg1_srcFolder.getText(), this.arg2_baseTimeImg.getText()).getPath();
            ImageIcon tmpIcon = new ImageIcon(path);
            this.refImage = new ImageIcon(tmpIcon.getImage().getScaledInstance(size_x * 2, -1, 1));
            this.imageLabel.setIcon(this.refImage);
            this.repaint();
        }
    }

    public void zoomout_Action(ActionEvent ev) {
        if (this.refImage != null) {
            int size_x = this.imageLabel.getWidth();
            ImageIcon tmpIcon = this.refImage;
            this.refImage = new ImageIcon(tmpIcon.getImage().getScaledInstance(size_x / 2, -1, 1));
            this.imageLabel.setIcon(this.refImage);
            this.repaint();
        }
    }

    public void selectSource_Action(ActionEvent ev) {
    }

    public void selectImage_Action(ActionEvent ev) {
        File sdir = new File(this.arg1_srcFolder.getText());
        System.out.println(sdir.getPath());
        JFileChooser fc = sdir.isDirectory() ? new JFileChooser(sdir) : new JFileChooser();
        fc.addChoosableFileFilter(new ImageFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileView(new ImageFileView());
        fc.setAccessory(new ImagePreview(fc));
        int returnVal = fc.showDialog(this, this.i18n.getString("dialog.select"));
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.arg2_baseTimeImg.argField.setText(file.getName());
        }
        fc.setSelectedFile(null);
    }

    public static ImageIcon createImageIcon(String path) {
        URL imgURL = AdjustTime.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    void outputIMG_Action(ActionEvent event) {
        this.arg5_outputFolder.setEnabled(this.outputIMG.isEnabled());
    }

    void outputIMGall_Action(ActionEvent event) {
    }

    void exifON_Action(ActionEvent event) {
    }

    void gpxOutputWpt_Action(ActionEvent event) {
    }

    void gpxOutputSpeed_Action(ActionEvent event) {
    }

    void doButton_Action(ActionEvent event) {
        this.doButton.setEnabled(false);
        String[] argv = new String[]{};
        this.params.setProperty(AppParameters.GPX_NO_FIRST_NODE, String.valueOf(this.noFirstNode.isSelected()));
        this.params.setProperty(AppParameters.GPX_REUSE, String.valueOf(this.gpxReuse.isSelected()));
        this.params.setProperty(AppParameters.GPX_SOURCE_FOLDER, this.arg4_gpxFolder.getText());
        if (this.exifBase.isSelected()) {
            this.params.setProperty(AppParameters.GPX_BASETIME, "EXIF_TIME");
        } else {
            this.params.setProperty(AppParameters.GPX_BASETIME, "FILE_UPDATE");
        }
        try {
            this.params.setProperty(AppParameters.IMG_SOURCE_FOLDER, this.arg1_srcFolder.getText());
            this.params.setProperty(AppParameters.IMG_BASE_FILE, this.arg2_baseTimeImg.getText());
            this.params.setProperty(AppParameters.IMG_TIME, ImportPicture.toUTCString(this.dfjp.parse(this.arg3_basetime.getText())));
            this.params.setProperty(AppParameters.IMG_OUTPUT, String.valueOf(this.outputIMG.isSelected()));
            this.params.setProperty(AppParameters.IMG_OUTPUT_FOLDER, this.arg5_outputFolder.getText());
            this.params.setProperty(AppParameters.IMG_OUTPUT_ALL, String.valueOf(this.outputIMG_all.isSelected()));
            this.params.setProperty(AppParameters.IMG_OUTPUT_EXIF, String.valueOf(this.exifON.isSelected()));
            this.params.setProperty(AppParameters.GPX_OVERWRITE_MAGVAR, String.valueOf(this.gpxOverwriteMagvar.isSelected()));
            this.params.setProperty(AppParameters.GPX_OUTPUT_SPEED, String.valueOf(this.gpxOutputSpeed.isSelected()));
            this.params.setProperty(AppParameters.GPX_OUTPUT_WPT, String.valueOf(this.gpxOutputWpt.isSelected()));
            this.params.store();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new DoDialog(this, argv).setVisible(true);
        this.doButton.setEnabled(true);
    }

    void nextButton_Action(ActionEvent event) {
        if (this.cardPanelNo + 1 < this.cards.length) {
            ++this.cardPanelNo;
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, String.valueOf(this.cardPanelNo));
        }
    }

    void backButton_Action(ActionEvent event) {
        if (this.cardPanelNo - 1 >= 0) {
            --this.cardPanelNo;
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, String.valueOf(this.cardPanelNo));
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == AdjustTime.this.miAbout) {
                AdjustTime.this.miAbout_Action(event);
            } else if (object == AdjustTime.this.miExit) {
                AdjustTime.this.miExit_Action(event);
            } else if (object == AdjustTime.this.openButton) {
                AdjustTime.this.imageView_Action(event);
            } else if (object == AdjustTime.this.zoomInButton) {
                AdjustTime.this.zoomin_Action(event);
            } else if (object == AdjustTime.this.zoomOutButton) {
                AdjustTime.this.zoomout_Action(event);
            } else if (object == AdjustTime.this.arg2_baseTimeImg.argField) {
                AdjustTime.this.imageView_Action(event);
            } else if (object == AdjustTime.this.arg2_baseTimeImg.openButton) {
                AdjustTime.this.selectImage_Action(event);
                AdjustTime.this.imageView_Action(event);
            } else if (object == AdjustTime.this.outputIMG) {
                AdjustTime.this.outputIMG_Action(event);
            } else if (object == AdjustTime.this.outputIMG_all) {
                AdjustTime.this.outputIMGall_Action(event);
            } else if (object == AdjustTime.this.exifON) {
                AdjustTime.this.exifON_Action(event);
            } else if (object == AdjustTime.this.gpxOutputWpt) {
                AdjustTime.this.gpxOutputWpt_Action(event);
            } else if (object == AdjustTime.this.gpxOutputSpeed) {
                AdjustTime.this.gpxOutputSpeed_Action(event);
            } else if (object == AdjustTime.this.doButton) {
                AdjustTime.this.doButton_Action(event);
            } else if (object == AdjustTime.this.nextButton) {
                AdjustTime.this.nextButton_Action(event);
            } else if (object == AdjustTime.this.backButton) {
                AdjustTime.this.backButton_Action(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == AdjustTime.this) {
                AdjustTime.this.DbMang_WindowClosing(event);
            }
        }
    }
}

