/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import osm.jp.gpx.AppParameters;
import osm.jp.gpx.Complementation;
import osm.jp.gpx.ElementMapTRKPT;
import osm.jp.gpx.ElementMapTRKSEG;
import osm.jp.gpx.GpxFile;
import osm.jp.gpx.TagTrkpt;

public class ImportPicture
extends Thread {
    public Exception ex = null;
    protected static final String LOGGING_PROPERTIES_DATA = "handlers=java.util.logging.ConsoleHandler\n.level=FINEST\njava.util.logging.ConsoleHandler.level=INFO\njava.util.logging.ConsoleHandler.formatter=osm.jp.gpx.YuuLogFormatter";
    public static final Logger LOGGER;
    public File gpxDir;
    public File imgDir;
    public File outDir;
    public long delta = 0L;
    public boolean exif = false;
    public boolean exifBase = false;
    public ArrayList<File> gpxFiles = new ArrayList();
    public AppParameters params;
    public boolean param_GpxSplit = false;
    public static boolean param_GpxNoFirstNode;
    public boolean param_GpxReuse = false;
    public boolean param_GpxOutputWpt = true;
    public boolean param_ImgOutputAll = false;
    public String param_GpxSourceFolder = ".";
    public static final String TIME_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String EXIF_DATE_TIME_FORMAT_STRING = "yyyy:MM:dd HH:mm:ss";
    public ResourceBundle i18n = ResourceBundle.getBundle("i18n");

    public static void main(String[] argv) throws Exception {
        ImportPicture obj = new ImportPicture();
        obj.setUp(argv.length < 1 ? "AdjustTime.ini" : argv[0]);
    }

    public void setUp(String paramFilePath) throws Exception {
        System.out.println("Param File = '" + paramFilePath + "'");
        this.params = new AppParameters(paramFilePath);
        System.out.println(" - param\uff1a " + AppParameters.IMG_TIME + "=" + this.params.getProperty(AppParameters.IMG_TIME));
        System.out.println(" - param\uff1a " + AppParameters.IMG_BASE_FILE + "=" + this.params.getProperty(AppParameters.IMG_BASE_FILE));
        System.out.println(" - param\uff1a " + AppParameters.GPX_BASETIME + "=" + this.params.getProperty(AppParameters.GPX_BASETIME));
        System.out.println(" - param\uff1a " + AppParameters.IMG_SOURCE_FOLDER + "=" + this.params.getProperty(AppParameters.IMG_SOURCE_FOLDER));
        System.out.println(" - param\uff1a " + AppParameters.IMG_OUTPUT_FOLDER + "=" + this.params.getProperty(AppParameters.IMG_OUTPUT_FOLDER));
        System.out.println(" - param\uff1a " + AppParameters.IMG_OUTPUT + "=" + this.params.getProperty(AppParameters.IMG_OUTPUT));
        System.out.println(" - param\uff1a " + AppParameters.IMG_OUTPUT_ALL + "=" + this.param_ImgOutputAll);
        System.out.println(" - param\uff1a " + AppParameters.IMG_OUTPUT_EXIF + "= " + String.valueOf(this.exif));
        System.out.println(" - param\uff1a " + AppParameters.GPX_SOURCE_FOLDER + "=" + this.param_GpxSourceFolder);
        System.out.println(" - param\uff1a " + AppParameters.GPX_OUTPUT_WPT + "=" + this.param_GpxOutputWpt);
        System.out.println(" - param\uff1a " + AppParameters.GPX_OVERWRITE_MAGVAR + "=" + Complementation.param_GpxOverwriteMagvar);
        System.out.println(" - param\uff1a " + AppParameters.GPX_OUTPUT_SPEED + "=" + Complementation.param_GpxOutputSpeed);
        System.out.println(" - param\uff1a " + AppParameters.GPX_GPXSPLIT + "=" + this.param_GpxSplit);
        System.out.println(" - param\uff1a " + AppParameters.GPX_NO_FIRST_NODE + "=" + param_GpxNoFirstNode);
        System.out.println(" - param\uff1a " + AppParameters.GPX_REUSE + "=" + this.param_GpxReuse);
        this.ex = null;
        this.imgDir = new File(this.params.getProperty(AppParameters.IMG_SOURCE_FOLDER));
        this.exifBase = this.params.getProperty(AppParameters.GPX_BASETIME).equals("EXIF_TIME");
        Date imgtime = this.adjustTime(new File(this.imgDir, this.params.getProperty(AppParameters.IMG_BASE_FILE)));
        this.outDir = new File(this.params.getProperty(AppParameters.IMG_OUTPUT_FOLDER));
        String paramStr = this.params.getProperty(AppParameters.GPX_GPXSPLIT);
        if (paramStr != null && paramStr.equals(Boolean.toString(true))) {
            this.param_GpxSplit = true;
        }
        if ((paramStr = this.params.getProperty(AppParameters.GPX_NO_FIRST_NODE)) != null && paramStr.equals(Boolean.toString(true))) {
            param_GpxNoFirstNode = true;
        }
        if ((paramStr = this.params.getProperty(AppParameters.GPX_REUSE)) != null && paramStr.equals(Boolean.toString(true))) {
            this.param_GpxReuse = true;
        }
        if ((paramStr = this.params.getProperty(AppParameters.IMG_OUTPUT_ALL)) != null && paramStr.equals(Boolean.toString(true))) {
            this.param_ImgOutputAll = true;
        }
        if ((paramStr = this.params.getProperty(AppParameters.GPX_OUTPUT_WPT)) != null && paramStr.equals(Boolean.toString(true))) {
            this.param_GpxOutputWpt = true;
        }
        if ((paramStr = this.params.getProperty(AppParameters.GPX_OVERWRITE_MAGVAR)) != null && paramStr.equals(Boolean.toString(true))) {
            Complementation.param_GpxOverwriteMagvar = true;
        }
        if ((paramStr = this.params.getProperty(AppParameters.GPX_OUTPUT_SPEED)) != null && paramStr.equals(Boolean.toString(true))) {
            Complementation.param_GpxOutputSpeed = true;
        }
        if ((paramStr = this.params.getProperty(AppParameters.GPX_SOURCE_FOLDER)) != null) {
            this.param_GpxSourceFolder = paramStr;
            this.gpxDir = new File(this.param_GpxSourceFolder);
            if (!this.gpxDir.exists()) {
                System.out.println(String.format(this.i18n.getString("msg.100"), paramStr));
                return;
            }
        } else {
            this.gpxDir = this.imgDir;
        }
        if (this.gpxDir.isDirectory()) {
            File[] files = this.gpxDir.listFiles();
            if (files == null) {
                System.out.println(String.format(this.i18n.getString("msg.110"), this.gpxDir.getAbsolutePath()));
                return;
            }
            if (this.param_ImgOutputAll && files.length > 1) {
                System.out.println(this.i18n.getString("msg.120"));
                return;
            }
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return file1.getName().compareTo(file2.getName());
                }
            });
            for (File file : files) {
                String filename;
                if (!file.isFile() || !(filename = file.getName().toUpperCase()).toUpperCase().endsWith(".GPX") || filename.toUpperCase().endsWith("_.GPX") && !this.param_GpxReuse) continue;
                this.gpxFiles.add(file);
            }
        } else {
            this.gpxFiles.add(this.gpxDir);
        }
        paramStr = this.params.getProperty(AppParameters.IMG_OUTPUT_EXIF);
        if (paramStr != null && paramStr.equals(Boolean.toString(true))) {
            this.exif = true;
        }
        String timeStr = this.params.getProperty(AppParameters.IMG_TIME);
        try {
            Date t = ImportPicture.toUTCDate(timeStr);
            this.delta = t.getTime() - imgtime.getTime();
        }
        catch (ParseException e) {
            System.out.println(String.format(this.i18n.getString("msg.130"), timeStr, TIME_FORMAT_STRING));
            return;
        }
        this.start();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.ex != null) {
            throw this.ex;
        }
    }

    @Override
    public void run() {
        try {
            this.outDir = this.params.getProperty(AppParameters.IMG_OUTPUT).equals(Boolean.toString(true)) ? new File(this.outDir, this.imgDir.getName()) : this.gpxDir;
            for (File gpxFile : this.gpxFiles) {
                this.procGPXfile(new GpxFile(gpxFile));
            }
        }
        catch (IOException | IllegalArgumentException | ParseException | ParserConfigurationException | TransformerException | ImageReadException | ImageWriteException | DOMException | SAXException e) {
            e.printStackTrace();
            this.ex = new Exception(e);
        }
    }

    void procGPXfile(GpxFile gpxFile) throws ParserConfigurationException, SAXException, IOException, ParseException, ImageReadException, ImageWriteException, TransformerException {
        System.gc();
        System.out.println("time difference: " + this.delta / 1000L + "(sec)");
        System.out.println("     Target GPX: [" + gpxFile.getAbsolutePath() + "]");
        System.out.println("           EXIF: " + (this.exif ? "convert to '" + this.outDir.getAbsolutePath() + "'" : "off"));
        System.out.println();
        System.out.println("|--------------------------------|--------------------|--------------------|--------------|--------------|--------|------|------|");
        System.out.println("| name                           | Camera Time        | GPStime            |   Latitude   |   Longitude  | ele    |magvar| km/h |");
        System.out.println("|--------------------------------|--------------------|--------------------|--------------|--------------|--------|------|------|");
        this.proc(this.imgDir, this.delta, gpxFile.mapTRKSEG, this.exif, gpxFile);
        System.out.println("|--------------------------------|--------------------|--------------------|--------------|--------------|--------|------|------|");
        gpxFile.output(this.outDir);
    }

    boolean proc(File dir, long delta, ElementMapTRKSEG mapTRKSEG, boolean exifWrite, GpxFile gpxFile) throws ParseException, ImageReadException, IOException, ImageWriteException {
        boolean ret = false;
        File[] files = dir.listFiles(new JpegFileFilter());
        Arrays.sort(files, new FileSort());
        block3: for (File image : files) {
            System.out.print(String.format("|%-32s|", image.getName()));
            if (image.isDirectory()) {
                ret = this.proc(image, delta, mapTRKSEG, exifWrite, gpxFile);
                continue;
            }
            String imageName = image.getName();
            if (!ImportPicture.checkFile(imageName)) {
                System.out.println(String.format("%20s ", "it is not image file."));
                continue;
            }
            Discripter result = this.procImageFile(image, delta, mapTRKSEG, exifWrite, gpxFile);
            ret |= result.ret;
            switch (result.control) {
                case -1: {
                    continue block3;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Discripter procImageFile(File imageFile, long delta, ElementMapTRKSEG mapTRKSEG, boolean exifWrite, GpxFile gpxFile) throws ParseException, ImageReadException, IOException, ImageWriteException {
        Map.Entry map;
        ElementMapTRKPT mapTRKPT;
        Discripter result = new Discripter(false);
        Date itime = new Date(imageFile.lastModified());
        if (this.exifBase) {
            ImageMetadata meta = Imaging.getMetadata((File)imageFile);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)meta;
            if (jpegMetadata == null) {
                System.out.println(String.format(this.i18n.getString("msg.140"), imageFile.getAbsolutePath()));
                result.control = -1;
                return result;
            }
            TiffImageMetadata exif = jpegMetadata.getExif();
            if (exif == null) {
                System.out.println(String.format(this.i18n.getString("msg.140"), imageFile.getAbsolutePath()));
                result.control = -1;
                return result;
            }
            String dateTimeOriginal = exif.getFieldValue(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL)[0];
            itime = ImportPicture.toEXIFDate(dateTimeOriginal);
        }
        System.out.print(String.format("%20s|", ImportPicture.toUTCString(itime)));
        Date correctedtime = new Date(itime.getTime() + delta);
        System.out.print(String.format("%20s|", ImportPicture.toUTCString(correctedtime)));
        String eleStr = "-";
        String magvarStr = "-";
        String speedStr = "-";
        double latitude = 90.5;
        double longitude = 180.5;
        TagTrkpt trkptT = null;
        Iterator iterator = mapTRKSEG.entrySet().iterator();
        while (iterator.hasNext() && (trkptT = (mapTRKPT = (ElementMapTRKPT)(map = iterator.next()).getValue()).getValue(correctedtime)) == null) {
        }
        if (trkptT == null) {
            System.out.print(String.format("%-14s|%-14s|", "", ""));
            System.out.println(String.format("%8s|%6s|%6s|", "", "", ""));
            if (!this.param_ImgOutputAll) {
                result.control = -1;
                return result;
            }
        } else {
            latitude = trkptT.lat;
            longitude = trkptT.lon;
            if (trkptT.eleStr != null) {
                eleStr = trkptT.eleStr;
            }
            if (trkptT.magvarStr != null) {
                magvarStr = trkptT.magvarStr;
            }
            if (trkptT.speedStr != null) {
                speedStr = trkptT.speedStr;
            }
            System.out.print(String.format("%14.10f|%14.10f|", latitude, longitude));
            System.out.println(String.format("%8s|%6s|%6s|", eleStr, magvarStr, speedStr));
        }
        result.ret = true;
        this.outDir.mkdir();
        if (exifWrite) {
            this.exifWrite(imageFile, correctedtime, trkptT);
            if (Boolean.parseBoolean(this.params.getProperty(AppParameters.GPX_OUTPUT_WPT)) && trkptT != null) {
                Element temp = gpxFile.createWptTag(imageFile, this.imgDir, itime.getTime(), trkptT.trkpt);
                gpxFile.gpx.appendChild(temp);
            }
        } else if (this.param_ImgOutputAll) {
            FileInputStream sStream = new FileInputStream(imageFile);
            FileInputStream dStream = new FileInputStream(new File(this.outDir, imageFile.getName()));
            FileChannel srcChannel = sStream.getChannel();
            FileChannel destChannel = dStream.getChannel();
            try {
                srcChannel.transferTo(0L, srcChannel.size(), destChannel);
            }
            finally {
                srcChannel.close();
                destChannel.close();
                sStream.close();
                dStream.close();
            }
        }
        result.control = 0;
        return result;
    }

    void exifWrite(File imageFile, Date correctedtime, TagTrkpt trkptT) throws ImageReadException, IOException, ImageWriteException {
        TiffImageMetadata exif;
        DecimalFormat yearFormatter = new DecimalFormat("0000");
        DecimalFormat monthFormatter = new DecimalFormat("00");
        DecimalFormat dayFormatter = new DecimalFormat("00");
        TiffOutputSet outputSet = null;
        ImageMetadata meta = Imaging.getMetadata((File)imageFile);
        JpegImageMetadata jpegMetadata = (JpegImageMetadata)meta;
        if (jpegMetadata != null && (exif = jpegMetadata.getExif()) != null) {
            outputSet = exif.getOutputSet();
        }
        if (outputSet == null) {
            outputSet = new TiffOutputSet();
        }
        TiffOutputDirectory exifDir = outputSet.getOrCreateExifDirectory();
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(correctedtime);
        exifDir.removeField((TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
        exifDir.add(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL, new String[]{ImportPicture.toEXIFString(cal.getTime())});
        TiffOutputDirectory gpsDir = outputSet.getOrCreateGPSDirectory();
        Calendar cal2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal2.setTimeZone(TimeZone.getTimeZone("GMT+00"));
        cal2.setTime(correctedtime);
        String yearStr = yearFormatter.format(cal2.get(1));
        String monthStr = monthFormatter.format(cal2.get(2) + 1);
        String dayStr = dayFormatter.format(cal2.get(5));
        String dateStamp = yearStr + ":" + monthStr + ":" + dayStr;
        gpsDir.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_TIME_STAMP);
        gpsDir.add(GpsTagConstants.GPS_TAG_GPS_TIME_STAMP, new RationalNumber[]{RationalNumber.valueOf((double)cal2.get(11)), RationalNumber.valueOf((double)cal2.get(12)), RationalNumber.valueOf((double)cal2.get(13))});
        gpsDir.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_DATE_STAMP);
        gpsDir.add(GpsTagConstants.GPS_TAG_GPS_DATE_STAMP, new String[]{dateStamp});
        if (trkptT != null) {
            if (trkptT.eleStr != null) {
                double altitude = Double.parseDouble(trkptT.eleStr);
                gpsDir.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_ALTITUDE);
                gpsDir.add(GpsTagConstants.GPS_TAG_GPS_ALTITUDE, RationalNumber.valueOf((double)altitude));
            }
            if (trkptT.magvarStr != null) {
                double magvar = Double.parseDouble(trkptT.magvarStr);
                gpsDir.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
                gpsDir.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION, RationalNumber.valueOf((double)magvar));
            }
            outputSet.setGPSInDegrees(trkptT.lon.doubleValue(), trkptT.lat.doubleValue());
        }
        ExifRewriter rewriter = new ExifRewriter();
        try (FileOutputStream fos = new FileOutputStream(new File(this.outDir, imageFile.getName()));){
            rewriter.updateExifMetadataLossy(imageFile, (OutputStream)fos, outputSet);
        }
    }

    private Date adjustTime(File baseFile) throws ImageReadException, IOException, ParseException {
        if (this.exifBase) {
            ImageMetadata meta = Imaging.getMetadata((File)baseFile);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)meta;
            if (jpegMetadata == null) {
                System.out.println(String.format(this.i18n.getString("msg.140"), baseFile.getAbsolutePath()));
                return null;
            }
            TiffImageMetadata exif = jpegMetadata.getExif();
            if (exif == null) {
                System.out.println(String.format(this.i18n.getString("msg.140"), baseFile.getAbsolutePath()));
                return null;
            }
            String dateTimeOriginal = exif.getFieldValue(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL)[0];
            return new Date(ImportPicture.toEXIFDate(dateTimeOriginal).getTime());
        }
        return new Date(baseFile.lastModified());
    }

    public static boolean checkFile(String name) {
        return name != null && name.toUpperCase().endsWith(".JPG");
    }

    public static String toEXIFString(Date localdate) {
        SimpleDateFormat dfUTC = new SimpleDateFormat(EXIF_DATE_TIME_FORMAT_STRING);
        return dfUTC.format(localdate);
    }

    public static Date toEXIFDate(String timeStr) throws ParseException {
        SimpleDateFormat dfUTC = new SimpleDateFormat(EXIF_DATE_TIME_FORMAT_STRING);
        return dfUTC.parse(timeStr);
    }

    public static String toUTCString(Date localdate) {
        SimpleDateFormat dfUTC = new SimpleDateFormat(TIME_FORMAT_STRING);
        dfUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dfUTC.format(localdate);
    }

    public static Date toUTCDate(String timeStr) throws ParseException {
        SimpleDateFormat dfUTC = new SimpleDateFormat(TIME_FORMAT_STRING);
        dfUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dfUTC.parse(timeStr);
    }

    static String getShortPathName(File dir, File iFile) {
        String dirPath = dir.getAbsolutePath();
        String filePath = iFile.getAbsolutePath();
        if (filePath.startsWith(dirPath)) {
            return filePath.substring(dirPath.length() + 1);
        }
        return filePath;
    }

    static {
        String str;
        LOGGER = Logger.getLogger("CommandLogging");
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(LOGGING_PROPERTIES_DATA.getBytes("UTF-8"));
            try {
                LogManager.getLogManager().readConfiguration(inStream);
                LOGGER.config("LoggerSettings: LogManager setuped.");
            }
            catch (IOException e) {
                String str2 = "LoggerSettings: Exception occered:" + e.toString();
                LOGGER.warning(str2);
            }
        }
        catch (UnsupportedEncodingException e) {
            str = "LoggerSettings: Not supported 'UTF-8' encoding: " + e.toString();
            LOGGER.severe(str);
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException e) {
                str = "LoggerSettings: Exception occored: " + e.toString();
                LOGGER.warning(str);
            }
        }
        param_GpxNoFirstNode = false;
    }

    class JpegFileFilter
    implements FilenameFilter {
        JpegFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toUpperCase().matches(".*\\.JPG$");
        }
    }

    static class FileSort
    implements Comparator<File> {
        FileSort() {
        }

        @Override
        public int compare(File src, File target) {
            int diff = src.getName().compareTo(target.getName());
            return diff;
        }
    }

    class Discripter {
        static final int NEXT = 0;
        static final int CONTINUE = -1;
        static final int BREAK = 1;
        public boolean ret;
        public int control;

        public Discripter(boolean ret) {
            this.ret = ret;
            this.control = 0;
        }
    }
}

