/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public abstract class TarGz {
    public static void main(String[] args) throws IOException {
        File baseDir = new File("testdata/cameradata");
        File tazFile = new File("testdata", "Sony20170518.tar.gz");
        TarGz.uncompress(tazFile, baseDir);
    }

    public static void uncompress(File tazFile, File dest) throws IOException {
        dest.mkdir();
        TarArchiveInputStream tarIn = null;
        tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(tazFile))));
        TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
        while (tarEntry != null) {
            File destPath = new File(dest, tarEntry.getName());
            System.out.println("uncompress: " + destPath.getCanonicalPath());
            if (tarEntry.isDirectory()) {
                destPath.mkdirs();
            } else {
                File dir = new File(destPath.getParent());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                destPath.createNewFile();
                byte[] btoRead = new byte[1024];
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destPath));
                int len = 0;
                while ((len = tarIn.read(btoRead)) != -1) {
                    bout.write(btoRead, 0, len);
                }
                bout.close();
                destPath.setLastModified(tarEntry.getLastModifiedDate().getTime());
                btoRead = null;
            }
            tarEntry = tarIn.getNextTarEntry();
        }
        tarIn.close();
    }
}

