/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import osm.jp.gpx.ElementMapTRKSEG;
import osm.jp.gpx.ImportPicture;

public class GpxFile
extends File {
    Node gpx = null;
    ElementMapTRKSEG mapTRKSEG = null;
    Document document;

    public GpxFile(File file) throws ParserConfigurationException, DOMException, SAXException, IOException, ParseException {
        super(file.getParentFile(), file.getName());
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        factory = DocumentBuilderFactory.newInstance();
        builder = factory.newDocumentBuilder();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        factory.setValidating(true);
        this.mapTRKSEG = new ElementMapTRKSEG();
        this.document = this.mapTRKSEG.parse(this);
        this.mapTRKSEG.printinfo();
        this.gpx = builder.parse(this).getFirstChild();
    }

    public void output(File outDir) throws FileNotFoundException, TransformerException {
        String fileName = this.getName();
        String iStr = fileName.substring(0, fileName.length() - 4);
        File outputFile = new File(outDir, iStr + "_.gpx");
        System.out.println(this.getAbsolutePath() + " => " + outputFile.getAbsolutePath());
        outputFile.getParentFile().mkdirs();
        DOMSource source = new DOMSource(this.gpx);
        FileOutputStream os = new FileOutputStream(outputFile);
        StreamResult result = new StreamResult(os);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.transform(source, result);
        os = new FileOutputStream(outputFile);
        result = new StreamResult(os);
        transformer.transform(source, result);
    }

    public Element createWptTag(File iFile, File imgDir, long timestamp, Element trkpt) {
        Element wpt = this.document.createElement("wpt");
        NamedNodeMap nodeMap = trkpt.getAttributes();
        if (null != nodeMap) {
            block20: for (int j = 0; j < nodeMap.getLength(); ++j) {
                switch (nodeMap.item(j).getNodeName()) {
                    case "lat": {
                        String lat = nodeMap.item(j).getNodeValue();
                        wpt.setAttribute("lat", lat);
                        continue block20;
                    }
                    case "lon": {
                        String lon = nodeMap.item(j).getNodeValue();
                        wpt.setAttribute("lon", lon);
                    }
                }
            }
        }
        NodeList nodes1 = trkpt.getChildNodes();
        block21: for (int i1 = 0; i1 < nodes1.getLength(); ++i1) {
            Node node1 = nodes1.item(i1);
            NodeList nodes2 = node1.getChildNodes();
            switch (node1.getNodeName()) {
                case "ele": {
                    Node node2;
                    int i2;
                    for (i2 = 0; i2 < nodes2.getLength(); ++i2) {
                        node2 = nodes2.item(i2);
                        if (node2 == null || node2.getNodeType() != 3) continue;
                        String eleStr = node2.getNodeValue();
                        Element eleE = this.document.createElement("ele");
                        eleE.setTextContent(eleStr);
                        wpt.appendChild(eleE);
                    }
                    continue block21;
                }
                case "time": {
                    Node node2;
                    int i2;
                    for (i2 = 0; i2 < nodes2.getLength(); ++i2) {
                        node2 = nodes2.item(i2);
                        if (node2 == null || node2.getNodeType() != 3) continue;
                        String timeStr = node2.getNodeValue();
                        Element timeE = this.document.createElement("time");
                        timeE.setTextContent(timeStr);
                        wpt.appendChild(timeE);
                    }
                    continue block21;
                }
                case "magvar": {
                    Node node2;
                    int i2;
                    for (i2 = 0; i2 < nodes2.getLength(); ++i2) {
                        node2 = nodes2.item(i2);
                        if (node2 == null || node2.getNodeType() != 3) continue;
                        String magvarStr = node2.getNodeValue();
                        Element magvarE = this.document.createElement("magvar");
                        magvarE.setTextContent(magvarStr);
                        wpt.appendChild(magvarE);
                    }
                    continue block21;
                }
                case "speed": {
                    Node node2;
                    int i2;
                    for (i2 = 0; i2 < nodes2.getLength(); ++i2) {
                        node2 = nodes2.item(i2);
                        if (node2 == null || node2.getNodeType() != 3) continue;
                        String speedStr = node2.getNodeValue();
                        Element speedE = this.document.createElement("speed");
                        speedE.setTextContent(speedStr);
                        wpt.appendChild(speedE);
                    }
                    continue block21;
                }
            }
        }
        Element name = this.document.createElement("name");
        name.appendChild(this.document.createCDATASection("\u5199\u771f"));
        wpt.appendChild(name);
        Element link = this.document.createElement("link");
        link.setAttribute("href", ImportPicture.getShortPathName(imgDir, iFile));
        Element text = this.document.createElement("text");
        text.setTextContent(iFile.getName());
        link.appendChild(text);
        wpt.appendChild(link);
        return wpt;
    }
}

