/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

public class GeoDistance {
    public static final double GRS80_A = 6378137.0;
    public static final double GRS80_E2 = 0.00669438002301188;
    public static final double GRS80_MNUM = 6335439.32708317;
    public static final double WGS84_A = 6378137.0;
    public static final double WGS84_E2 = 0.00669437999019758;
    public static final double WGS84_MNUM = 6335439.32729246;

    public static double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static double calcDistHubeny(double lat1, double lng1, double lat2, double lng2) {
        double my = GeoDistance.deg2rad((lat1 + lat2) / 2.0);
        double dy = GeoDistance.deg2rad(lat1 - lat2);
        double dx = GeoDistance.deg2rad(lng1 - lng2);
        double sin = Math.sin(my);
        double w = Math.sqrt(1.0 - 0.00669438002301188 * sin * sin);
        double m = 6335439.32708317 / (w * w * w);
        double n = 6378137.0 / w;
        double dym = dy * m;
        double dxncos = dx * n * Math.cos(my);
        return Math.sqrt(dym * dym + dxncos * dxncos);
    }

    public static void main(String[] args) {
        System.out.println("Coords Test Program");
        double lat1 = Double.parseDouble(args[0]);
        double lng1 = Double.parseDouble(args[1]);
        double lat2 = Double.parseDouble(args[2]);
        double lng2 = Double.parseDouble(args[3]);
        double d = GeoDistance.calcDistHubeny(lat1, lng1, lat2, lng2);
        System.out.println("Distance = " + d + " m");
    }
}

