/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import osm.jp.gpx.ElementMapTRKPT;
import osm.jp.gpx.ImportPicture;
import osm.jp.gpx.TagTrkpt;
import osm.jp.gpx.TimeComparator;

public class ElementMapTRKSEG
extends TreeMap<Date, ElementMapTRKPT> {
    public static void main(String[] argv) throws DOMException, SAXException, IOException, ParserConfigurationException, ParseException {
        ElementMapTRKSEG mapTRKSEG = null;
        mapTRKSEG = new ElementMapTRKSEG();
        mapTRKSEG.parse(new File("testdata/cameradata/separate.gpx"));
        mapTRKSEG.printinfo();
    }

    public ElementMapTRKSEG() {
        super(new TimeComparator());
    }

    public Document parse(File gpxFile) throws SAXException, IOException, ParserConfigurationException, DOMException, ParseException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        factory.setValidating(true);
        Node gpx = builder.parse(gpxFile).getFirstChild();
        Document document = gpx.getOwnerDocument();
        NodeList nodes = gpx.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node2 = nodes.item(i);
            if (!node2.getNodeName().equals("trk")) continue;
            Element trk = (Element)node2;
            NodeList nodes1 = trk.getChildNodes();
            for (int i1 = 0; i1 < nodes1.getLength(); ++i1) {
                Node nodeTRKSEG = nodes1.item(i1);
                if (!nodeTRKSEG.getNodeName().equals("trkseg")) continue;
                this.put(nodeTRKSEG);
            }
        }
        return document;
    }

    public void put(Node nodeTRKSEG) throws DOMException, ParseException {
        if (nodeTRKSEG.getNodeName().equals("trkseg")) {
            NodeList nodes2 = nodeTRKSEG.getChildNodes();
            ElementMapTRKPT mapTRKPT = new ElementMapTRKPT();
            for (int i2 = 0; i2 < nodes2.getLength(); ++i2) {
                Node nodeTRKPT = nodes2.item(i2);
                if (!nodeTRKPT.getNodeName().equals("trkpt") || ImportPicture.param_GpxNoFirstNode && i2 == 0) continue;
                mapTRKPT.put(new TagTrkpt((Element)nodeTRKPT));
            }
            this.put(mapTRKPT);
        }
    }

    public void put(ElementMapTRKPT value) {
        Iterator iterator = value.keySet().iterator();
        if (iterator.hasNext()) {
            Date key = (Date)iterator.next();
            this.put(key, value);
            return;
        }
    }

    public void printinfo() {
        System.out.println("                                 +--------------------+--------------------|");
        System.out.println("  GPS logging time               | First Time         | Last Time          |");
        System.out.println("|--------------------------------+--------------------+--------------------|");
        for (Map.Entry map : this.entrySet()) {
            ElementMapTRKPT mapTRKPT = (ElementMapTRKPT)map.getValue();
            mapTRKPT.printinfo();
        }
        System.out.println("|--------------------------------+--------------------+--------------------|");
        System.out.println();
    }
}

