/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

import java.text.ParseException;
import java.util.Date;
import java.util.TreeMap;
import org.w3c.dom.DOMException;
import osm.jp.gpx.Complementation;
import osm.jp.gpx.ImportPicture;
import osm.jp.gpx.TagTrkpt;
import osm.jp.gpx.TimeComparator;

public class ElementMapTRKPT
extends TreeMap<Date, TagTrkpt> {
    public static final long DIFF_MAE_TIME = 3000L;
    public static long OVER_TIME_LIMIT = 3000L;

    public ElementMapTRKPT() {
        super(new TimeComparator());
    }

    public Date put(TagTrkpt tag) throws DOMException, ParseException {
        this.put(tag.time, tag);
        return tag.time;
    }

    public TagTrkpt getValue(Date jptime) throws ParseException {
        TagTrkpt imaE = this.getTrkpt(jptime);
        if (imaE != null) {
            TagTrkpt maeE = this.getMaeTrkpt(imaE.time);
            if (maeE != null) {
                Complementation comp = new Complementation(imaE, maeE);
                if (Complementation.param_GpxOverwriteMagvar) {
                    comp.complementationMagvar();
                }
                if (Complementation.param_GpxOutputSpeed) {
                    comp.complementationSpeed();
                }
                return comp.imaTag;
            }
            return imaE;
        }
        return null;
    }

    private TagTrkpt getTrkpt(Date jptime) throws ParseException {
        Date keyTime = null;
        for (Date key : this.keySet()) {
            int flag = jptime.compareTo(key);
            if (flag < 0) {
                if (keyTime != null) {
                    return (TagTrkpt)this.get(keyTime);
                }
                return null;
            }
            if (flag == 0) {
                return (TagTrkpt)this.get(key);
            }
            if (flag <= 0) continue;
            keyTime = new Date(key.getTime());
        }
        if (keyTime != null && Math.abs(keyTime.getTime() - jptime.getTime()) <= OVER_TIME_LIMIT) {
            return (TagTrkpt)this.get(keyTime);
        }
        return null;
    }

    private TagTrkpt getMaeTrkpt(Date time) throws ParseException {
        Date maeTime = null;
        for (Date key : this.keySet()) {
            int flag = time.compareTo(key);
            if (flag > 0) {
                maeTime = new Date(key.getTime());
                continue;
            }
            if (flag == 0) {
                if (maeTime == null) {
                    return null;
                }
                return (TagTrkpt)this.get(maeTime);
            }
            if (maeTime == null) {
                return null;
            }
            if (Math.abs(maeTime.getTime() - time.getTime()) > OVER_TIME_LIMIT) {
                return null;
            }
            return (TagTrkpt)this.get(maeTime);
        }
        return null;
    }

    public void printinfo() {
        Date firstTime = null;
        Date lastTime = null;
        for (Date key : this.keySet()) {
            if (firstTime == null) {
                firstTime = new Date(key.getTime());
            }
            lastTime = new Date(key.getTime());
        }
        System.out.println(String.format("|                      <trkseg/> |%20s|%20s|", ImportPicture.toUTCString(firstTime), ImportPicture.toUTCString(lastTime)));
    }
}

