/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

import java.text.ParseException;
import osm.jp.gpx.GeoDistance;
import osm.jp.gpx.TagTrkpt;

public class Complementation {
    public static final Double R = 6367444.657;
    public TagTrkpt imaTag = null;
    public TagTrkpt maeTag = null;
    public static boolean param_GpxOutputSpeed = false;
    public static boolean param_GpxOverwriteMagvar = false;

    public Complementation(TagTrkpt imaE, TagTrkpt maeE) throws ParseException {
        this.imaTag = new TagTrkpt(imaE.trkpt);
        if (maeE != null) {
            this.maeTag = new TagTrkpt(maeE.trkpt);
        }
    }

    public void complementationSpeed() {
        if (this.imaTag.speedStr != null) {
            try {
                Double.parseDouble(this.imaTag.speedStr);
            }
            catch (NumberFormatException e) {
                this.imaTag.removeElement("speed");
                this.imaTag.speedStr = null;
            }
        }
        if (this.imaTag.speedStr == null) {
            double d = GeoDistance.calcDistHubeny(this.imaTag.lat, this.imaTag.lon, this.maeTag.lat, this.maeTag.lon);
            String str = Double.toString(d * 3600.0 / (double)(this.imaTag.time.getTime() - this.maeTag.time.getTime()));
            int iDot = str.indexOf(46);
            if (iDot > 0) {
                str = str.substring(0, iDot + 2);
            }
            this.imaTag.appendElement("speed", str);
            this.imaTag.speedStr = new String(str);
        }
    }

    public void complementationMagvar() throws ParseException {
        if (this.imaTag.magvarStr != null) {
            try {
                Double.parseDouble(this.imaTag.magvarStr);
            }
            catch (NumberFormatException e) {
                this.imaTag.removeElement("magvar");
                this.imaTag.magvarStr = null;
            }
        }
        if (this.imaTag.magvarStr == null) {
            Double r = Math.cos(Math.toRadians((this.imaTag.lat + this.maeTag.lat) / 2.0)) * R;
            Double x = Math.toRadians(this.imaTag.lon - this.maeTag.lon) * r;
            Double y = Math.toRadians(this.imaTag.lat - this.maeTag.lat) * R;
            double rad = Math.toDegrees(Math.atan2(y, x));
            rad = y >= 0.0 ? (x >= 0.0 ? 0.0 - (rad - 90.0) : 360.0 - (rad - 90.0)) : (x >= 0.0 ? 90.0 - rad : 90.0 - rad);
            String str = Double.toString(rad);
            int iDot = str.indexOf(46);
            if (iDot > 0) {
                str = str.substring(0, iDot);
            }
            this.imaTag.appendElement("magvar", str);
            this.imaTag.magvarStr = new String(str);
        }
    }
}

