/*
 * Decompiled with CFR 0.152.
 */
package jp.ikikko.bti.gdata;

import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.spreadsheet.CustomElementCollection;
import com.google.gdata.data.spreadsheet.ListEntry;
import com.google.gdata.data.spreadsheet.ListFeed;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import jp.ikikko.bti.backlog.BacklogDataRegistry;
import jp.ikikko.bti.entity.Issue;
import jp.ikikko.bti.entity.User;
import org.apache.commons.lang.StringUtils;

public class GdataService {
    private static final String SERVICE_COMPANY = "ikikko";
    private static final String SERVICE_APPLICATION = "backlogTemplateIssue";
    private static final String SERVICE_VERSION = "1.0";
    private static DateFormat format = new SimpleDateFormat("yyyy/MM/dd");
    private final SpreadsheetService service;

    public GdataService() {
        String serviceName = StringUtils.join(new Object[]{SERVICE_COMPANY, SERVICE_APPLICATION, SERVICE_VERSION}, "-");
        this.service = new SpreadsheetService(serviceName);
    }

    public void login(String username, String password) throws AuthenticationException {
        this.service.setUserCredentials(username, password);
    }

    public Collection<Issue> getTemplateIssues(URL url, BacklogDataRegistry backlogDataRegistry) throws ServiceException, IOException {
        String key = this.getSpreadsheetKey(url);
        URL entryUrl = new URL("http://spreadsheets.google.com/feeds/spreadsheets/" + key);
        SpreadsheetEntry spreadsheet = this.service.getEntry(entryUrl, SpreadsheetEntry.class);
        WorksheetEntry worksheet = spreadsheet.getDefaultWorksheet();
        ListFeed listFeed = this.service.getFeed(worksheet.getListFeedUrl(), ListFeed.class);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (ListEntry list : listFeed.getEntries()) {
            issues.add(this.createIssueFromSingleList(list, backlogDataRegistry));
        }
        return issues;
    }

    String getSpreadsheetKey(URL url) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : url.getQuery().split("&")) {
            String key = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(key, value);
        }
        return (String)map.get("key");
    }

    Issue createIssueFromSingleList(ListEntry list, BacklogDataRegistry backlogDataRegistry) {
        User registeredUser;
        Issue issue = new Issue();
        CustomElementCollection elements = list.getCustomElements();
        issue.setSummary(elements.getValue("\u4ef6\u540d"));
        issue.setDescription(elements.getValue("\u8a73\u7d30"));
        if (elements.getValue("\u958b\u59cb\u65e5") != null) {
            try {
                issue.setStartDate(format.parse(elements.getValue("\u958b\u59cb\u65e5")));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (elements.getValue("\u671f\u9650\u65e5") != null) {
            try {
                issue.setDueDate(format.parse(elements.getValue("\u671f\u9650\u65e5")));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (elements.getValue("\u4e88\u5b9a\u6642\u9593") != null) {
            issue.setEstimatedHours(Double.valueOf(elements.getValue("\u4e88\u5b9a\u6642\u9593")));
        }
        if (elements.getValue("\u5b9f\u7e3e\u6642\u9593") != null) {
            issue.setActualHours(Double.valueOf(elements.getValue("\u5b9f\u7e3e\u6642\u9593")));
        }
        issue.setIssueType(elements.getValue("\u7a2e\u5225\u540d"));
        issue.setComponents(new String[]{elements.getValue("\u30ab\u30c6\u30b4\u30ea\u540d")});
        issue.setAffectsVersions(new String[]{elements.getValue("\u767a\u751f\u30d0\u30fc\u30b8\u30e7\u30f3\u540d")});
        issue.setMilestoneVersions(new String[]{elements.getValue("\u30de\u30a4\u30eb\u30b9\u30c8\u30fc\u30f3\u540d")});
        if (elements.getValue("\u512a\u5148\u5ea6ID") != null) {
            issue.setPriority(Integer.valueOf(elements.getValue("\u512a\u5148\u5ea6ID")));
        }
        if (elements.getValue("\u62c5\u5f53\u8005\u30e6\u30fc\u30b6\u540d") != null && (registeredUser = backlogDataRegistry.getRegisteredUser(elements.getValue("\u62c5\u5f53\u8005\u30e6\u30fc\u30b6\u540d"))) != null) {
            issue.setAssignerUser(registeredUser);
        }
        return issue;
    }
}

