/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.io.IOException;
import net.sf.jasperreports.components.sort.SortComponent;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class SortComponentXmlWriter
implements ComponentXmlWriter {
    public static final String PROPERTY_HANDLER_FONT_SIZE = "handlerFontSize";
    private JasperReportsContext jasperReportsContext;
    private final String version;
    private final VersionComparator versionComparator;

    public SortComponentXmlWriter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public SortComponentXmlWriter(JasperReportsContext jasperReportsContext) {
        this(jasperReportsContext, null, new VersionComparator());
    }

    public SortComponentXmlWriter(JasperReportsContext jasperReportsContext, String version, VersionComparator versionComparator) {
        this.jasperReportsContext = jasperReportsContext;
        this.version = version;
        this.versionComparator = versionComparator;
    }

    @Override
    public boolean isToWrite(JRComponentElement componentElement, JRXmlWriter reportWriter) {
        return this.isNewerVersionOrEqual(this.version, "4.1.1");
    }

    @Override
    public void writeToXml(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        if (component instanceof SortComponent) {
            SortComponent sortComponent = (SortComponent)component;
            ComponentKey componentKey = componentElement.getComponentKey();
            this.writeSortComponent(sortComponent, componentKey, reportWriter);
        }
    }

    protected void writeSortComponent(SortComponent sortComponent, ComponentKey componentKey, JRXmlWriter reportWriter) throws IOException {
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        String namespaceURI = componentKey.getNamespace();
        String schemaLocation = ComponentsEnvironment.getInstance(this.jasperReportsContext).getBundle(namespaceURI).getXmlParser().getPublicSchemaLocation();
        XmlNamespace componentNamespace = new XmlNamespace(namespaceURI, componentKey.getNamespacePrefix(), schemaLocation);
        writer.startElement("sort", componentNamespace);
        if (this.isOlderVersionThan(this.version, "4.1.3")) {
            writer.addAttribute("sortFieldName", sortComponent.getSortFieldName());
            writer.addAttribute("sortFieldType", sortComponent.getSortFieldType());
            writer.addAttribute("handlerColor", sortComponent.getHandlerColor());
            writer.addAttribute(PROPERTY_HANDLER_FONT_SIZE, sortComponent.getSymbolFont().getFontSize());
            writer.addAttribute("handlerHorizontalAlign", sortComponent.getHandlerHorizontalAlign());
            writer.addAttribute("handlerVerticalAlign", sortComponent.getHandlerVerticalAlign());
        }
        if (sortComponent.getEvaluationTime() != EvaluationTimeEnum.NOW) {
            writer.addAttribute("evaluationTime", sortComponent.getEvaluationTime());
        }
        writer.addAttribute("evaluationGroup", sortComponent.getEvaluationGroup());
        if (this.isNewerVersionOrEqual(this.version, "4.1.3")) {
            writer.startElement("symbol");
            if (sortComponent.getHandlerColor() != null) {
                writer.addAttribute("handlerColor", sortComponent.getHandlerColor());
            }
            writer.addAttribute("sortFieldType", sortComponent.getSortFieldType());
            writer.addAttribute("sortFieldName", sortComponent.getSortFieldName());
            writer.addAttribute("handlerHorizontalAlign", sortComponent.getHandlerHorizontalAlign());
            writer.addAttribute("handlerVerticalAlign", sortComponent.getHandlerVerticalAlign());
            reportWriter.writeFont(sortComponent.getSymbolFont());
            writer.closeElement();
        }
        writer.closeElement();
    }

    protected boolean isNewerVersionOrEqual(String currentVersion, String oldVersion) {
        return this.versionComparator.compare(currentVersion, oldVersion) >= 0;
    }

    protected boolean isOlderVersionThan(String currentVersion, String version) {
        return this.versionComparator.compare(currentVersion, version) < 0;
    }

    protected void writeExpression(String name, XmlNamespace namespace, JRExpression expression, boolean writeClass, JRXmlWriteHelper writer) throws IOException {
        if (this.isNewerVersionOrEqual(this.version, "4.1.1")) {
            writer.writeExpression(name, namespace, expression);
        } else {
            writer.writeExpression(name, namespace, expression, writeClass);
        }
    }
}

