/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.swing.CEditor;
import org.compiere.swing.CFieldEditor;
import org.compiere.swing.CFieldPopup;

public class CField
extends JComboBox
implements CEditor,
ActionListener {
    private static final long serialVersionUID = -2570380982649145678L;
    private CFieldEditor m_editor = null;
    private Class<?> m_popupClass = null;
    private String m_title = null;
    private Object m_oldValue = null;
    private Icon m_icon = null;
    private boolean m_mandatory = false;

    public static CField createNumeric(NumberFormat format) {
        return null;
    }

    public static CField createNumeric() {
        return CField.createNumeric(new DecimalFormat());
    }

    public static CField createDate(DateFormat format) {
        return null;
    }

    public static CField createDate() {
        return CField.createDate(new SimpleDateFormat());
    }

    public static CField createText(Pattern p2) {
        return null;
    }

    public static CField createText(int length) {
        return null;
    }

    public CField() {
        this(null, null, "");
    }

    public CField(CFieldEditor editor, Class<?> cFieldPopup, String title) {
        super(new Object[]{"1", "2"});
        if (editor != null) {
            this.setEditable(true);
        }
        this.m_title = title;
        if (cFieldPopup != null) {
            Class<?>[] interfaces = cFieldPopup.getInterfaces();
            boolean found = false;
            int i = 0;
            while (i < interfaces.length) {
                if (interfaces[i].equals(CFieldPopup.class)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                throw new IllegalArgumentException("Popup class must be CFieldPopup");
            }
        }
        super.addActionListener(this);
    }

    public void setIcon(Icon defaultIcon) {
        this.m_icon = defaultIcon;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public void setUI(TextUI ui) {
        super.setUI(ui);
    }

    public boolean displayPopup() {
        CFieldPopup popup;
        block7: {
            if (this.m_popupClass == null) {
                return false;
            }
            Window win = SwingUtilities.getWindowAncestor(this);
            popup = null;
            if (win instanceof Dialog) {
                Constructor<?> constructor = this.m_popupClass.getConstructor(Dialog.class, String.class, Boolean.class);
                popup = (CFieldPopup)constructor.newInstance((Dialog)win, this.m_title, new Boolean(true));
            } else if (win instanceof Frame) {
                Constructor<?> constructor = this.m_popupClass.getConstructor(Frame.class, String.class, Boolean.class);
                popup = (CFieldPopup)constructor.newInstance((Frame)win, this.m_title, new Boolean(true));
            }
            if (popup != null) break block7;
            return false;
        }
        try {
            popup.setValue(this.m_editor.getItem());
            popup.setFormat(this.m_editor.getFormat());
            popup.show();
            this.m_editor.setItem(popup.getValue());
            popup = null;
        }
        catch (Exception e) {
            this.notifyUser(e);
        }
        return false;
    }

    public void notifyUser(Exception e) {
        JOptionPane.showMessageDialog(this, e.toString(), "Field Error", 0);
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (super.isEnabled() != rw) {
            super.setEnabled(rw);
        }
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return super.isEnabled();
    }

    @Override
    public void setBackground(boolean error) {
        Color bg = null;
        bg = error ? AdempierePLAF.getFieldBackground_Error() : (!this.isReadWrite() ? AdempierePLAF.getFieldBackground_Inactive() : (this.m_mandatory ? AdempierePLAF.getFieldBackground_Mandatory() : AdempierePLAF.getFieldBackground_Normal()));
        if (bg.equals(this.m_editor.getBackground())) {
            return;
        }
        this.m_editor.setBackground(bg);
    }

    @Override
    public void setValue(Object value) {
        this.m_oldValue = value;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public String getDisplay() {
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object newValue = this.getValue();
        if (newValue != null && newValue.equals(this.m_oldValue) || newValue == null && this.m_oldValue == null) {
            return;
        }
        super.firePropertyChange("DataChanged", this.m_oldValue, newValue);
        this.m_oldValue = newValue;
    }

    @Override
    public void setBackground(Color bg) {
        this.m_editor.setBackground(bg);
    }
}

