/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.util.PaymentUtil;
import org.compiere.apps.ADialog;
import org.compiere.grid.PaymentForm;
import org.compiere.grid.PaymentFormCreditCard;
import org.compiere.grid.VPaymentFormDialog;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class VPaymentFormCreditCard
extends PaymentFormCreditCard
implements ActionListener,
FocusListener {
    private VPaymentFormDialog dialog;
    private CLabel kTypeLabel = new CLabel();
    private CComboBox kTypeCombo = new CComboBox();
    private CLabel kNumberLabel = new CLabel();
    private CTextField kNumberField = new CTextField();
    private CLabel kNameLabel = new CLabel();
    private CTextField kNameField = new CTextField();
    private CLabel kExpLabel = new CLabel();
    private CTextField kExpField = new CTextField();
    private CLabel kAmountLabel = new CLabel();
    private VNumber kAmountField = new VNumber();
    private CLabel kApprovalLabel = new CLabel();
    private CTextField kApprovalField = new CTextField();
    private CButton kOnline = new CButton();
    private CLabel kStatus = new CLabel();

    public VPaymentFormCreditCard(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
        this.dialog = new VPaymentFormDialog((PaymentForm)this, windowNo);
        this.init();
    }

    public void init() {
        GridBagLayout kLayout = new GridBagLayout();
        this.dialog.getPanel().setLayout(kLayout);
        this.kNumberField.setPreferredSize(new Dimension(160, 21));
        this.kNameField.setPreferredSize(new Dimension(160, 21));
        this.kExpField.setPreferredSize(new Dimension(40, 21));
        this.kApprovalField.setPreferredSize(new Dimension(120, 21));
        this.kTypeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"CreditCardType"));
        this.kNumberLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"CreditCardNumber"));
        this.kNameLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"Name"));
        this.kExpLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Expires"));
        this.kApprovalLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"VoiceAuthCode"));
        this.kAmountLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Amount"));
        this.kOnline.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Online"));
        this.kOnline.addActionListener(this);
        this.dialog.getPanel().add((Component)this.kTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.kTypeCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.kTypeCombo.addActionListener(this);
        this.dialog.getPanel().add((Component)this.kNumberLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.kNumberField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(2, 5, 2, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.kNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.kNameField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(2, 5, 2, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.kExpLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.kExpField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.kAmountLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 5, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.kAmountField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 5, 5), 0, 0));
        this.kAmountField.addFocusListener(this);
        this.dialog.getPanel().add((Component)this.kApprovalLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.dialog.getPanel().add((Component)this.kApprovalField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.kStatus, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.dialog.getPanel().add((Component)this.kOnline, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void loadData() {
        super.loadData();
        this.kAmountField.setValue(this.m_Amount);
        if (this.m_C_Payment_ID != 0) {
            this.m_CCType = this.m_mPayment.getCreditCardType();
            this.kNumberField.setText(this.m_mPayment.getCreditCardNumber());
            this.kNameField.setText(this.m_mPayment.getA_Name());
            this.kExpField.setText(this.m_mPayment.getCreditCardExp(null));
            this.kApprovalField.setText(this.m_mPayment.getVoiceAuthCode());
            this.kStatus.setText(this.m_mPayment.getR_PnRef());
            this.kAmountField.setValue(this.m_mPayment.getPayAmt());
            this.kTypeCombo.setReadWrite(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kNumberField.setReadWrite(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kNameField.setReadWrite(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kExpField.setReadWrite(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kApprovalField.setReadWrite(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kOnline.setReadWrite(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kAmountField.setReadWrite(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
        } else if (this.m_mPaymentTransaction != null) {
            this.m_CCType = this.m_mPaymentTransaction.getCreditCardType();
            this.kNumberField.setText(this.m_mPaymentTransaction.getCreditCardNumber());
            this.kNameField.setText(this.m_mPaymentTransaction.getA_Name());
            this.kExpField.setText(PaymentUtil.getCreditCardExp((int)this.m_mPaymentTransaction.getCreditCardExpMM(), (int)this.m_mPaymentTransaction.getCreditCardExpYY(), null));
            this.kApprovalField.setText(this.m_mPaymentTransaction.getVoiceAuthCode());
            this.kStatus.setText(this.m_mPaymentTransaction.getR_PnRef());
            this.kAmountField.setValue(this.m_mPaymentTransaction.getPayAmt());
            this.kTypeCombo.setReadWrite(!this.m_mPaymentTransaction.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kNumberField.setReadWrite(!this.m_mPaymentTransaction.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kNameField.setReadWrite(!this.m_mPaymentTransaction.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kExpField.setReadWrite(!this.m_mPaymentTransaction.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kApprovalField.setReadWrite(!this.m_mPaymentTransaction.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kOnline.setReadWrite(!this.m_mPaymentTransaction.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kAmountField.setReadWrite(!this.m_mPaymentTransaction.isApproved() || !this.m_DocStatus.equals("CO"));
        }
        this.kTypeCombo.removeAllItems();
        ValueNamePair[] ccs = this.getCreditCardList();
        int i = 0;
        while (i < ccs.length) {
            this.kTypeCombo.addItem(ccs[i]);
            ++i;
        }
        if (this.selectedCreditCard != null) {
            this.kTypeCombo.setSelectedItem(this.selectedCreditCard);
        }
        if (this.m_mPayment.isApproved() && this.m_DocStatus.equals("CO")) {
            this.kOnline.setVisible(this.m_mPayment.isOnline());
            this.kOnline.setEnabled(false);
            MBankAccountProcessor bankAccountProcessor = new MBankAccountProcessor(this.m_mPayment.getCtx(), this.m_mPayment.getC_BankAccount_ID(), this.m_mPayment.getC_PaymentProcessor_ID(), null);
            this.setBankAccountProcessor(bankAccountProcessor);
        } else if (this.m_mPaymentTransaction != null) {
            this.kOnline.setVisible(this.m_mPaymentTransaction.isOnline());
            this.kOnline.setEnabled(false);
            MBankAccountProcessor bankAccountProcessor = new MBankAccountProcessor(this.m_mPaymentTransaction.getCtx(), this.m_mPaymentTransaction.getC_BankAccount_ID(), this.m_mPaymentTransaction.getC_PaymentProcessor_ID(), null);
            this.setBankAccountProcessor(bankAccountProcessor);
        } else {
            boolean exist = this.isBankAccountProcessorExist("", (BigDecimal)this.kAmountField.getValue());
            this.kOnline.setVisible(exist);
            if (exist) {
                this.updateOnlineButton();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.kOnline) {
            this.processOnline();
        } else if (e.getSource() == this.kTypeCombo) {
            this.updateOnlineButton();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.kAmountField) {
            this.updateOnlineButton();
        }
    }

    private void updateOnlineButton() {
        String CCType = null;
        ValueNamePair vp = (ValueNamePair)this.kTypeCombo.getSelectedItem();
        if (vp != null) {
            CCType = vp.getValue();
        }
        BigDecimal PayAmt = (BigDecimal)this.kAmountField.getValue();
        if (CCType != null && PayAmt != null) {
            MBankAccountProcessor bankAccountProcessor = this.getBankAccountProcessor(CCType, PayAmt);
            this.kOnline.setEnabled(bankAccountProcessor != null);
            this.setBankAccountProcessor(bankAccountProcessor);
            if (bankAccountProcessor != null) {
                this.kApprovalField.setReadWrite(bankAccountProcessor.isRequireVV());
            } else {
                this.kApprovalField.setReadWrite(true);
            }
        } else {
            this.kOnline.setEnabled(false);
            this.setBankAccountProcessor(null);
        }
    }

    public boolean checkMandatory() {
        return true;
    }

    public boolean saveChangesInTrx(String trxName) {
        boolean ok;
        String newCCType = this.m_CCType;
        ValueNamePair vp = (ValueNamePair)this.kTypeCombo.getSelectedItem();
        if (vp != null) {
            newCCType = vp.getValue();
        }
        if (!(ok = this.save(newCCType, this.kNumberField.getText(), this.kExpField.getText(), (BigDecimal)this.kAmountField.getValue(), trxName))) {
            ADialog.error(this.getWindowNo(), this.dialog, "PaymentError", this.processMsg);
        } else if (this.processMsg != null) {
            ADialog.info(this.getWindowNo(), this.dialog, "PaymentCreated", this.processMsg);
        }
        return ok;
    }

    public void processOnline() {
        ValueNamePair vp = (ValueNamePair)this.kTypeCombo.getSelectedItem();
        String CCType = vp.getValue();
        boolean ok = this.processOnline(CCType, this.kNumberField.getText(), this.kApprovalField.getText(), this.kExpField.getText());
        if (!ok) {
            ADialog.error(this.getWindowNo(), this.dialog, "PaymentError", this.processMsg);
        } else {
            this.loadData();
            if (this.processMsg != null) {
                ADialog.info(this.getWindowNo(), this.dialog, "PaymentProcessed", this.processMsg);
            }
        }
    }

    public void showWindow() {
        this.dialog.setVisible(true);
    }

    public void closeWindow() {
        this.dialog.dispose();
    }

    public Object getWindow() {
        return this.dialog;
    }
}

