/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class RecordAccessDialog
extends CDialog {
    private static final long serialVersionUID = -5208621373205009190L;
    private int m_AD_Table_ID;
    private int m_Record_ID;
    private ArrayList<MRecordAccess> m_recordAccesss = new ArrayList();
    private int m_currentRow = 0;
    private MRecordAccess m_currentData = null;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private CPanel centerPanel = new CPanel(new ALayout());
    private BorderLayout mainLayout = new BorderLayout();
    private CLabel roleLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"AD_Role_ID"));
    private CComboBox roleField = null;
    private CCheckBox cbActive = new CCheckBox(Msg.translate((Properties)Env.getCtx(), (String)"IsActive"));
    private CCheckBox cbExclude = new CCheckBox(Msg.translate((Properties)Env.getCtx(), (String)"IsExclude"));
    private CCheckBox cbReadOnly = new CCheckBox(Msg.translate((Properties)Env.getCtx(), (String)"IsReadOnly"));
    private CCheckBox cbDependent = new CCheckBox(Msg.translate((Properties)Env.getCtx(), (String)"IsDependentEntities"));
    private CButton bDelete = AEnv.getButton("Delete");
    private CButton bNew = AEnv.getButton("New");
    private JLabel rowNoLabel = new JLabel();
    private CButton bUp = AEnv.getButton("Previous");
    private CButton bDown = AEnv.getButton("Next");
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    public RecordAccessDialog(JFrame owner, int AD_Table_ID, int Record_ID) {
        super((Frame)owner, Msg.translate((Properties)Env.getCtx(), (String)"RecordAccessDialog"));
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID);
        }
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_Record_ID = Record_ID;
        try {
            this.dynInit();
            this.jbInit();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
        }
        AEnv.showCenterWindow(owner, this);
    }

    private void dynInit() {
        block7: {
            String sql = MRole.getDefault().addAccessSQL("SELECT AD_Role_ID, Name FROM AD_Role ORDER BY 2", "AD_Role", false, false);
            this.roleField = new CComboBox(DB.getKeyNamePairs((String)sql, (boolean)false));
            sql = "SELECT * FROM AD_Record_Access WHERE AD_Table_ID=? AND Record_ID=? AND AD_Client_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_AD_Table_ID);
                    pstmt.setInt(2, this.m_Record_ID);
                    pstmt.setInt(3, Env.getAD_Client_ID((Properties)Env.getCtx()));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.m_recordAccesss.add(new MRecordAccess(Env.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_recordAccesss.size());
        }
        this.setLine(0, false);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.mainLayout);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.confirmPanel, "South");
        this.centerPanel.add((Component)this.bUp, new ALayoutConstraint(0, 0));
        this.centerPanel.add((Component)this.bNew, new ALayoutConstraint(0, 6));
        this.centerPanel.add((Component)this.roleLabel, new ALayoutConstraint(1, 0));
        this.centerPanel.add((Component)this.roleField, null);
        this.centerPanel.add((Component)this.cbActive, null);
        this.centerPanel.add((Component)this.cbExclude, null);
        this.centerPanel.add((Component)this.cbReadOnly, null);
        this.centerPanel.add((Component)this.cbDependent, null);
        this.centerPanel.add((Component)this.bDelete, null);
        this.centerPanel.add((Component)this.bDown, new ALayoutConstraint(2, 0));
        this.centerPanel.add((Component)this.rowNoLabel, new ALayoutConstraint(2, 6));
        Dimension size = this.centerPanel.getPreferredSize();
        size.width = 600;
        this.centerPanel.setPreferredSize(size);
        this.bUp.addActionListener(this);
        this.bDown.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.bNew.addActionListener(this);
        this.confirmPanel.addActionListener(this);
    }

    private void setLine(int rowDelta, boolean newRecord) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("delta=" + rowDelta + ", new=" + newRecord + " - currentRow=" + this.m_currentRow + ", size=" + this.m_recordAccesss.size());
        }
        int maxIndex = 0;
        if (this.m_recordAccesss.size() == 0) {
            this.m_currentRow = 0;
            maxIndex = 0;
            newRecord = true;
            this.setLine(null);
        } else if (newRecord) {
            maxIndex = this.m_currentRow = this.m_recordAccesss.size();
            this.setLine(null);
        } else {
            this.m_currentRow += rowDelta;
            maxIndex = this.m_recordAccesss.size() - 1;
            if (this.m_currentRow < 0) {
                this.m_currentRow = 0;
            } else if (this.m_currentRow > maxIndex) {
                this.m_currentRow = maxIndex;
            }
            MRecordAccess ra = this.m_recordAccesss.get(this.m_currentRow);
            this.setLine(ra);
        }
        StringBuilder txt = new StringBuilder();
        if (newRecord) {
            txt.append("+");
        }
        txt.append(this.m_currentRow + 1).append("/").append(maxIndex + 1);
        this.rowNoLabel.setText(txt.toString());
        this.bUp.setEnabled(this.m_currentRow > 0);
        this.bDown.setEnabled(this.m_currentRow < maxIndex);
    }

    private void setLine(MRecordAccess ra) {
        int AD_Role_ID = 0;
        boolean active = true;
        boolean exclude = true;
        boolean readonly = false;
        boolean dependent = false;
        if (ra != null) {
            AD_Role_ID = ra.getAD_Role_ID();
            active = ra.isActive();
            exclude = ra.isExclude();
            readonly = ra.isReadOnly();
            dependent = ra.isDependentEntities();
        }
        this.cbActive.setSelected(active);
        this.cbExclude.setSelected(exclude);
        this.cbReadOnly.setSelected(readonly);
        this.cbDependent.setSelected(dependent);
        this.bDelete.setEnabled(ra != null);
        KeyNamePair selection = null;
        int i = 0;
        while (i < this.roleField.getItemCount()) {
            KeyNamePair pp = (KeyNamePair)this.roleField.getItemAt(i);
            if (pp.getKey() == AD_Role_ID) {
                selection = pp;
            }
            ++i;
        }
        if (selection != null && ra != null) {
            this.roleField.setSelectedItem(selection);
            this.m_currentData = ra;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("" + ra);
            }
        } else {
            this.m_currentData = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bUp) {
            this.setLine(-1, false);
        } else if (e.getSource() == this.bDown) {
            this.setLine(1, false);
        } else if (e.getSource() == this.bNew) {
            this.setLine(0, true);
        } else {
            if (e.getSource() == this.bDelete) {
                this.cmd_delete();
            } else if (e.getActionCommand().equals("Ok") && !this.cmd_save()) {
                return;
            }
            this.dispose();
        }
    }

    private boolean cmd_save() {
        KeyNamePair pp = (KeyNamePair)this.roleField.getSelectedItem();
        this.roleField.setBackground(pp == null);
        if (pp == null) {
            return false;
        }
        int AD_Role_ID = pp.getKey();
        boolean isActive = this.cbActive.isSelected();
        boolean isExclude = this.cbExclude.isSelected();
        boolean isReadOnly = this.cbReadOnly.isSelected();
        boolean isDependentEntities = this.cbDependent.isSelected();
        if (this.m_currentData == null) {
            this.m_currentData = new MRecordAccess(Env.getCtx(), AD_Role_ID, this.m_AD_Table_ID, this.m_Record_ID, null);
            this.m_recordAccesss.add(this.m_currentData);
            this.m_currentRow = this.m_recordAccesss.size() - 1;
        }
        this.m_currentData.setIsActive(isActive);
        this.m_currentData.setIsExclude(isExclude);
        this.m_currentData.setIsReadOnly(isReadOnly);
        this.m_currentData.setIsDependentEntities(isDependentEntities);
        boolean success = this.m_currentData.save();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Success=" + success);
        }
        return success;
    }

    private boolean cmd_delete() {
        boolean success = false;
        if (this.m_currentData == null) {
            this.log.log(Level.SEVERE, "No data");
        } else {
            success = this.m_currentData.delete(true);
            this.m_currentData = null;
            this.m_recordAccesss.remove(this.m_currentRow);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Success=" + success);
            }
        }
        return success;
    }
}

