/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JMenuItem;
import org.compiere.apps.wf.WFPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;

public class WFPopupItem
extends JMenuItem {
    private static final long serialVersionUID = 4634863991042969718L;
    private int m_AD_Workflow_ID;
    private static final CLogger log = CLogger.getCLogger(WFPopupItem.class);
    private MWFNode m_node;
    private MWFNodeNext m_line;
    private int m_AD_WF_NodeTo_ID;

    public WFPopupItem(String title, MWFNode node, int AD_WF_NodeTo_ID) {
        super(title);
        this.m_node = node;
        this.m_AD_WF_NodeTo_ID = AD_WF_NodeTo_ID;
        this.m_AD_Workflow_ID = node.getAD_Workflow_ID();
    }

    public WFPopupItem(String title, MWFNodeNext line) {
        super(title);
        this.m_line = line;
    }

    public void execute(WFPanel wfp) {
        if (this.m_node != null && this.m_AD_WF_NodeTo_ID > 0) {
            int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            MWFNodeNext newLine = new MWFNodeNext(this.m_node, this.m_AD_WF_NodeTo_ID);
            newLine.setClientOrg(AD_Client_ID, 0);
            newLine.saveEx();
            if (log.isLoggable(Level.INFO)) {
                log.info("Add Line to " + this.m_node + " -> " + newLine);
            }
            wfp.load(this.m_AD_Workflow_ID, true);
        } else if (this.m_node != null && this.m_AD_WF_NodeTo_ID == -1) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Delete Node: " + this.m_node);
            }
            this.m_node.delete(false);
            wfp.load(this.m_AD_Workflow_ID, true);
        } else if (this.m_line != null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Delete Line: " + this.m_line);
            }
            this.m_line.delete(false);
            wfp.load(this.m_AD_Workflow_ID, true);
        } else {
            log.warning("No Action??");
        }
    }
}

