/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessParameterPanel;
import org.compiere.print.ReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.swing.CButton;
import org.compiere.swing.CFrame;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ProcessDialog
extends CFrame
implements ActionListener,
IProcessUI {
    private static final long serialVersionUID = 7486479305726277406L;
    private int m_AD_Process_ID;
    private int m_WindowNo;
    private String m_Name = null;
    private boolean m_IsReport = false;
    private int[] m_ids = null;
    private boolean m_isLocked = false;
    private StringBuffer m_messageText = new StringBuffer();
    private String m_ShowHelp = null;
    private static CLogger log = CLogger.getCLogger(ProcessDialog.class);
    private CPanel dialog = new CPanel(){
        private static final long serialVersionUID = 428410337428677817L;

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension m = this.getMinimumSize();
            if (d.height < m.height || d.width < m.width) {
                Dimension d1 = new Dimension();
                d1.height = Math.max(d.height, m.height);
                d1.width = Math.max(d.width, m.width);
                return d1;
            }
            return d;
        }
    };
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel southPanel = new CPanel();
    private CButton bOK = ConfirmPanel.createOKButton(true);
    private FlowLayout southLayout = new FlowLayout();
    private JEditorPane message = new JEditorPane(){
        private static final long serialVersionUID = -2271852928089812014L;

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension m = this.getMaximumSize();
            if (d.height > m.height || d.width > m.width) {
                Dimension d1 = new Dimension();
                d1.height = Math.min(d.height, m.height);
                d1.width = Math.min(d.width, m.width);
                return d1;
            }
            return d;
        }
    };
    private JScrollPane messagePane = new JScrollPane(this.message){
        private static final long serialVersionUID = 3605316311642118445L;

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension m = this.getMaximumSize();
            if (d.height > m.height || d.width > m.width) {
                Dimension d1 = new Dimension();
                d1.height = Math.min(d.height, m.height);
                d1.width = Math.min(d.width, m.width);
                return d1;
            }
            return d;
        }
    };
    private CButton bPrint = ConfirmPanel.createPrintButton(true);
    private CPanel centerPanel = null;
    private ProcessParameterPanel parameterPanel = null;
    private JSeparator separator = new JSeparator();
    private ProcessInfo m_pi = null;

    public ProcessDialog(int AD_Process_ID, boolean isSOTrx) {
        this(null, AD_Process_ID, isSOTrx);
    }

    public ProcessDialog(GraphicsConfiguration gc, int AD_Process_ID, boolean isSOTrx) {
        super(gc);
        if (log.isLoggable(Level.INFO)) {
            log.info("Process=" + AD_Process_ID + "; SOTrx=" + isSOTrx);
        }
        this.enableEvents(64L);
        this.m_AD_Process_ID = AD_Process_ID;
        this.m_WindowNo = AEnv.createWindowNo(this);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)(isSOTrx ? "Y" : "N"));
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.setIconImage(Env.getImage((String)"mProcess.png"));
        this.dialog.setLayout(this.mainLayout);
        this.dialog.setMinimumSize(new Dimension(500, 200));
        this.bOK.addActionListener(this);
        this.bPrint.addActionListener(this);
        this.southPanel.setLayout(this.southLayout);
        this.southLayout.setAlignment(2);
        this.message.setContentType("text/html");
        this.message.setEditable(false);
        this.message.setBackground(Color.white);
        this.message.setFocusable(true);
        this.getContentPane().add(this.dialog);
        this.dialog.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.bPrint, null);
        this.southPanel.add((Component)this.bOK, null);
        this.dialog.add((Component)this.messagePane, "North");
        this.messagePane.setBorder(null);
        this.messagePane.setMaximumSize(new Dimension(600, 300));
        this.centerPanel = new CPanel();
        this.centerPanel.setBorder(null);
        this.centerPanel.setLayout(new BorderLayout());
        this.dialog.add((Component)this.centerPanel, "Center");
        this.mainLayout.setVgap(2);
        this.getRootPane().setDefaultButton(this.bOK);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.bOK.requestFocus();
        }
    }

    @Override
    public void dispose() {
        Env.clearWinContext((int)this.m_WindowNo);
        super.dispose();
    }

    public boolean init() {
        log.config("");
        boolean trl = !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Process");
        String sql = "SELECT Name, Description, Help, IsReport, ShowHelp FROM AD_Process WHERE AD_Process_ID=?";
        if (trl) {
            sql = "SELECT t.Name, t.Description, t.Help, p.IsReport, p.ShowHelp FROM AD_Process p, AD_Process_Trl t WHERE p.AD_Process_ID=t.AD_Process_ID AND p.AD_Process_ID=? AND t.AD_Language=?";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, this.m_AD_Process_ID);
                if (trl) {
                    pstmt.setString(2, Env.getAD_Language((Properties)Env.getCtx()));
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    this.m_Name = rs.getString(1);
                    this.m_IsReport = rs.getString(4).equals("Y");
                    this.m_ShowHelp = rs.getString(5);
                    this.m_messageText.append("<b>");
                    String s = rs.getString(2);
                    if (rs.wasNull()) {
                        this.m_messageText.append(Msg.getMsg((Properties)Env.getCtx(), (String)"StartProcess?"));
                    } else {
                        this.m_messageText.append(s);
                    }
                    this.m_messageText.append("</b>");
                    s = rs.getString(3);
                    if (!rs.wasNull()) {
                        this.m_messageText.append("<p>").append(s).append("</p>");
                    }
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (this.m_Name == null) {
            throw new AdempiereException("@NotFound@ @AD_Process_ID@=" + this.m_AD_Process_ID + ". @CheckMissingTrl@");
        }
        this.setTitle(this.m_Name);
        this.message.setText(this.m_messageText.toString());
        this.bOK.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Start"));
        this.m_pi = new ProcessInfo(this.m_Name, this.m_AD_Process_ID);
        this.m_pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        this.m_pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.parameterPanel = new ProcessParameterPanel(this.m_WindowNo, this.m_pi);
        this.parameterPanel.setWindow(this);
        this.centerPanel.removeAll();
        if (this.parameterPanel.init()) {
            this.centerPanel.add((Component)this.separator, "North");
            this.centerPanel.add((Component)this.parameterPanel, "Center");
        } else if (this.m_ShowHelp != null && this.m_ShowHelp.equals("N")) {
            this.bOK.doClick();
        }
        if (this.m_ShowHelp != null && this.m_ShowHelp.equals("S")) {
            this.bOK.doClick();
        }
        this.dialog.revalidate();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            if (this.bOK.getText().length() == 0) {
                this.dispose();
            } else {
                ProcessCtl.process(this, this.m_WindowNo, this.parameterPanel, this.m_pi, null);
            }
        } else if (e.getSource() == this.bPrint) {
            this.printScreen();
        }
    }

    public void lockUI(ProcessInfo pi) {
        this.bOK.setText("");
        this.bOK.setEnabled(false);
        this.setEnabled(false);
        this.m_isLocked = true;
    }

    public void unlockUI(ProcessInfo pi) {
        ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
        this.m_messageText.append("<p><font color=\"").append(pi.isError() ? "#FF0000" : "#0000FF").append("\">** ").append(pi.getSummary()).append("</font></p>");
        this.m_messageText.append(pi.getLogInfo(true));
        this.message.setText(this.m_messageText.toString());
        this.message.setCaretPosition(this.message.getDocument().getLength());
        this.m_ids = pi.getIDs();
        this.bOK.setEnabled(true);
        this.setEnabled(true);
        this.m_isLocked = false;
        this.dialog.remove(this.centerPanel);
        this.messagePane.setMaximumSize(null);
        this.dialog.remove(this.messagePane);
        this.dialog.add((Component)this.messagePane, "Center");
        this.validate();
        AEnv.showCenterScreen(this);
        this.afterProcessTask();
        if (this.m_IsReport && !pi.isError()) {
            this.bOK.doClick();
        }
        if (this.m_ShowHelp != null && this.m_ShowHelp.equals("S")) {
            this.bOK.doClick();
        }
    }

    public boolean isUILocked() {
        return this.m_isLocked;
    }

    public void executeASync(ProcessInfo pi) {
        log.config("-");
    }

    private void afterProcessTask() {
        if (this.m_ids != null && this.m_ids.length > 0) {
            log.config("");
            if (this.m_AD_Process_ID == 119) {
                this.printInvoices();
            } else if (this.m_AD_Process_ID == 118) {
                this.printShipments();
            }
        }
    }

    private void printShipments() {
        ADialogDialog d;
        if (this.m_ids == null) {
            return;
        }
        if (!ADialog.ask(this.m_WindowNo, this, "PrintShipments")) {
            return;
        }
        this.m_messageText.append("<p>").append(Msg.getMsg((Properties)Env.getCtx(), (String)"PrintShipments")).append("</p>");
        this.message.setText(this.m_messageText.toString());
        int retValue = ADialogDialog.A_CANCEL;
        do {
            int i = 0;
            while (i < this.m_ids.length) {
                int M_InOut_ID = this.m_ids[i];
                ReportCtl.startDocumentPrint((int)1, (int)M_InOut_ID, (IProcessUI)this, (int)AEnv.getWindowNo(this), (boolean)true);
                ++i;
            }
        } while ((retValue = (d = new ADialogDialog((Frame)this, Env.getHeader((Properties)Env.getCtx(), (int)this.m_WindowNo), Msg.getMsg((Properties)Env.getCtx(), (String)"PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
    }

    private void printInvoices() {
        ADialogDialog d;
        if (this.m_ids == null) {
            return;
        }
        if (!ADialog.ask(this.m_WindowNo, this, "PrintInvoices")) {
            return;
        }
        this.m_messageText.append("<p>").append(Msg.getMsg((Properties)Env.getCtx(), (String)"PrintInvoices")).append("</p>");
        this.message.setText(this.m_messageText.toString());
        int retValue = ADialogDialog.A_CANCEL;
        do {
            int i = 0;
            while (i < this.m_ids.length) {
                int AD_Invoice_ID = this.m_ids[i];
                ReportCtl.startDocumentPrint((int)2, (int)AD_Invoice_ID, (IProcessUI)this, (int)AEnv.getWindowNo(this), (boolean)true);
                ++i;
            }
        } while ((retValue = (d = new ADialogDialog((Frame)this, Env.getHeader((Properties)Env.getCtx(), (int)this.m_WindowNo), Msg.getMsg((Properties)Env.getCtx(), (String)"PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
    }

    private void printScreen() {
        PrintScreenPainter.printScreen(this);
    }

    public void statusUpdate(String status) {
        this.message.setText(status);
    }

    public void ask(String message, Callback<Boolean> callback) {
        boolean b = ADialog.ask(this.m_WindowNo, this, message);
        if (callback != null) {
            callback.onCallback((Object)b);
        }
    }

    public void download(File file) {
    }
}

