/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.ui.swing.factory;

import java.awt.Frame;
import java.util.Properties;
import org.adempiere.ui.swing.factory.IInfoFactory;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.InfoAsset;
import org.compiere.apps.search.InfoAssignment;
import org.compiere.apps.search.InfoBPartner;
import org.compiere.apps.search.InfoCashLine;
import org.compiere.apps.search.InfoGeneral;
import org.compiere.apps.search.InfoInOut;
import org.compiere.apps.search.InfoInvoice;
import org.compiere.apps.search.InfoOrder;
import org.compiere.apps.search.InfoPayment;
import org.compiere.apps.search.InfoProduct;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class DefaultInfoFactory
implements IInfoFactory {
    private static final CLogger log = CLogger.getCLogger(DefaultInfoFactory.class);

    @Override
    public Info create(Frame frame, boolean modal, Lookup lookup, GridField field, String tableName, String keyColumn, String queryValue, boolean multiSelection, String whereClause) {
        Info info = null;
        String col = lookup.getColumnName();
        if (col.indexOf(46) != -1) {
            col = col.substring(col.indexOf(46) + 1);
        }
        boolean multipleSelection = false;
        if (col.equals("M_Product_ID")) {
            int M_Warehouse_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)lookup.getWindowNo(), (String)"M_Warehouse_ID");
            int M_PriceList_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)lookup.getWindowNo(), (String)"M_PriceList_ID");
            if (field != null) {
                int AD_Table_ID = MColumn.getTable_ID((Properties)Env.getCtx(), (int)field.getAD_Column_ID(), null);
                multipleSelection = 260 == AD_Table_ID || 333 == AD_Table_ID || 53019 == AD_Table_ID || 251 == AD_Table_ID;
            }
            info = new InfoProduct(frame, true, lookup.getWindowNo(), M_Warehouse_ID, M_PriceList_ID, queryValue, multipleSelection, whereClause);
        } else if (col.equals("C_BPartner_ID")) {
            boolean isSOTrx = true;
            if (Env.getContext((Properties)Env.getCtx(), (int)lookup.getWindowNo(), (String)"IsSOTrx").equals("N")) {
                isSOTrx = false;
            }
            info = new InfoBPartner(frame, true, lookup.getWindowNo(), queryValue, isSOTrx, multipleSelection, whereClause);
        } else {
            info = this.create(frame, true, lookup.getWindowNo(), tableName, keyColumn, queryValue, multipleSelection, whereClause, true);
        }
        return info;
    }

    @Override
    public Info create(Frame frame, boolean modal, int WindowNo, String tableName, String keyColumn, String value, boolean multiSelection, String whereClause, boolean lookup) {
        Info info = null;
        if (tableName.equals("C_BPartner")) {
            info = new InfoBPartner(frame, modal, WindowNo, value, !Env.getContext((Properties)Env.getCtx(), (String)"IsSOTrx").equals("N"), multiSelection, whereClause, lookup);
        } else if (tableName.equals("M_Product")) {
            info = new InfoProduct(frame, modal, WindowNo, Env.getContextAsInt((Properties)Env.getCtx(), (int)WindowNo, (String)"M_Warehouse_ID"), Env.getContextAsInt((Properties)Env.getCtx(), (int)WindowNo, (String)"M_PriceList_ID"), value, multiSelection, whereClause, lookup);
        } else if (tableName.equals("C_Invoice")) {
            info = new InfoInvoice(frame, modal, WindowNo, value, multiSelection, whereClause, lookup);
        } else if (tableName.equals("A_Asset")) {
            info = new InfoAsset(frame, modal, WindowNo, 0, value, multiSelection, whereClause, lookup);
        } else if (tableName.equals("C_Order")) {
            info = new InfoOrder(frame, modal, WindowNo, value, multiSelection, whereClause, lookup);
        } else if (tableName.equals("M_InOut")) {
            info = new InfoInOut(frame, modal, WindowNo, value, multiSelection, whereClause, lookup);
        } else if (tableName.equals("C_Payment")) {
            info = new InfoPayment(frame, modal, WindowNo, value, multiSelection, whereClause, lookup);
        } else if (tableName.equals("C_CashLine")) {
            info = new InfoCashLine(frame, modal, WindowNo, value, multiSelection, whereClause);
        } else if (tableName.equals("S_ResourceAssigment")) {
            info = new InfoAssignment(frame, modal, WindowNo, value, multiSelection, whereClause, lookup);
        } else {
            info = new InfoGeneral(frame, modal, WindowNo, value, tableName, keyColumn, multiSelection, whereClause, lookup);
            if (!info.loadedOK()) {
                info.dispose(false);
                info = null;
            }
        }
        return info;
    }
}

