/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.srv;

import java.io.File;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.IDictionaryService;
import org.adempiere.pipo2.PackIn;
import org.adempiere.pipo2.Zipper;
import org.compiere.model.X_AD_Package_Imp_Proc;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.osgi.framework.BundleContext;

public class PipoDictionaryService
implements IDictionaryService {
    CLogger logger = CLogger.getCLogger((String)PipoDictionaryService.class.getName());

    public void merge(BundleContext context, File packageFile) throws Exception {
        if (packageFile == null || !packageFile.exists()) {
            this.logger.info("No PackIn Model found");
            return;
        }
        String trxName = Trx.createTrxName();
        try {
            try {
                PackIn packIn = new PackIn();
                packIn.setPackageName(context.getBundle().getSymbolicName());
                packIn.setPackageVersion((String)context.getBundle().getHeaders().get("Bundle-Version"));
                packIn.setUpdateDictionary(false);
                X_AD_Package_Imp_Proc adPackageImp = new X_AD_Package_Imp_Proc(Env.getCtx(), 0, trxName);
                File zipFilepath = packageFile;
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("zipFilepath->" + zipFilepath);
                }
                String parentDir = Zipper.getParentDir(zipFilepath);
                File targetDir = new File(System.getProperty("java.io.tmpdir"));
                Zipper.unpackFile(zipFilepath, targetDir);
                String dict_file = targetDir + File.separator + parentDir + File.separator + "dict" + File.separator + "PackOut.xml";
                packIn.setPackageDirectory(targetDir + File.separator + parentDir);
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("dict file->" + dict_file);
                }
                String msg = packIn.importXML(dict_file, Env.getCtx(), trxName);
                adPackageImp.setName(packIn.getPackageName());
                adPackageImp.setDateProcessed(new Timestamp(System.currentTimeMillis()));
                adPackageImp.setP_Msg(msg);
                adPackageImp.setAD_Package_Source_Type("File");
                adPackageImp.saveEx();
                Trx.get((String)trxName, (boolean)false).commit();
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("commit " + trxName);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "importXML:", (Throwable)e);
                throw e;
            }
        }
        finally {
            Trx.get((String)trxName, (boolean)false).close();
        }
    }
}

