/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Base;
import org.compiere.model.MTree_Node;
import org.compiere.model.MTree_NodeBP;
import org.compiere.model.MTree_NodeMM;
import org.compiere.model.MTree_NodePR;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class TreeMaintenance
extends SvrProcess {
    private int m_AD_Tree_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Tree_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Tree_ID=" + this.m_AD_Tree_ID);
        }
        if (this.m_AD_Tree_ID == 0) {
            throw new IllegalArgumentException("Tree_ID = 0");
        }
        MTree tree = new MTree(this.getCtx(), this.m_AD_Tree_ID, this.get_TrxName());
        if (tree == null || tree.getAD_Tree_ID() == 0) {
            throw new IllegalArgumentException("No Tree -" + tree);
        }
        if ("BB".equals(tree.getTreeType())) {
            return "BOM Trees not implemented";
        }
        return this.verifyTree((MTree_Base)tree);
    }

    private String verifyTree(MTree_Base tree) {
        boolean ok;
        int inserts;
        block21: {
            StringBuilder sql;
            String nodeTableName = tree.getNodeTableName();
            String sourceTableName = tree.getSourceTableName(true);
            String sourceTableKey = String.valueOf(sourceTableName) + "_ID";
            int AD_Client_ID = tree.getAD_Client_ID();
            int C_Element_ID = 0;
            if ("EV".equals(tree.getTreeType()) && (C_Element_ID = DB.getSQLValue(null, (String)(sql = new StringBuilder("SELECT C_Element_ID FROM C_Element ").append("WHERE AD_Tree_ID=").append(tree.getAD_Tree_ID())).toString())) <= 0) {
                throw new IllegalStateException("No Account Element found");
            }
            sql = new StringBuilder();
            sql.append("DELETE ").append(nodeTableName).append(" WHERE AD_Tree_ID=").append(tree.getAD_Tree_ID()).append(" AND Node_ID NOT IN (SELECT ").append(sourceTableKey).append(" FROM ").append(sourceTableName).append(" WHERE AD_Client_ID=").append(AD_Client_ID);
            if (C_Element_ID > 0) {
                sql.append(" AND C_Element_ID=").append(C_Element_ID);
            }
            sql.append(")");
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(sql.toString());
            }
            int deletes = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(deletes), String.valueOf(tree.getName()) + " Deleted");
            if (!tree.isAllNodes()) {
                StringBuilder msgreturn = new StringBuilder().append(tree.getName()).append(" OK");
                return msgreturn.toString();
            }
            inserts = 0;
            sql = new StringBuilder();
            sql.append("SELECT ").append(sourceTableKey).append(" FROM ").append(sourceTableName).append(" WHERE AD_Client_ID=").append(AD_Client_ID);
            if (C_Element_ID > 0) {
                sql.append(" AND C_Element_ID=").append(C_Element_ID);
            }
            sql.append(" AND ").append(sourceTableKey).append("  NOT IN (SELECT Node_ID FROM ").append(nodeTableName).append(" WHERE AD_Tree_ID=").append(tree.getAD_Tree_ID()).append(")");
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(sql.toString());
            }
            ok = true;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int Node_ID = rs.getInt(1);
                        MTree_Node node = null;
                        if (nodeTableName.equals("AD_TreeNode")) {
                            node = new MTree_Node(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodeBP")) {
                            node = new MTree_NodeBP(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodePR")) {
                            node = new MTree_NodePR(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodeMM")) {
                            node = new MTree_NodeMM(tree, Node_ID);
                        }
                        if (node == null) {
                            this.log.log(Level.SEVERE, "No Model for " + nodeTableName);
                            continue;
                        }
                        if (node.save()) {
                            ++inserts;
                            continue;
                        }
                        this.log.log(Level.SEVERE, "Could not add to " + tree + " Node_ID=" + Node_ID);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "verifyTree", (Throwable)e);
                    ok = false;
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block21;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msglog = new StringBuilder().append(tree.getName()).append(" Inserted");
        this.addLog(0, null, new BigDecimal(inserts), msglog.toString());
        StringBuilder msgreturn = new StringBuilder().append(tree.getName()).append(ok ? " OK" : " Error");
        return msgreturn.toString();
    }
}

