/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MRefList;
import org.compiere.model.MStorageOnHand;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class StorageCleanup
extends SvrProcess {
    private int p_C_DocType_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int lines;
        block8: {
            this.log.info("");
            String sql = "DELETE FROM M_StorageOnHand WHERE QtyOnHand = 0 AND Created < SysDate-3";
            int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Delete Empty #" + no);
            }
            sql = "DELETE FROM M_StorageReservation WHERE Qty = 0 AND Created < SysDate-3";
            no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Delete Empty #" + no);
            }
            sql = "SELECT * FROM M_StorageOnHand s WHERE AD_Client_ID = ? AND QtyOnHand < 0 AND EXISTS (SELECT * FROM M_Product p INNER JOIN M_AttributeSet mas ON (p.M_AttributeSet_ID=mas.M_AttributeSet_ID) WHERE s.M_Product_ID=p.M_Product_ID AND mas.IsInstanceAttribute='Y') AND EXISTS (SELECT * FROM M_StorageOnHand sw INNER JOIN M_Locator swl ON (sw.M_Locator_ID=swl.M_Locator_ID), M_Locator sl WHERE sw.QtyOnHand > 0 AND s.M_Product_ID=sw.M_Product_ID AND s.M_Locator_ID=sl.M_Locator_ID AND sl.M_Warehouse_ID=swl.M_Warehouse_ID)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            lines = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        lines += this.move(new MStorageOnHand(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("#").append(lines);
        return msgreturn.toString();
    }

    private int move(MStorageOnHand target) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(target.toString());
        }
        BigDecimal qty = target.getQtyOnHand().negate();
        MMovement mh = new MMovement(this.getCtx(), 0, this.get_TrxName());
        mh.setAD_Org_ID(target.getAD_Org_ID());
        mh.setC_DocType_ID(this.p_C_DocType_ID);
        mh.setDescription(this.getName());
        if (!mh.save()) {
            return 0;
        }
        int lines = 0;
        MStorageOnHand[] sources = this.getSources(target.getM_Product_ID(), target.getM_Locator_ID());
        int i = 0;
        while (i < sources.length) {
            MStorageOnHand source = sources[i];
            MMovementLine ml = new MMovementLine(mh);
            ml.setM_Product_ID(target.getM_Product_ID());
            ml.setM_LocatorTo_ID(target.getM_Locator_ID());
            ml.setM_AttributeSetInstanceTo_ID(target.getM_AttributeSetInstance_ID());
            ml.setM_Locator_ID(source.getM_Locator_ID());
            ml.setM_AttributeSetInstance_ID(source.getM_AttributeSetInstance_ID());
            BigDecimal qtyMove = qty;
            if (qtyMove.compareTo(source.getQtyOnHand()) > 0) {
                qtyMove = source.getQtyOnHand();
            }
            ml.setMovementQty(qtyMove);
            ml.setLine(++lines * 10);
            if (!ml.save()) {
                return 0;
            }
            if ((qty = qty.subtract(qtyMove)).signum() <= 0) break;
            ++i;
        }
        if (!mh.processIt("CO")) {
            this.log.warning("Movement Process Failed: " + mh + " - " + mh.getProcessMsg());
            throw new IllegalStateException("Movement Process Failed: " + mh + " - " + mh.getProcessMsg());
        }
        mh.saveEx();
        StringBuilder msglog = new StringBuilder("@M_Movement_ID@ ").append(mh.getDocumentNo()).append(" (").append(MRefList.get((Properties)this.getCtx(), (int)131, (String)mh.getDocStatus(), (String)this.get_TrxName())).append(")");
        this.addLog(0, null, new BigDecimal(lines), msglog.toString());
        this.eliminateReservation(target);
        return lines;
    }

    private void eliminateReservation(MStorageOnHand target) {
    }

    private MStorageOnHand[] getSources(int M_Product_ID, int M_Locator_ID) {
        ArrayList<MStorageOnHand> list;
        block6: {
            list = new ArrayList<MStorageOnHand>();
            String sql = "SELECT * FROM M_StorageOnHand s WHERE QtyOnHand > 0 AND M_Product_ID=? AND (M_AttributeSetInstance_ID=0 OR EXISTS (SELECT * FROM M_AttributeSetInstance asi WHERE s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID AND asi.Description IS NULL) ) AND EXISTS (SELECT * FROM M_Locator sl, M_Locator x WHERE s.M_Locator_ID=sl.M_Locator_ID AND x.M_Locator_ID=? AND sl.M_Warehouse_ID=x.M_Warehouse_ID) ORDER BY M_AttributeSetInstance_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, M_Product_ID);
                    pstmt.setInt(2, M_Locator_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MStorageOnHand(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MStorageOnHand[] retValue = new MStorageOnHand[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

