/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInterestArea;
import org.compiere.model.MMailText;
import org.compiere.model.MStore;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Msg;

public class SendMailText
extends SvrProcess {
    private int m_R_MailText_ID = -1;
    private MMailText m_MailText = null;
    private int m_AD_User_ID = -1;
    private MClient m_client = null;
    private MUser m_from = null;
    private ArrayList<Integer> m_list = new ArrayList();
    private int m_counter = 0;
    private int m_errors = 0;
    private int m_R_InterestArea_ID = -1;
    private MInterestArea m_ia = null;
    private int m_C_BP_Group_ID = -1;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("R_InterestArea_ID")) {
                    this.m_R_InterestArea_ID = para[i].getParameterAsInt();
                } else if (name.equals("R_MailText_ID")) {
                    this.m_R_MailText_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BP_Group_ID")) {
                    this.m_C_BP_Group_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_User_ID")) {
                    this.m_AD_User_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("R_MailText_ID=" + this.m_R_MailText_ID);
        }
        this.m_MailText = new MMailText(this.getCtx(), this.m_R_MailText_ID, this.get_TrxName());
        if (this.m_MailText.getR_MailText_ID() == 0) {
            throw new Exception("Not found @R_MailText_ID@=" + this.m_R_MailText_ID);
        }
        this.m_client = MClient.get((Properties)this.getCtx());
        if (this.m_client.getAD_Client_ID() == 0) {
            throw new Exception("Not found @AD_Client_ID@");
        }
        if (this.m_client.getSMTPHost() == null || this.m_client.getSMTPHost().length() == 0) {
            throw new Exception("No SMTP Host found");
        }
        if (this.m_AD_User_ID > 0) {
            this.m_from = new MUser(this.getCtx(), this.m_AD_User_ID, this.get_TrxName());
            if (this.m_from.getAD_User_ID() == 0) {
                throw new Exception("No found @AD_User_ID@=" + this.m_AD_User_ID);
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("From " + this.m_from);
        }
        long start = System.currentTimeMillis();
        if (this.m_R_InterestArea_ID > 0) {
            this.sendInterestArea();
        }
        if (this.m_C_BP_Group_ID > 0) {
            this.sendBPGroup();
        }
        StringBuilder msgreturn = new StringBuilder("@Created@=").append(this.m_counter).append(", @Errors@=").append(this.m_errors).append(" - ").append(System.currentTimeMillis() - start).append("ms");
        return msgreturn.toString();
    }

    private void sendInterestArea() {
        block12: {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("R_InterestArea_ID=" + this.m_R_InterestArea_ID);
            }
            this.m_ia = MInterestArea.get((Properties)this.getCtx(), (int)this.m_R_InterestArea_ID);
            StringBuilder unsubscribe = null;
            if (this.m_ia.isSelfService()) {
                unsubscribe = new StringBuilder("\n\n---------.----------.----------.----------.----------.----------\n").append(Msg.getElement((Properties)this.getCtx(), (String)"R_InterestArea_ID")).append(": ").append(this.m_ia.getName()).append("\n").append(Msg.getMsg((Properties)this.getCtx(), (String)"UnsubscribeInfo")).append("\n");
                MStore[] wstores = MStore.getOfClient((MClient)this.m_client);
                int index = 0;
                int i = 0;
                while (i < wstores.length) {
                    if (wstores[i].isDefault()) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (wstores.length > 0) {
                    unsubscribe.append(wstores[index].getWebContext(true));
                }
            }
            String sql = "SELECT u.Name, u.EMail, u.AD_User_ID FROM R_ContactInterest ci INNER JOIN AD_User u ON (ci.AD_User_ID=u.AD_User_ID) WHERE ci.IsActive='Y' AND u.IsActive='Y' AND ci.OptOutDate IS NULL AND u.EMail IS NOT NULL AND ci.R_InterestArea_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.m_R_InterestArea_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Boolean ok = this.sendIndividualMail(rs.getString(1), rs.getInt(3), unsubscribe);
                        if (ok == null) continue;
                        if (ok.booleanValue()) {
                            ++this.m_counter;
                            continue;
                        }
                        ++this.m_errors;
                    }
                }
                catch (SQLException ex) {
                    this.log.log(Level.SEVERE, sql, (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_ia = null;
    }

    private void sendBPGroup() {
        block8: {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("C_BP_Group_ID=" + this.m_C_BP_Group_ID);
            }
            String sql = "SELECT u.Name, u.EMail, u.AD_User_ID FROM AD_User u INNER JOIN C_BPartner bp ON (u.C_BPartner_ID=bp.C_BPartner_ID) WHERE u.IsActive='Y' AND bp.IsActive='Y' AND u.EMail IS NOT NULL AND bp.C_BP_Group_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.m_C_BP_Group_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Boolean ok = this.sendIndividualMail(rs.getString(1), rs.getInt(3), null);
                        if (ok == null) continue;
                        if (ok.booleanValue()) {
                            ++this.m_counter;
                            continue;
                        }
                        ++this.m_errors;
                    }
                }
                catch (SQLException ex) {
                    this.log.log(Level.SEVERE, sql, (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private Boolean sendIndividualMail(String Name, int AD_User_ID, StringBuilder unsubscribe) {
        Integer ii = new Integer(AD_User_ID);
        if (this.m_list.contains(ii)) {
            return null;
        }
        this.m_list.add(ii);
        MUser to = new MUser(this.getCtx(), AD_User_ID, null);
        this.m_MailText.setUser(AD_User_ID);
        StringBuilder message = new StringBuilder(this.m_MailText.getMailText(true));
        if (unsubscribe != null) {
            message.append((CharSequence)unsubscribe);
        }
        EMail email = this.m_client.createEMail(this.m_from, to, this.m_MailText.getMailHeader(), message.toString());
        if (this.m_MailText.isHtml()) {
            email.setMessageHTML(this.m_MailText.getMailHeader(), message.toString());
        } else {
            email.setSubject(this.m_MailText.getMailHeader());
            email.setMessageText(message.toString());
        }
        if (!email.isValid() && !email.isValid(true)) {
            this.log.warning("NOT VALID - " + email);
            to.setIsActive(false);
            to.addDescription("Invalid EMail");
            to.saveEx();
            return Boolean.FALSE;
        }
        boolean OK = "OK".equals(email.send());
        new MUserMail(this.m_MailText, AD_User_ID, email).saveEx();
        if (OK) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(to.getEMail());
            }
        } else {
            this.log.warning("FAILURE - " + to.getEMail());
        }
        StringBuilder msglog = new StringBuilder(OK ? "@OK@" : "@ERROR@").append(" - ").append(to.getEMail());
        this.addLog(0, null, null, msglog.toString());
        return new Boolean(OK);
    }
}

