/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderPaySchedule;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class InvoiceGenerate
extends SvrProcess {
    private boolean p_Selection = false;
    private Timestamp p_DateInvoiced = null;
    private int p_AD_Org_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_C_Order_ID = 0;
    private boolean p_ConsolidateDocument = true;
    private String p_docAction = "CO";
    private MInvoice m_invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("Selection")) {
                    this.p_Selection = "Y".equals(para[i].getParameter());
                } else if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced = (Timestamp)para[i].getParameter();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = para[i].getParameterAsInt();
                } else if (name.equals("ConsolidateDocument")) {
                    this.p_ConsolidateDocument = "Y".equals(para[i].getParameter());
                } else if (name.equals("DocAction")) {
                    this.p_docAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date");
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(System.currentTimeMillis());
        }
        if (!"CO".equals(this.p_docAction)) {
            this.p_docAction = "PR";
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Selection=" + this.p_Selection + ", DateInvoiced=" + this.p_DateInvoiced + ", AD_Org_ID=" + this.p_AD_Org_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_Order_ID=" + this.p_C_Order_ID + ", DocAction=" + this.p_docAction + ", Consolidate=" + this.p_ConsolidateDocument);
        }
        StringBuilder sql = null;
        if (this.p_Selection) {
            sql = new StringBuilder("SELECT C_Order.* FROM C_Order, T_Selection ").append("WHERE C_Order.DocStatus='CO' AND C_Order.IsSOTrx='Y' ").append("AND C_Order.C_Order_ID = T_Selection.T_Selection_ID ").append("AND T_Selection.AD_PInstance_ID=? ").append("ORDER BY C_Order.M_Warehouse_ID, C_Order.PriorityRule, C_Order.C_BPartner_ID, C_Order.Bill_Location_ID, C_Order.C_Order_ID");
        } else {
            sql = new StringBuilder("SELECT * FROM C_Order o ").append("WHERE DocStatus IN('CO','CL') AND IsSOTrx='Y'");
            if (this.p_AD_Org_ID != 0) {
                sql.append(" AND AD_Org_ID=?");
            }
            if (this.p_C_BPartner_ID != 0) {
                sql.append(" AND C_BPartner_ID=?");
            }
            if (this.p_C_Order_ID != 0) {
                sql.append(" AND C_Order_ID=?");
            }
            sql.append(" AND EXISTS (SELECT * FROM C_OrderLine ol ").append("WHERE o.C_Order_ID=ol.C_Order_ID AND ol.QtyOrdered<>ol.QtyInvoiced) ").append("AND o.C_DocType_ID IN (SELECT C_DocType_ID FROM C_DocType ").append("WHERE DocBaseType='SOO' AND DocSubTypeSO NOT IN ('ON','OB','WR')) ").append("ORDER BY M_Warehouse_ID, PriorityRule, C_BPartner_ID, Bill_Location_ID, C_Order_ID");
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            int index = 1;
            if (this.p_Selection) {
                pstmt.setInt(index, this.getAD_PInstance_ID());
            } else {
                if (this.p_AD_Org_ID != 0) {
                    pstmt.setInt(index++, this.p_AD_Org_ID);
                }
                if (this.p_C_BPartner_ID != 0) {
                    pstmt.setInt(index++, this.p_C_BPartner_ID);
                }
                if (this.p_C_Order_ID != 0) {
                    pstmt.setInt(index++, this.p_C_Order_ID);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        return this.generate((PreparedStatement)pstmt);
    }

    private String generate(PreparedStatement pstmt) {
        block30: {
            ResultSet rs = null;
            try {
                try {
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MInOutLine shipLine;
                        MInOutLine[] shipLines;
                        MInOut ship;
                        int i;
                        MInOut[] shipments;
                        MOrder order = new MOrder(this.getCtx(), rs, this.get_TrxName());
                        StringBuilder msgsup = new StringBuilder(Msg.getMsg((Properties)this.getCtx(), (String)"Processing")).append(" ").append(order.getDocumentInfo());
                        this.statusUpdate(msgsup.toString());
                        if (!this.p_ConsolidateDocument || this.m_invoice != null && this.m_invoice.getC_BPartner_Location_ID() != order.getBill_Location_ID()) {
                            this.completeInvoice();
                        }
                        boolean completeOrder = "O".equals(order.getInvoiceRule());
                        boolean doInvoice = false;
                        if ("S".equals(order.getInvoiceRule())) {
                            this.m_bp = new MBPartner(this.getCtx(), order.getBill_BPartner_ID(), null);
                            if (this.m_bp.getC_InvoiceSchedule_ID() == 0) {
                                this.log.warning("BPartner has no Schedule - set to After Delivery");
                                order.setInvoiceRule("D");
                                order.saveEx();
                            } else {
                                MInvoiceSchedule is = MInvoiceSchedule.get((Properties)this.getCtx(), (int)this.m_bp.getC_InvoiceSchedule_ID(), (String)this.get_TrxName());
                                if (!is.canInvoice(order.getDateOrdered(), order.getGrandTotal())) continue;
                                doInvoice = true;
                            }
                        }
                        if (doInvoice || "D".equals(order.getInvoiceRule())) {
                            shipments = order.getShipments();
                            i = 0;
                            while (i < shipments.length) {
                                ship = shipments[i];
                                if (ship.isComplete() && !ship.getDocStatus().equals("RE")) {
                                    shipLines = ship.getLines(false);
                                    int j = 0;
                                    while (j < shipLines.length) {
                                        shipLine = shipLines[j];
                                        if (order.isOrderLine(shipLine.getC_OrderLine_ID()) && !shipLine.isInvoiced()) {
                                            this.createLine(order, ship, shipLine);
                                        }
                                        ++j;
                                    }
                                    this.m_line += 1000;
                                }
                                ++i;
                            }
                        } else {
                            MOrderLine[] oLines = order.getLines(true, null);
                            i = 0;
                            while (i < oLines.length) {
                                MOrderLine oLine = oLines[i];
                                BigDecimal toInvoice = oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced());
                                if (toInvoice.compareTo(Env.ZERO) != 0 || oLine.getM_Product_ID() == 0) {
                                    boolean fullyDelivered;
                                    BigDecimal notInvoicedShipment = oLine.getQtyDelivered().subtract(oLine.getQtyInvoiced());
                                    boolean bl = fullyDelivered = oLine.getQtyOrdered().compareTo(oLine.getQtyDelivered()) == 0;
                                    if (completeOrder && !fullyDelivered) {
                                        if (this.log.isLoggable(Level.FINE)) {
                                            this.log.fine("Failed CompleteOrder - " + oLine);
                                        }
                                        this.addLog(0, null, null, "Failed CompleteOrder - " + oLine, oLine.get_Table_ID(), oLine.getC_OrderLine_ID());
                                        completeOrder = false;
                                        break;
                                    }
                                    if ("I".equals(order.getInvoiceRule())) {
                                        if (this.log.isLoggable(Level.FINE)) {
                                            this.log.fine("Immediate - ToInvoice=" + toInvoice + " - " + oLine);
                                        }
                                        BigDecimal qtyEntered = toInvoice;
                                        if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                                            qtyEntered = toInvoice.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4);
                                        }
                                        this.createLine(order, oLine, toInvoice, qtyEntered);
                                    } else {
                                        if (this.log.isLoggable(Level.FINE)) {
                                            this.log.fine("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine);
                                        }
                                        this.addLog(0, null, null, "Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine, oLine.get_Table_ID(), oLine.getC_OrderLine_ID());
                                    }
                                }
                                ++i;
                            }
                            if ("I".equals(order.getInvoiceRule())) {
                                this.m_line += 1000;
                            }
                        }
                        if (!completeOrder || !"O".equals(order.getInvoiceRule())) continue;
                        shipments = order.getShipments();
                        i = 0;
                        while (i < shipments.length) {
                            ship = shipments[i];
                            if (ship.isComplete() && !ship.getDocStatus().equals("RE")) {
                                shipLines = ship.getLines(false);
                                int j = 0;
                                while (j < shipLines.length) {
                                    shipLine = shipLines[j];
                                    if (order.isOrderLine(shipLine.getC_OrderLine_ID()) && !shipLine.isInvoiced()) {
                                        this.createLine(order, ship, shipLine);
                                    }
                                    ++j;
                                }
                                this.m_line += 1000;
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "", (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block30;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.completeInvoice();
        StringBuilder msgreturn = new StringBuilder("@Created@ = ").append(this.m_created);
        return msgreturn.toString();
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qtyInvoiced, BigDecimal qtyEntered) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            if (!this.m_invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (o)");
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setOrderLine(orderLine);
        line.setQtyInvoiced(qtyInvoiced);
        line.setQtyEntered(qtyEntered);
        line.setLine(this.m_line + orderLine.getLine());
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (o)");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(line.toString());
        }
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            if (!this.m_invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (s)");
            }
        }
        if (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID()) {
            MDocType dt = MDocType.get((Properties)this.getCtx(), (int)ship.getC_DocType_ID());
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get((Properties)this.getCtx(), (int)order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat((int)15, (Language)Language.getLanguage((String)AD_Language));
            StringBuilder reference = new StringBuilder().append(dt.getPrintName(this.m_bp.getAD_Language())).append(": ").append(ship.getDocumentNo()).append(" - ").append(format.format(ship.getMovementDate()));
            this.m_ship = ship;
            MInvoiceLine line = new MInvoiceLine(this.m_invoice);
            line.setIsDescription(true);
            line.setDescription(reference.toString());
            line.setLine(this.m_line + sLine.getLine() - 2);
            if (!line.save()) {
                throw new IllegalStateException("Could not create Invoice Comment Line (sh)");
            }
            if (order.getBill_Location_ID() != ship.getC_BPartner_Location_ID()) {
                MLocation addr = MLocation.getBPLocation((Properties)this.getCtx(), (int)ship.getC_BPartner_Location_ID(), null);
                line = new MInvoiceLine(this.m_invoice);
                line.setIsDescription(true);
                line.setDescription(addr.toString());
                line.setLine(this.m_line + sLine.getLine() - 1);
                if (!line.save()) {
                    throw new IllegalStateException("Could not create Invoice Comment Line 2 (sh)");
                }
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setShipLine(sLine);
        if (sLine.sameOrderLineUOM()) {
            line.setQtyEntered(sLine.getQtyEntered());
        } else {
            line.setQtyEntered(sLine.getMovementQty());
        }
        line.setQtyInvoiced(sLine.getMovementQty());
        line.setLine(this.m_line + sLine.getLine());
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (s)");
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(line.toString());
        }
    }

    private void completeInvoice() {
        if (this.m_invoice != null) {
            MOrder order = new MOrder(this.getCtx(), this.m_invoice.getC_Order_ID(), this.get_TrxName());
            if (order != null) {
                this.m_invoice.setPaymentRule(order.getPaymentRule());
                this.m_invoice.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
                this.m_invoice.saveEx();
                this.m_invoice.load(this.m_invoice.get_TrxName());
                MOrderPaySchedule[] opss = MOrderPaySchedule.getOrderPaySchedule((Properties)this.getCtx(), (int)order.getC_Order_ID(), (int)0, (String)this.get_TrxName());
                MInvoicePaySchedule[] ipss = MInvoicePaySchedule.getInvoicePaySchedule((Properties)this.getCtx(), (int)this.m_invoice.getC_Invoice_ID(), (int)0, (String)this.get_TrxName());
                if (ipss.length == 0 && opss.length > 0) {
                    BigDecimal ogt = order.getGrandTotal();
                    BigDecimal igt = this.m_invoice.getGrandTotal();
                    BigDecimal percent = Env.ONE;
                    if (ogt.compareTo(igt) != 0) {
                        percent = igt.divide(ogt, 10, 4);
                    }
                    MCurrency cur = MCurrency.get((Properties)order.getCtx(), (int)order.getC_Currency_ID());
                    int scale = cur.getStdPrecision();
                    MOrderPaySchedule[] mOrderPayScheduleArray = opss;
                    int n = opss.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MOrderPaySchedule ops = mOrderPayScheduleArray[n2];
                        MInvoicePaySchedule ips = new MInvoicePaySchedule(this.getCtx(), 0, this.get_TrxName());
                        PO.copyValues((PO)ops, (PO)ips);
                        if (percent != Env.ONE) {
                            BigDecimal propDueAmt = ops.getDueAmt().multiply(percent);
                            if (propDueAmt.scale() > scale) {
                                propDueAmt = propDueAmt.setScale(scale, 4);
                            }
                            ips.setDueAmt(propDueAmt);
                        }
                        ips.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
                        ips.setAD_Org_ID(ops.getAD_Org_ID());
                        ips.setProcessing(ops.isProcessing());
                        ips.setIsActive(ops.isActive());
                        ips.saveEx();
                        ++n2;
                    }
                    this.m_invoice.validatePaySchedule();
                    this.m_invoice.saveEx();
                }
            }
            if (!this.m_invoice.processIt(this.p_docAction)) {
                this.log.warning("completeInvoice - failed: " + this.m_invoice);
                this.addLog(0, null, null, "completeInvoice - failed: " + this.m_invoice, this.m_invoice.get_Table_ID(), this.m_invoice.getC_Invoice_ID());
                throw new IllegalStateException("Invoice Process Failed: " + this.m_invoice + " - " + this.m_invoice.getProcessMsg());
            }
            this.m_invoice.saveEx();
            String message = Msg.parseTranslation((Properties)this.getCtx(), (String)("@InvoiceProcessed@ " + this.m_invoice.getDocumentNo()));
            this.addLog(this.m_invoice.getC_Invoice_ID(), this.m_invoice.getDateInvoiced(), null, message, this.m_invoice.get_Table_ID(), this.m_invoice.getC_Invoice_ID());
            ++this.m_created;
        }
        this.m_invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }
}

