/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFiller;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.adempiere.base.Service;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.PrintUtil;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.report.JRViewerProvider;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.utils.DigestOfFile;

public class ReportStarter
implements ProcessCall,
ClientProcess {
    private static final int DEFAULT_SWAP_MAX_PAGES = 100;
    private static CLogger log = CLogger.getCLogger(ReportStarter.class);
    private static File REPORT_HOME = null;
    private static JasperPrint jasperPrint;
    private ProcessInfo processInfo;
    private MAttachment attachment;
    private IProcessUI m_processUI;

    static {
        String reportPath = System.getProperty("org.compiere.report.path");
        REPORT_HOME = reportPath == null ? new File(String.valueOf(Ini.getAdempiereHome()) + File.separator + "reports") : new File(reportPath);
    }

    private File getRemoteFile(String reportLocation, String localPath) {
        try {
            URL reportURL = new URL(reportLocation);
            InputStream in = reportURL.openStream();
            File downloadedFile = new File(localPath);
            if (downloadedFile.exists()) {
                downloadedFile.delete();
            }
            FileOutputStream fout = new FileOutputStream(downloadedFile);
            byte[] buf = new byte[1024];
            int s = 0;
            while ((s = in.read(buf, 0, 1024)) > 0) {
                fout.write(buf, 0, s);
            }
            in.close();
            fout.flush();
            fout.close();
            return downloadedFile;
        }
        catch (FileNotFoundException e) {
            if (reportLocation.indexOf("Subreport") == -1) {
                log.warning("404 not found: Report cannot be found on server " + e.getMessage());
            }
            return null;
        }
        catch (IOException e) {
            log.severe("I/O error when trying to download (sub)report from server " + e.getMessage());
            return null;
        }
    }

    private File[] getHttpSubreports(String reportName, String reportPath, String fileExtension) {
        ArrayList<File> subreports = new ArrayList<File>();
        String remoteDir = reportPath.substring(0, reportPath.lastIndexOf("/"));
        int i = 1;
        while (i < 10) {
            File subreport = this.httpDownloadedReport(String.valueOf(remoteDir) + "/" + reportName + i + fileExtension);
            if (subreport == null) break;
            subreports.add(subreport);
            ++i;
        }
        File[] subreportsTemp = new File[]{};
        subreportsTemp = subreports.toArray(subreportsTemp);
        return subreportsTemp;
    }

    private File httpDownloadedReport(String reportLocation) {
        File reportFile = null;
        File downloadedFile = null;
        if (log.isLoggable(Level.INFO)) {
            log.info(" report deployed to " + reportLocation);
        }
        try {
            String[] tmps = reportLocation.split("/");
            String cleanFile = tmps[tmps.length - 1];
            String localFile = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + cleanFile;
            String downloadedLocalFile = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + "TMP" + cleanFile;
            reportFile = new File(localFile);
            if (reportFile.exists()) {
                String localMD5hash = DigestOfFile.GetLocalMD5Hash(reportFile);
                String remoteMD5Hash = this.getRemoteMD5(reportLocation);
                if (log.isLoggable(Level.INFO)) {
                    log.info("MD5 for local file is " + localMD5hash);
                }
                if (remoteMD5Hash != null) {
                    if (localMD5hash.equals(remoteMD5Hash)) {
                        if (log.isLoggable(Level.INFO)) {
                            log.info(" no need to download: local report is up-to-date");
                        }
                    } else {
                        if (log.isLoggable(Level.INFO)) {
                            log.info(" report on server is different that local one, download and replace");
                        }
                        downloadedFile = this.getRemoteFile(reportLocation, downloadedLocalFile);
                        reportFile.delete();
                        downloadedFile.renameTo(reportFile);
                    }
                } else {
                    log.warning("Remote hashing is not available did you deployed webApp.ear?");
                    downloadedFile = this.getRemoteFile(reportLocation, downloadedLocalFile);
                    if (DigestOfFile.md5localHashCompare(reportFile, downloadedFile)) {
                        if (log.isLoggable(Level.INFO)) {
                            log.info(" no need to replace your existing report");
                        }
                    } else {
                        if (log.isLoggable(Level.INFO)) {
                            log.info(" report on server is different that local one, replacing");
                        }
                        reportFile.delete();
                        downloadedFile.renameTo(reportFile);
                    }
                }
            } else {
                reportFile = this.getRemoteFile(reportLocation, localFile);
            }
        }
        catch (Exception e) {
            log.severe("Unknown exception: " + e.getMessage());
            return null;
        }
        return reportFile;
    }

    private String getRemoteMD5(String reportLocation) {
        try {
            String md5url = reportLocation;
            md5url = md5url.indexOf("?") > 0 ? String.valueOf(md5url) + "&md5=true" : String.valueOf(md5url) + "?md5=true";
            URL reportURL = new URL(md5url);
            InputStream in = reportURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int s = 0;
            while ((s = in.read(buf, 0, 1024)) > 0) {
                baos.write(buf, 0, s);
            }
            in.close();
            String hash = new String(baos.toByteArray());
            return hash;
        }
        catch (IOException e) {
            log.severe("I/O error when trying to download (sub)report from server " + e.getMessage());
            return null;
        }
    }

    protected Connection getConnection() {
        return DB.getConnectionRW();
    }

    public boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        ClassLoader cl1 = Thread.currentThread().getContextClassLoader();
        ClassLoader cl2 = JasperReport.class.getClassLoader();
        try {
            if (!cl1.equals(cl2)) {
                Thread.currentThread().setContextClassLoader(cl2);
            }
            boolean bl = this.startProcess0(ctx, pi, trx);
            return bl;
        }
        finally {
            if (!cl1.equals(Thread.currentThread().getContextClassLoader())) {
                Thread.currentThread().setContextClassLoader(cl1);
            }
        }
    }

    private boolean startProcess0(Properties ctx, ProcessInfo pi, Trx trx) {
        String trxName;
        int AD_PInstance_ID;
        Object onrows;
        int nrows;
        block85: {
            ReportData reportData;
            this.processInfo = pi;
            nrows = 0;
            onrows = null;
            String Name = pi.getTitle();
            AD_PInstance_ID = pi.getAD_PInstance_ID();
            int Record_ID = pi.getRecord_ID();
            if (log.isLoggable(Level.INFO)) {
                log.info("Name=" + Name + "  AD_PInstance_ID=" + AD_PInstance_ID + " Record_ID=" + Record_ID);
            }
            trxName = null;
            if (trx != null) {
                trxName = trx.getTrxName();
            }
            if ((reportData = this.getReportData(pi, trxName)) == null) {
                this.reportResult(AD_PInstance_ID, "Can not find report data", trxName);
                return false;
            }
            String reportPath = reportData.getReportFilePath();
            if (Util.isEmpty((String)reportPath, (boolean)true)) {
                this.reportResult(AD_PInstance_ID, "Can not find report", trxName);
                return false;
            }
            JasperData data = null;
            File reportFile = null;
            String fileExtension = "";
            HashMap<String, Object> params = new HashMap<String, Object>();
            ReportStarter.addProcessParameters(AD_PInstance_ID, params, trxName);
            this.addProcessInfoParameters(params, pi.getParameter());
            reportFile = this.getReportFile(reportPath, (String)params.get("ReportType"));
            if (reportFile == null || !reportFile.exists()) {
                log.severe("No report file found for given type, falling back to " + reportPath);
                reportFile = this.getReportFile(reportPath);
            }
            if (reportFile == null || !reportFile.exists()) {
                String tmp = "Can not find report file at path - " + reportPath;
                log.severe(tmp);
                this.reportResult(AD_PInstance_ID, tmp, trxName);
            }
            if (reportFile == null) {
                return false;
            }
            data = this.processReport(reportFile);
            fileExtension = reportFile.getName().substring(reportFile.getName().lastIndexOf("."), reportFile.getName().length());
            JasperReport jasperReport = data.getJasperReport();
            String jasperName = data.getJasperName();
            String name = jasperReport.getName();
            File reportDir = data.getReportDir();
            String resourcePath = reportDir.getAbsolutePath();
            if (resourcePath.endsWith("/") || !resourcePath.endsWith("\\")) {
                // empty if block
            }
            resourcePath = String.valueOf(resourcePath) + "/";
            params.put("SUBREPORT_DIR", resourcePath);
            params.put("RESOURCE_DIR", resourcePath);
            if (jasperReport != null && pi.getTable_ID() > 0 && Record_ID <= 0 && pi.getRecord_IDs() != null && pi.getRecord_IDs().length > 0) {
                try {
                    String originalQueryText;
                    JRQuery originalQuery = jasperReport.getQuery();
                    if (originalQuery != null && (originalQueryText = originalQuery.getText()) != null) {
                        int index2;
                        MTable table = new MTable(ctx, pi.getTable_ID(), trxName);
                        String tableName = table.getTableName();
                        String originalQueryTemp = originalQueryText.toUpperCase();
                        int index1 = originalQueryTemp.indexOf(" " + tableName.toUpperCase());
                        if (index1 != -1 && (index2 = originalQueryTemp.substring(index1).indexOf(",")) != -1) {
                            String tableVariable = originalQueryTemp.substring(index1 + tableName.length() + 1, index1 + index2);
                            if ((tableVariable = tableVariable.trim()).length() == 0) {
                                tableVariable = tableName;
                            }
                            MQuery query = new MQuery(tableName);
                            int[] nArray = pi.getRecord_IDs();
                            int n = nArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int recordId = nArray[n2];
                                query.addRestriction(String.valueOf(tableVariable) + "." + query.getTableName() + "_ID" + "=" + recordId, false, 0);
                                ++n2;
                            }
                            String newQueryText = null;
                            int index3 = originalQueryTemp.indexOf("WHERE");
                            newQueryText = index3 != -1 ? String.valueOf(originalQueryText) + " AND " + query.toString() : String.valueOf(originalQueryText) + " WHERE " + query.toString();
                            File jrxmlFile = File.createTempFile(this.makePrefix(jasperReport.getName()), ".jrxml");
                            JRXmlWriter.writeReport((JRReport)jasperReport, (OutputStream)new FileOutputStream(jrxmlFile), (String)"UTF-8");
                            JasperDesign jasperDesign = JRXmlLoader.load((File)jrxmlFile);
                            JRDesignQuery newQuery = new JRDesignQuery();
                            newQuery.setText(newQueryText);
                            jasperDesign.setQuery(newQuery);
                            LocalJasperReportsContext context = new LocalJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
                            context.setClassLoader(JasperReport.class.getClassLoader());
                            JasperCompileManager manager = JasperCompileManager.getInstance((JasperReportsContext)context);
                            JasperReport newJasperReport = manager.compile(jasperDesign);
                            if (newJasperReport != null) {
                                data.jasperReport = newJasperReport;
                                jasperReport = newJasperReport;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.severe("Failed to modify the report query");
                }
            }
            if (jasperReport != null) {
                File[] subreports = reportPath.startsWith("http://") || reportPath.startsWith("https://") ? this.getHttpSubreports(String.valueOf(jasperName) + "Subreport", reportPath, fileExtension) : (reportPath.startsWith("attachment:") ? this.getAttachmentSubreports(reportPath) : (reportPath.startsWith("resource:") ? this.getResourceSubreports(String.valueOf(name) + "Subreport", reportPath, fileExtension) : reportDir.listFiles(new FileFilter(String.valueOf(jasperName) + "Subreport", reportDir, fileExtension))));
                int i = 0;
                while (i < subreports.length) {
                    JasperData subData;
                    if ((subreports[i].getName().toLowerCase().endsWith(".jasper") || subreports[i].getName().toLowerCase().endsWith(".jrxml")) && (subData = this.processReport(subreports[i])).getJasperReport() != null) {
                        params.put(subData.getJasperName(), subData.getJasperFile().getAbsolutePath());
                    }
                    ++i;
                }
                if (Record_ID > 0) {
                    params.put("RECORD_ID", new Integer(Record_ID));
                }
                params.put("AD_PINSTANCE_ID", new Integer(AD_PInstance_ID));
                params.put("AD_CLIENT_ID", new Integer(Env.getAD_Client_ID((Properties)Env.getCtx())));
                params.put("AD_ROLE_ID", new Integer(Env.getAD_Role_ID((Properties)Env.getCtx())));
                params.put("AD_USER_ID", new Integer(Env.getAD_User_ID((Properties)Env.getCtx())));
                Language currLang = Env.getLanguage((Properties)Env.getCtx());
                String printerName = null;
                MPrintFormat printFormat = null;
                PrintInfo printInfo = null;
                ProcessInfoParameter[] pip = pi.getParameter();
                if (pip != null) {
                    int i2 = 0;
                    while (i2 < pip.length) {
                        if ("PRINT_FORMAT".equalsIgnoreCase(pip[i2].getParameterName())) {
                            printFormat = (MPrintFormat)pip[i2].getParameter();
                        }
                        if ("PRINT_INFO".equalsIgnoreCase(pip[i2].getParameterName())) {
                            printInfo = (PrintInfo)pip[i2].getParameter();
                        }
                        if ("PRINTER_NAME".equalsIgnoreCase(pip[i2].getParameterName())) {
                            printerName = (String)pip[i2].getParameter();
                        }
                        ++i2;
                    }
                }
                if (printFormat != null) {
                    if (printInfo != null && printInfo.isDocument()) {
                        currLang = printFormat.getLanguage();
                    }
                    if (printerName == null) {
                        printerName = printFormat.getPrinterName();
                    }
                }
                params.put("CURRENT_LANG", currLang.getAD_Language());
                params.put("REPORT_LOCALE", currLang.getLocale());
                File resFile = null;
                if (reportPath.startsWith("attachment:") && this.attachment != null) {
                    resFile = this.getAttachmentResourceFile(jasperName, currLang);
                } else if (reportPath.startsWith("resource:")) {
                    resFile = this.getResourcesForResourceFile(jasperName, currLang);
                } else {
                    resFile = new File(String.valueOf(jasperName) + "_" + currLang.getLocale().getLanguage() + ".properties");
                    if (!resFile.exists()) {
                        resFile = null;
                    }
                    if (resFile == null && !(resFile = new File(String.valueOf(jasperName) + ".properties")).exists()) {
                        resFile = null;
                    }
                }
                if (resFile != null) {
                    try {
                        PropertyResourceBundle res = new PropertyResourceBundle(new FileInputStream(resFile));
                        params.put("RESOURCE", res);
                    }
                    catch (IOException res) {
                        // empty catch block
                    }
                }
                Connection conn = null;
                JRSwapFileVirtualizer virtualizer = null;
                int maxPages = MSysConfig.getIntValue((String)"JASPER_SWAP_MAX_PAGES", (int)100);
                try {
                    try {
                        conn = this.getConnection();
                        String swapPath = System.getProperty("java.io.tmpdir");
                        JRSwapFile swapFile = new JRSwapFile(swapPath, 1024, 1024);
                        virtualizer = new JRSwapFileVirtualizer(maxPages, swapFile, true);
                        params.put("REPORT_VIRTUALIZER", virtualizer);
                        DefaultJasperReportsContext jasperContext = DefaultJasperReportsContext.getInstance();
                        JRPropertiesUtil.getInstance((JasperReportsContext)jasperContext).setProperty("net.sf.jasperreports.awt.ignore.missing.font", "true");
                        JRBaseFiller filler = JRFiller.createFiller((JasperReportsContext)jasperContext, (JasperReport)jasperReport);
                        JasperPrint jasperPrint = filler.fill(params, conn);
                        onrows = filler.getVariableValue("REPORT_COUNT");
                        if (!this.processInfo.isExport()) {
                            if (reportData.isDirectPrint()) {
                                if (log.isLoggable(Level.INFO)) {
                                    log.info("ReportStarter.startProcess print report -" + jasperPrint.getName());
                                }
                                if (!this.processInfo.isBatch()) {
                                    PrinterJob printerJob = PrintUtil.getPrinterJob((String)printerName);
                                    HashPrintRequestAttributeSet prats = new HashPrintRequestAttributeSet();
                                    if (printInfo == null || printInfo.isDocumentCopy() || printInfo.getCopies() < 1) {
                                        prats.add(new Copies(1));
                                    } else {
                                        prats.add(new Copies(printInfo.getCopies()));
                                    }
                                    Locale locale = Language.getLoginLanguage().getLocale();
                                    String printFormat_name = printFormat == null ? "" : printFormat.getName();
                                    int numCopies = printInfo == null ? 0 : printInfo.getCopies();
                                    prats.add(new JobName(String.valueOf(printFormat_name) + "_" + pi.getRecord_ID(), locale));
                                    prats.add(PrintUtil.getJobPriority((int)jasperPrint.getPages().size(), (int)numCopies, (boolean)true));
                                    JRPrintServiceExporter exporter = new JRPrintServiceExporter();
                                    exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                                    exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE, (Object)printerJob.getPrintService());
                                    exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET, (Object)printerJob.getPrintService().getAttributes());
                                    exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET, (Object)prats);
                                    exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG, (Object)Boolean.FALSE);
                                    exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG, (Object)Boolean.FALSE);
                                    exporter.exportReport();
                                } else {
                                    try {
                                        File PDF = File.createTempFile(this.makePrefix(jasperPrint.getName()), ".pdf");
                                        DefaultJasperReportsContext jrContext = DefaultJasperReportsContext.getInstance();
                                        LocalJasperReportsContext ljrContext = new LocalJasperReportsContext((JasperReportsContext)jrContext);
                                        ljrContext.setClassLoader(this.getClass().getClassLoader());
                                        JRPdfExporter exporter = new JRPdfExporter((JasperReportsContext)ljrContext);
                                        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                                        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)PDF.getAbsolutePath());
                                        exporter.exportReport();
                                        this.processInfo.setPDFReport(PDF);
                                    }
                                    catch (IOException e) {
                                        log.severe("ReportStarter.startProcess: Can not make PDF File - " + e.getMessage());
                                    }
                                }
                            } else {
                                if (log.isLoggable(Level.INFO)) {
                                    log.info("ReportStarter.startProcess run report -" + jasperPrint.getName());
                                }
                                JRViewerProvider viewerLauncher = (JRViewerProvider)Service.locator().locate(JRViewerProvider.class).getService();
                                viewerLauncher.openViewer(jasperPrint, String.valueOf(pi.getTitle()) + " - " + reportPath);
                            }
                        } else {
                            try {
                                String ext = pi.getExportFileExtension();
                                if (ext == null) {
                                    ext = "pdf";
                                }
                                File file = File.createTempFile(this.makePrefix(jasperPrint.getName()), "." + ext);
                                DefaultJasperReportsContext jrContext = DefaultJasperReportsContext.getInstance();
                                LocalJasperReportsContext ljrContext = new LocalJasperReportsContext((JasperReportsContext)jrContext);
                                ljrContext.setClassLoader(this.getClass().getClassLoader());
                                JRPdfExporter exporter = null;
                                if (ext.equals("pdf")) {
                                    exporter = new JRPdfExporter((JasperReportsContext)ljrContext);
                                } else if (ext.equals("ps")) {
                                    exporter = new JRPrintServiceExporter((JasperReportsContext)ljrContext);
                                } else if (ext.equals("xml")) {
                                    exporter = new JRXmlExporter((JasperReportsContext)ljrContext);
                                } else if (ext.equals("csv") || ext.equals("ssv")) {
                                    exporter = new JRCsvExporter((JasperReportsContext)ljrContext);
                                } else if (ext.equals("txt")) {
                                    exporter = new JRTextExporter((JasperReportsContext)ljrContext);
                                } else if (ext.equals("html") || ext.equals("htm")) {
                                    exporter = new JRHtmlExporter((JasperReportsContext)ljrContext);
                                } else if (ext.equals("xls")) {
                                    exporter = new JRXlsExporter((JasperReportsContext)ljrContext);
                                } else {
                                    log.severe("FileInvalidExtension=" + ext);
                                }
                                if (exporter == null) {
                                    exporter = new JRPdfExporter((JasperReportsContext)ljrContext);
                                }
                                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)new FileOutputStream(file));
                                exporter.exportReport();
                                this.processInfo.setExportFile(file);
                            }
                            catch (IOException e) {
                                log.severe("ReportStarter.startProcess: Can not export PDF File - " + e.getMessage());
                            }
                        }
                    }
                    catch (JRException e) {
                        log.severe("ReportStarter.startProcess: Can not run report - " + e.getMessage());
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        if (virtualizer != null) {
                            virtualizer.cleanup();
                        }
                        break block85;
                    }
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (virtualizer != null) {
                        virtualizer.cleanup();
                    }
                    throw throwable;
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (virtualizer != null) {
                    virtualizer.cleanup();
                }
            }
        }
        if (onrows != null && onrows instanceof Integer) {
            nrows = (Integer)onrows;
            this.processInfo.setRowCount(nrows);
        }
        this.reportResult(AD_PInstance_ID, null, trxName);
        return true;
    }

    public static JasperPrint getJasperPrint() {
        return jasperPrint;
    }

    private String makePrefix(String name) {
        char[] nameArray;
        StringBuilder prefix = new StringBuilder();
        char[] cArray = nameArray = name.toCharArray();
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
            } else {
                prefix.append("_");
            }
            ++n2;
        }
        return prefix.toString();
    }

    private File getAttachmentResourceFile(String jasperName, Language currLang) {
        File resFile = null;
        MAttachmentEntry[] entries = this.attachment.getEntries();
        String resname = String.valueOf(jasperName) + "_" + currLang.getLocale().getLanguage() + ".properties";
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getName().equals(resname)) {
                resFile = this.getAttachmentEntryFile(entries[i]);
                break;
            }
            ++i;
        }
        if (resFile == null) {
            resname = String.valueOf(jasperName) + ".properties";
            i = 0;
            while (i < entries.length) {
                if (entries[i].getName().equals(resname)) {
                    resFile = this.getAttachmentEntryFile(entries[i]);
                    break;
                }
                ++i;
            }
        }
        return resFile;
    }

    private File getResourcesForResourceFile(String jasperName, Language currLang) {
        File resFile = null;
        try {
            resFile = this.getFileAsResource(String.valueOf(jasperName) + "_" + currLang.getLocale().getLanguage() + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resFile;
    }

    private File[] getAttachmentSubreports(String reportPath) {
        String name = reportPath.substring("attachment:".length()).trim();
        ArrayList<File> subreports = new ArrayList<File>();
        MAttachmentEntry[] entries = this.attachment.getEntries();
        int i = 0;
        while (i < entries.length) {
            File reportFile;
            if (!entries[i].getName().equals(name) && (entries[i].getName().toLowerCase().endsWith(".jrxml") || entries[i].getName().toLowerCase().endsWith(".jasper") || entries[i].getName().toLowerCase().endsWith(".jpg") || entries[i].getName().toLowerCase().endsWith(".png")) && (reportFile = this.getAttachmentEntryFile(entries[i])) != null) {
                subreports.add(reportFile);
            }
            ++i;
        }
        File[] subreportsTemp = new File[]{};
        subreportsTemp = subreports.toArray(subreportsTemp);
        return subreportsTemp;
    }

    private File[] getResourceSubreports(String reportName, String reportPath, String fileExtension) {
        ArrayList<File> subreports = new ArrayList<File>();
        String remoteDir = reportPath.substring(0, reportPath.lastIndexOf("/"));
        int i = 1;
        while (i < 10) {
            File subreport = null;
            try {
                subreport = this.getFileAsResource(String.valueOf(remoteDir) + "/" + reportName + i + fileExtension);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (subreport == null) break;
            subreports.add(subreport);
            ++i;
        }
        File[] subreportsTemp = new File[subreports.size()];
        subreportsTemp = subreports.toArray(subreportsTemp);
        return subreportsTemp;
    }

    protected File getReportFile(String reportPath, String reportType) {
        if (reportType != null) {
            int cpos = reportPath.lastIndexOf(46);
            reportPath = String.valueOf(reportPath.substring(0, cpos)) + "_" + reportType + reportPath.substring(cpos, reportPath.length());
        }
        return this.getReportFile(reportPath);
    }

    protected File getReportFile(String reportPath) {
        File reportFile = null;
        if (reportPath.startsWith("http://") || reportPath.startsWith("https://")) {
            reportFile = this.httpDownloadedReport(reportPath);
        } else if (reportPath.startsWith("attachment:")) {
            reportFile = this.downloadAttachment(reportPath);
        } else if (reportPath.startsWith("/")) {
            reportFile = new File(reportPath);
        } else if (reportPath.startsWith("file:/")) {
            try {
                reportFile = new File(new URI(reportPath));
            }
            catch (URISyntaxException e) {
                log.warning(e.getLocalizedMessage());
                reportFile = null;
            }
        } else if (reportPath.startsWith("resource:")) {
            try {
                reportFile = this.getFileAsResource(reportPath);
            }
            catch (Exception e) {
                log.warning(e.getLocalizedMessage());
                reportFile = null;
            }
        } else {
            reportFile = new File(REPORT_HOME, reportPath);
        }
        if (reportFile != null) {
            System.setProperty("org.compiere.report.path", reportFile.getParentFile().getAbsolutePath());
        }
        return reportFile;
    }

    private File getFileAsResource(String reportPath) throws Exception {
        String name = reportPath.substring("resource:".length()).trim();
        String localName = name.replace('/', '_');
        if (log.isLoggable(Level.INFO)) {
            log.info("reportPath = " + reportPath);
            log.info("getting resource from = " + this.getClass().getClassLoader().getResource(name));
        }
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(name);
        String localFile = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + localName;
        if (log.isLoggable(Level.INFO)) {
            log.info("localFile = " + localFile);
        }
        File reportFile = new File(localFile);
        FileOutputStream out = null;
        out = new FileOutputStream(reportFile);
        if (out != null) {
            int len;
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            inputStream.close();
        }
        return reportFile;
    }

    private File downloadAttachment(String reportPath) {
        File reportFile = null;
        String name = reportPath.substring("attachment:".length()).trim();
        MProcess process = new MProcess(Env.getCtx(), this.processInfo.getAD_Process_ID(), this.processInfo.getTransactionName());
        this.attachment = process.getAttachment();
        if (this.attachment != null) {
            MAttachmentEntry[] entries = this.attachment.getEntries();
            MAttachmentEntry entry = null;
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getName().equals(name)) {
                    entry = entries[i];
                    break;
                }
                ++i;
            }
            if (entry != null) {
                reportFile = this.getAttachmentEntryFile(entry);
            }
        }
        return reportFile;
    }

    private File getAttachmentEntryFile(MAttachmentEntry entry) {
        String localFile = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + entry.getName();
        String downloadedLocalFile = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + "TMP" + entry.getName();
        File reportFile = new File(localFile);
        if (reportFile.exists()) {
            String entryMD5hash;
            String localMD5hash = DigestOfFile.GetLocalMD5Hash(reportFile);
            if (localMD5hash.equals(entryMD5hash = DigestOfFile.getMD5Hash(entry.getData()))) {
                log.info(" no need to download: local report is up-to-date");
            } else {
                log.info(" report on server is different that local one, download and replace");
                File downloadedFile = new File(downloadedLocalFile);
                entry.getFile(downloadedFile);
                if (!reportFile.delete()) {
                    throw new AdempiereException("Cannot delete temporary file " + reportFile.toString());
                }
                if (!downloadedFile.renameTo(reportFile)) {
                    throw new AdempiereException("Cannot rename temporary file " + downloadedFile.toString() + " to " + reportFile.toString());
                }
            }
        } else {
            entry.getFile(reportFile);
        }
        return reportFile;
    }

    protected void reportResult(int AD_PInstance_ID, String errMsg, String trxName) {
        int result = errMsg == null ? 1 : 0;
        String sql = "UPDATE AD_PInstance SET Result=?, ErrorMsg=? WHERE AD_PInstance_ID=" + AD_PInstance_ID;
        DB.executeUpdateEx((String)sql, (Object[])new Object[]{result, errMsg}, (String)trxName);
    }

    protected JasperData processReport(File reportFile) {
        File reportDir;
        File jasperFile;
        if (log.isLoggable(Level.INFO)) {
            log.info("reportFile.getAbsolutePath() = " + reportFile.getAbsolutePath());
        }
        JasperReport jasperReport = null;
        String jasperName = reportFile.getName();
        int pos = jasperName.indexOf(46);
        if (pos != -1) {
            jasperName = jasperName.substring(0, pos);
        }
        if ((jasperFile = new File((reportDir = reportFile.getParentFile()).getAbsolutePath(), String.valueOf(jasperName) + ".jasper")).exists()) {
            if (reportFile.lastModified() == jasperFile.lastModified()) {
                if (log.isLoggable(Level.INFO)) {
                    log.info(" no need to compile use " + jasperFile.getAbsolutePath());
                }
                try {
                    jasperReport = (JasperReport)JRLoader.loadObjectFromFile((String)jasperFile.getAbsolutePath());
                }
                catch (JRException e) {
                    jasperReport = null;
                    log.severe("Can not load report - " + e.getMessage());
                }
            } else {
                jasperReport = this.compileReport(reportFile, jasperFile);
            }
        } else {
            jasperReport = this.compileReport(reportFile, jasperFile);
        }
        return new JasperData(jasperReport, reportDir, jasperName, jasperFile);
    }

    private static void addProcessParameters(int AD_PInstance_ID, Map<String, Object> params, String trxName) {
        String sql = "SELECT  ParameterName,P_String,P_String_To,P_Number,P_Number_To,P_Date,P_Date_To,Info,Info_To FROM AD_PInstance_Para WHERE AD_PInstance_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)"SELECT  ParameterName,P_String,P_String_To,P_Number,P_Number_To,P_Date,P_Date_To,Info,Info_To FROM AD_PInstance_Para WHERE AD_PInstance_ID=?", (int)1003, (int)1007, (String)trxName);
                pstmt.setInt(1, AD_PInstance_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString(1);
                    String pStr = rs.getString(2);
                    String pStrTo = rs.getString(3);
                    BigDecimal pNum = rs.getBigDecimal(4);
                    BigDecimal pNumTo = rs.getBigDecimal(5);
                    Timestamp pDate = rs.getTimestamp(6);
                    Timestamp pDateTo = rs.getTimestamp(7);
                    if (pStr != null) {
                        if (pStrTo != null) {
                            params.put(String.valueOf(name) + "1", pStr);
                            params.put(String.valueOf(name) + "2", pStrTo);
                        } else {
                            params.put(name, pStr);
                        }
                    } else if (pDate != null) {
                        if (pDateTo != null) {
                            params.put(String.valueOf(name) + "1", pDate);
                            params.put(String.valueOf(name) + "2", pDateTo);
                        } else {
                            params.put(name, pDate);
                        }
                    } else if (pNum != null) {
                        if (name.endsWith("_ID")) {
                            if (pNumTo != null) {
                                params.put(String.valueOf(name) + "1", pNum.intValue());
                                params.put(String.valueOf(name) + "2", pNumTo.intValue());
                            } else {
                                params.put(name, pNum.intValue());
                            }
                        } else if (pNumTo != null) {
                            params.put(String.valueOf(name) + "1", pNum);
                            params.put(String.valueOf(name) + "2", pNumTo);
                        } else {
                            params.put(name, pNum);
                        }
                    }
                    String info = rs.getString(8);
                    String infoTo = rs.getString(9);
                    params.put(String.valueOf(name) + "_Info1", info != null ? info : "");
                    params.put(String.valueOf(name) + "_Info2", infoTo != null ? infoTo : "");
                }
            }
            catch (SQLException e) {
                throw new DBException(e, "SELECT  ParameterName,P_String,P_String_To,P_Number,P_Number_To,P_Date,P_Date_To,Info,Info_To FROM AD_PInstance_Para WHERE AD_PInstance_ID=?");
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
    }

    private void addProcessInfoParameters(Map<String, Object> params, ProcessInfoParameter[] para) {
        if (para != null) {
            int i = 0;
            while (i < para.length) {
                if (para[i].getParameter_To() == null) {
                    params.put(para[i].getParameterName(), para[i].getParameter());
                } else {
                    params.put(String.valueOf(para[i].getParameterName()) + "1", para[i].getParameter());
                    params.put(String.valueOf(para[i].getParameterName()) + "2", para[i].getParameter_To());
                }
                ++i;
            }
        }
    }

    private JasperReport compileReport(File reportFile, File jasperFile) {
        JasperReport compiledJasperReport = null;
        try {
            LocalJasperReportsContext context = new LocalJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
            context.setClassLoader(JasperReport.class.getClassLoader());
            JasperCompileManager manager = JasperCompileManager.getInstance((JasperReportsContext)context);
            manager.compileToFile(reportFile.getAbsolutePath(), jasperFile.getAbsolutePath());
            jasperFile.setLastModified(reportFile.lastModified());
            compiledJasperReport = (JasperReport)JRLoader.loadObject((File)jasperFile);
        }
        catch (JRException e) {
            log.log(Level.SEVERE, "Error", (Throwable)e);
        }
        return compiledJasperReport;
    }

    public ReportData getReportData(ProcessInfo pi, String trxName) {
        ReportData reportData;
        boolean directPrint;
        String path;
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        block7: {
            log.info("");
            sql = "SELECT pr.JasperReport, pr.IsDirectPrint FROM AD_Process pr, AD_PInstance pi WHERE pr.AD_Process_ID = pi.AD_Process_ID  AND pi.AD_PInstance_ID=?";
            pstmt = null;
            rs = null;
            pstmt = DB.prepareStatement((String)sql, (int)1003, (int)1007, (String)trxName);
            pstmt.setInt(1, pi.getAD_PInstance_ID());
            rs = pstmt.executeQuery();
            path = null;
            directPrint = false;
            boolean isPrintPreview = pi.isPrintPreview();
            if (rs.next()) {
                path = rs.getString(1);
                if ("Y".equalsIgnoreCase(rs.getString(2)) && !Ini.isPropertyBool((String)"PrintPreview") && !isPrintPreview) {
                    directPrint = true;
                }
                break block7;
            }
            log.severe("data not found; sql = " + sql);
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return null;
        }
        try {
            reportData = new ReportData(path, directPrint);
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return reportData;
    }

    public void setProcessUI(IProcessUI processUI) {
        this.m_processUI = processUI;
    }

    static class FileFilter
    implements FilenameFilter {
        private String reportStart;
        private File directory;
        private String extension;

        public FileFilter(String reportStart, File directory, String extension) {
            this.reportStart = reportStart;
            this.directory = directory;
            this.extension = extension;
        }

        @Override
        public boolean accept(File file, String name) {
            int pos;
            return file.equals(this.directory) && name.startsWith(this.reportStart) && (pos = name.lastIndexOf(this.extension)) != -1 && pos == name.length() - this.extension.length();
        }
    }

    public static class JasperData
    implements Serializable {
        private static final long serialVersionUID = 4375195020654531202L;
        private JasperReport jasperReport;
        private File reportDir;
        private String jasperName;
        private File jasperFile;

        public JasperData(JasperReport jasperReport, File reportDir, String jasperName, File jasperFile) {
            this.jasperReport = jasperReport;
            this.reportDir = reportDir;
            this.jasperName = jasperName;
            this.jasperFile = jasperFile;
        }

        public JasperReport getJasperReport() {
            return this.jasperReport;
        }

        public File getReportDir() {
            return this.reportDir;
        }

        public String getJasperName() {
            return this.jasperName;
        }

        public File getJasperFile() {
            return this.jasperFile;
        }
    }

    static class ReportData {
        private String reportFilePath;
        private boolean directPrint;

        public ReportData(String reportFilePath, boolean directPrint) {
            this.reportFilePath = reportFilePath;
            this.directPrint = directPrint;
        }

        public String getReportFilePath() {
            return this.reportFilePath;
        }

        public boolean isDirectPrint() {
            return this.directPrint;
        }
    }
}

