/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.ReportViewColElementHandler;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_ReportView;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReportViewElementHandler
extends AbstractElementHandler {
    private ReportViewColElementHandler columnHandler = new ReportViewColElementHandler();
    private List<Integer> views = new ArrayList<Integer>();

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List notfound;
        List excludes = this.defaultExcludeList("AD_ReportView");
        X_AD_ReportView mReportview = (X_AD_ReportView)this.findPO(ctx, element);
        if (mReportview == null) {
            String name = this.getStringValue(element, "Name");
            int id = this.findIdByName(ctx, "AD_ReportView", name);
            mReportview = new X_AD_ReportView(ctx.ctx, id, this.getTrxName(ctx));
        }
        PoFiller filler = new PoFiller(ctx, (PO)mReportview, element, (AbstractElementHandler)this);
        if (mReportview.getAD_ReportView_ID() == 0 && this.isOfficialId(element, "AD_ReportView_ID")) {
            mReportview.setAD_ReportView_ID(this.getIntValue(element, "AD_ReportView_ID"));
        }
        if ((notfound = filler.autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfound.toString();
            return;
        }
        if (mReportview.is_new() || mReportview.is_Changed()) {
            X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_ReportView", 361);
            String action = null;
            if (!mReportview.is_new()) {
                this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_ReportView", (PO)mReportview);
                action = "Update";
            } else {
                action = "New";
            }
            if (mReportview.save(this.getTrxName(ctx))) {
                this.logImportDetail(ctx, impDetail, 1, mReportview.getName(), mReportview.get_ID(), action);
                element.recordId = mReportview.getAD_ReportView_ID();
            } else {
                this.logImportDetail(ctx, impDetail, 0, mReportview.getName(), mReportview.get_ID(), action);
                throw new POSaveFailedException("Failed to save ReportView " + mReportview.getName());
            }
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        PackOut packOut = ctx.packOut;
        int AD_ReportView_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_ReportView_ID");
        if (this.views.contains(AD_ReportView_ID)) {
            return;
        }
        this.views.add(AD_ReportView_ID);
        AttributesImpl atts = new AttributesImpl();
        X_AD_ReportView m_Reportview = new X_AD_ReportView(ctx.ctx, AD_ReportView_ID, this.getTrxName(ctx));
        ElementHandler tableHandler = packOut.getHandler("AD_Table");
        try {
            tableHandler.packOut(packOut, document, null, m_Reportview.getAD_Table_ID());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        boolean createElement = true;
        if (ctx.packOut.getFromDate() != null && m_Reportview.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            createElement = false;
        }
        if (createElement) {
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_ReportView", atts);
            this.createReportViewBinding(ctx, document, m_Reportview);
        }
        String sql = "SELECT AD_ReportView_Col_ID FROM AD_ReportView_Col WHERE AD_Reportview_ID= " + AD_ReportView_ID;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createReportViewCol(ctx, document, rs.getInt("AD_ReportView_Col_ID"));
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (createElement) {
            document.endElement("", "", "AD_ReportView");
        }
        sql = "SELECT AD_PrintFormat_ID FROM AD_PrintFormat WHERE AD_ReportView_ID= " + AD_ReportView_ID;
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ElementHandler pftHandler = packOut.getHandler("AD_PrintFormat");
                    pftHandler.packOut(packOut, document, null, rs.getInt(1));
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
    }

    private void createReportViewCol(PIPOContext ctx, TransformerHandler document, int AD_ReportView_Col_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_ReportView_Col_ID", (int)AD_ReportView_Col_ID);
        this.columnHandler.create(ctx, document);
        ctx.ctx.remove("AD_ReportView_Col_ID");
    }

    private void createReportViewBinding(PIPOContext ctx, TransformerHandler document, X_AD_ReportView m_Reportview) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Reportview);
        List excludes = this.defaultExcludeList("AD_ReportView");
        if (m_Reportview.getAD_ReportView_ID() <= 999999) {
            filler.add("AD_ReportView_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_ReportView_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_ReportView_ID");
    }
}

