/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Ref_Table;
import org.compiere.model.X_AD_Reference;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceTableElementHandler
extends AbstractElementHandler {
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes = this.defaultExcludeList("AD_Ref_Table");
        String entitytype = this.getStringValue(element, "EntityType");
        if (this.isProcessElement(ctx.ctx, entitytype)) {
            if (this.isParentSkip(element, null)) {
                element.skip = true;
                return;
            }
            X_AD_Ref_Table refTable = (X_AD_Ref_Table)this.findPO(ctx, element);
            if (refTable == null) {
                int AD_Reference_ID = 0;
                if (this.getParentId(element, "AD_Reference") > 0) {
                    AD_Reference_ID = this.getParentId(element, "AD_Reference");
                } else {
                    Element referenceElement = (Element)element.properties.get("AD_Reference_ID");
                    AD_Reference_ID = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)referenceElement, (String)this.getTrxName(ctx));
                }
                if (AD_Reference_ID <= 0 && this.isOfficialId(element, "AD_Reference_ID")) {
                    AD_Reference_ID = this.getIntValue(element, "AD_Reference_ID");
                }
                String sql = "SELECT * FROM AD_Ref_Table WHERE AD_Reference_ID = ?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                        pstmt.setInt(1, AD_Reference_ID);
                        rs = pstmt.executeQuery();
                        refTable = rs.next() ? new X_AD_Ref_Table(ctx.ctx, rs, this.getTrxName(ctx)) : new X_AD_Ref_Table(ctx.ctx, 0, this.getTrxName(ctx));
                    }
                    catch (Exception e) {
                        throw new DatabaseAccessException(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
            }
            String action = refTable.is_new() ? "New" : "Update";
            PoFiller filler = new PoFiller(ctx, (PO)refTable, element, (AbstractElementHandler)this);
            List notfounds = filler.autoFill(excludes);
            if (notfounds.size() > 0) {
                element.defer = true;
                element.unresolved = notfounds.toString();
                return;
            }
            int tableId = refTable.getAD_Table_ID();
            Element displayElement = (Element)element.properties.get("AD_Display");
            int displayColumnId = 0;
            displayColumnId = ReferenceUtils.isIDLookup((Element)displayElement) || ReferenceUtils.isUUIDLookup((Element)displayElement) ? ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)displayElement, (String)this.getTrxName(ctx)) : this.findIdByColumnAndParentId(ctx, "AD_Column", "ColumnName", displayElement.contents.toString(), "AD_Table", tableId);
            refTable.setAD_Display(displayColumnId);
            Element keyElement = (Element)element.properties.get("AD_Key");
            int keyColumnId = 0;
            keyColumnId = ReferenceUtils.isIDLookup((Element)keyElement) || ReferenceUtils.isUUIDLookup((Element)keyElement) ? ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)keyElement, (String)this.getTrxName(ctx)) : this.findIdByColumnAndParentId(ctx, "AD_Column", "ColumnName", keyElement.contents.toString(), "AD_Table", tableId);
            refTable.setAD_Key(keyColumnId);
            if (refTable.is_new() || refTable.is_Changed()) {
                refTable.saveEx();
                X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Ref_Table", 103);
                int AD_Reference_ID = refTable.getAD_Reference_ID();
                X_AD_Reference adReference = new X_AD_Reference(ctx.ctx, AD_Reference_ID, this.getTrxName(ctx));
                this.logImportDetail(ctx, impDetail, 1, adReference.getName(), refTable.getAD_Reference_ID(), action);
            }
        } else {
            element.skip = true;
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int Reference_id = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Reference_ID");
        this.createReferenceTableBinding(ctx, document, Reference_id);
    }

    private void createReferenceTableBinding(PIPOContext ctx, TransformerHandler document, int reference_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block6: {
            X_AD_Ref_Table refTable;
            block7: {
                String sql = "SELECT * FROM AD_Ref_Table WHERE AD_Reference_ID= " + reference_ID;
                pstmt = null;
                rs = null;
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                refTable = new X_AD_Ref_Table(ctx.ctx, rs, this.getTrxName(ctx));
                if (ctx.packOut.getFromDate() == null || refTable.getUpdated().compareTo(ctx.packOut.getFromDate()) >= 0) break block7;
                DB.close((ResultSet)rs, (Statement)pstmt);
                return;
            }
            try {
                try {
                    PoExporter filler;
                    AttributesImpl atts = new AttributesImpl();
                    this.addTypeName(atts, "table");
                    document.startElement("", "", "AD_Ref_Table", atts);
                    if (reference_ID <= 999999) {
                        filler = new PoExporter(ctx, document, null);
                        filler.addString("AD_Reference_ID", Integer.toString(reference_ID), new AttributesImpl());
                    }
                    filler = new PoExporter(ctx, document, (PO)refTable);
                    List excludes = this.defaultExcludeList("AD_Ref_Table");
                    excludes.add("ad_display");
                    excludes.add("ad_key");
                    filler.export(excludes);
                    filler.addTableReference("AD_Display", "AD_Column", "ColumnName", new AttributesImpl());
                    filler.addTableReference("AD_Key", "AD_Column", "ColumnName", new AttributesImpl());
                    document.endElement("", "", "AD_Ref_Table");
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                    throw new DatabaseAccessException("Failed to export Reference Table", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Reference_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Reference_ID");
    }
}

