/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.ReferenceListElementHandler;
import org.adempiere.pipo2.handler.ReferenceTableElementHandler;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Reference;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceElementHandler
extends AbstractElementHandler {
    private ReferenceListElementHandler listHandler = new ReferenceListElementHandler();
    private ReferenceTableElementHandler tableHandler = new ReferenceTableElementHandler();
    private List<Integer> references = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        PoFiller filler;
        List notfounds;
        String entitytype = this.getStringValue(element, "EntityType");
        String name = this.getStringValue(element, "Name");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        X_AD_Reference mReference = (X_AD_Reference)this.findPO(ctx, element);
        if (mReference == null) {
            int id = this.findIdByName(ctx, "AD_Reference", name);
            mReference = new X_AD_Reference(ctx.ctx, id > 0 ? id : 0, this.getTrxName(ctx));
        }
        List excludes = this.defaultExcludeList("AD_Reference");
        if (mReference.getAD_Reference_ID() == 0 && this.isOfficialId(element, "AD_Reference_ID")) {
            mReference.setAD_Reference_ID(this.getIntValue(element, "AD_Reference_ID"));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mReference, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mReference.is_new()) {
            if (!mReference.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Reference", 102);
        String action = null;
        if (!mReference.is_new()) {
            if (this.references.contains(mReference.getAD_Reference_ID())) {
                element.skip = true;
                return;
            }
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_ID(), "AD_Reference", (PO)mReference);
            action = "Update";
        } else {
            action = "New";
        }
        if (mReference.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mReference.getName(), mReference.get_ID(), action);
            this.references.add(mReference.getAD_Reference_ID());
            element.recordId = mReference.getAD_Reference_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mReference.getName(), mReference.get_ID(), action);
        throw new POSaveFailedException("Failed to save Reference " + mReference.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int Reference_id = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Reference_ID");
        if (this.references.contains(Reference_id)) {
            return;
        }
        this.references.add(Reference_id);
        AttributesImpl atts = new AttributesImpl();
        X_AD_Reference m_Reference = new X_AD_Reference(ctx.ctx, Reference_id, this.getTrxName(ctx));
        boolean createElement = true;
        if (ctx.packOut.getFromDate() != null && m_Reference.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            createElement = false;
        }
        if (createElement) {
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_Reference", atts);
            this.createReferenceBinding(ctx, document, m_Reference);
        }
        if (m_Reference.getValidationType().compareTo("L") == 0) {
            String sql1 = "SELECT AD_REF_LIST_ID FROM AD_Ref_List WHERE AD_Reference_ID= " + Reference_id;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql1, (String)this.getTrxName(ctx));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.createReferenceList(ctx, document, rs.getInt("AD_REF_LIST_ID"));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                    if (e instanceof SAXException) {
                        throw (SAXException)e;
                    }
                    if (e instanceof SQLException) {
                        throw new DatabaseAccessException("Failed to export Reference.", (Throwable)e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException("Failed to export Reference.", e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        } else if (m_Reference.getValidationType().compareTo("T") == 0) {
            this.createReferenceTable(ctx, document, Reference_id);
        }
        if (createElement) {
            document.endElement("", "", "AD_Reference");
        }
    }

    private void createReferenceTable(PIPOContext ctx, TransformerHandler document, int reference_id) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Reference_ID", (int)reference_id);
        this.tableHandler.create(ctx, document);
        ctx.ctx.remove("AD_Reference_ID");
    }

    private void createReferenceList(PIPOContext ctx, TransformerHandler document, int AD_Ref_List_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Ref_List_ID", (int)AD_Ref_List_ID);
        this.listHandler.create(ctx, document);
        ctx.ctx.remove("AD_Ref_List_ID");
    }

    private void createReferenceBinding(PIPOContext ctx, TransformerHandler document, X_AD_Reference m_Reference) {
        List excludes = this.defaultExcludeList("AD_Reference");
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Reference);
        if (m_Reference.getAD_Reference_ID() <= 999999) {
            filler.add("AD_Reference_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Reference_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Reference_ID");
    }
}

