/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.ReferenceUtils;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Role_OrgAccess;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OrgRoleElementHandler
extends AbstractElementHandler {
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        PoFiller filler;
        List notfounds;
        List excludes = this.defaultExcludeList("AD_Role_OrgAccess");
        X_AD_Role_OrgAccess po = (X_AD_Role_OrgAccess)this.findPO(ctx, element);
        if (po == null) {
            int roleId = 0;
            if (this.getParentId(element, "AD_Role") > 0) {
                roleId = this.getParentId(element, "AD_Role");
            } else {
                Element roleElement = (Element)element.properties.get("AD_Role_ID");
                roleId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)roleElement, (String)this.getTrxName(ctx));
            }
            if (roleId <= 0) {
                element.defer = true;
                element.unresolved = "AD_Role_ID";
                return;
            }
            Element orgElement = (Element)element.properties.get("AD_Org_ID");
            int orgId = ReferenceUtils.resolveReference((Properties)ctx.ctx, (Element)orgElement, (String)this.getTrxName(ctx));
            Query query = new Query(ctx.ctx, "AD_Role_OrgAccess", "AD_Role_ID=? and AD_Org_ID=?", this.getTrxName(ctx));
            po = (X_AD_Role_OrgAccess)query.setParameters(new Object[]{roleId, orgId}).setClient_ID().first();
            if (po == null) {
                po = new X_AD_Role_OrgAccess(ctx.ctx, 0, this.getTrxName(ctx));
                po.setAD_Org_ID(orgId);
                po.setAD_Role_ID(roleId);
            }
            excludes.add("AD_Org_ID");
            excludes.add("AD_Role_ID");
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)po, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        po.saveEx();
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Org_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Org_ID");
        int AD_Role_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Role_ID");
        Query query = new Query(ctx.ctx, "AD_Role_OrgAccess", "AD_Role_ID=? and AD_Org_ID=?", this.getTrxName(ctx));
        X_AD_Role_OrgAccess po = (X_AD_Role_OrgAccess)query.setParameters(new Object[]{AD_Role_ID, AD_Org_ID}).first();
        if (po != null) {
            if (ctx.packOut.getFromDate() != null && po.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_Role_OrgAccess", atts);
            this.createOrgAccessBinding(ctx, document, po);
            document.endElement("", "", "AD_Role_OrgAccess");
        }
    }

    private void createOrgAccessBinding(PIPOContext ctx, TransformerHandler document, X_AD_Role_OrgAccess po) {
        PoExporter filler = new PoExporter(ctx, document, (PO)po);
        AttributesImpl orgRefAtts = new AttributesImpl();
        String orgReference = ReferenceUtils.getTableReference((String)"AD_Org", (String)"Name", (int)po.getAD_Org_ID(), (AttributesImpl)orgRefAtts);
        filler.addString("AD_Org_ID", orgReference, orgRefAtts);
        AttributesImpl roleRefAtts = new AttributesImpl();
        String roleReference = ReferenceUtils.getTableReference((String)"AD_Role", (String)"Name", (int)po.getAD_Role_ID(), (AttributesImpl)roleRefAtts);
        filler.addString("AD_Role_ID", roleReference, roleRefAtts);
        List excludes = this.defaultExcludeList("AD_Role_OrgAccess");
        excludes.add("AD_Org_ID");
        excludes.add("AD_Role_ID");
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        this.create(packout.getCtx(), packoutHandler);
    }
}

