/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.grid.IPaymentForm;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public abstract class PaymentForm
implements IPaymentForm {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private int m_WindowNo = 0;
    private GridTab m_mTab;
    public String m_DocStatus = null;
    public String m_PaymentRule = "";
    public Timestamp m_DateAcct = null;
    public int m_C_Currency_ID = 0;
    public int m_AD_Client_ID = 0;
    public boolean m_Cash_As_Payment = true;
    public int m_AD_Org_ID = 0;
    public int m_C_BPartner_ID = 0;
    public BigDecimal m_Amount = Env.ZERO;
    public boolean m_needSave = false;
    public boolean m_onlyRule = false;
    public boolean m_isSOTrx = true;
    public Hashtable<Integer, KeyNamePair> s_Currencies = null;

    public PaymentForm(int WindowNo, GridTab mTab) {
        this.m_WindowNo = WindowNo;
        this.m_isSOTrx = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsSOTrx"));
        this.m_mTab = mTab;
    }

    @Override
    public boolean dynInit() throws Exception {
        this.m_DocStatus = (String)this.m_mTab.getValue("DocStatus");
        this.log.config(this.m_DocStatus);
        if (this.m_mTab.getValue("C_BPartner_ID") == null) {
            throw new AdempiereException("SaveErrorRowNotFound");
        }
        if (this.m_DocStatus == null) {
            this.m_DocStatus = "";
        }
        if (this.m_DocStatus.equals("RE") || this.m_DocStatus.equals("VO") || this.m_DocStatus.equals("CL")) {
            return false;
        }
        this.m_onlyRule = !this.m_DocStatus.equals("CO") && !this.m_DocStatus.equals("WP");
        if (!this.m_onlyRule && !this.m_isSOTrx && this.m_mTab.getValue("M_Warehouse_ID") != null) {
            this.m_onlyRule = true;
        }
        this.m_Amount = (BigDecimal)this.m_mTab.getValue("GrandTotal");
        if (!this.m_onlyRule && this.m_Amount.compareTo(Env.ZERO) == 0) {
            throw new AdempiereException("PaymentZero");
        }
        this.m_AD_Client_ID = (Integer)this.m_mTab.getValue("AD_Client_ID");
        this.m_Cash_As_Payment = MSysConfig.getBooleanValue((String)"CASH_AS_PAYMENT", (boolean)true, (int)this.m_AD_Client_ID);
        this.m_AD_Org_ID = (Integer)this.m_mTab.getValue("AD_Org_ID");
        this.m_C_BPartner_ID = (Integer)this.m_mTab.getValue("C_BPartner_ID");
        this.m_PaymentRule = (String)this.m_mTab.getValue("PaymentRule");
        this.m_C_Currency_ID = (Integer)this.m_mTab.getValue("C_Currency_ID");
        this.m_DateAcct = (Timestamp)this.m_mTab.getValue("DateAcct");
        if (this.s_Currencies == null) {
            this.loadCurrencies();
        }
        if (this.m_PaymentRule == null) {
            this.m_PaymentRule = "";
        }
        this.loadData();
        return true;
    }

    @Override
    public boolean saveChanges() {
        final boolean[] success = new boolean[1];
        TrxRunnable r = new TrxRunnable(){

            public void run(String trxName) {
                success[0] = PaymentForm.this.m_onlyRule ? true : PaymentForm.this.saveChangesInTrx(trxName);
            }
        };
        try {
            Trx.run((TrxRunnable)r);
        }
        catch (AdempiereException ae) {
            success[0] = false;
            throw ae;
        }
        catch (Throwable e) {
            success[0] = false;
            throw new AdempiereException("PaymentError", e);
        }
        return success[0];
    }

    protected void loadCurrencies() {
        block6: {
            this.s_Currencies = new Hashtable(12);
            String SQL = "SELECT C_Currency_ID, ISO_Code FROM C_Currency WHERE (IsEMUMember='Y' AND EMUEntryDate<SysDate) OR IsEuro='Y' ORDER BY 2";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)SQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        String name = rs.getString(2);
                        this.s_Currencies.put(new Integer(id), new KeyNamePair(id, name));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, SQL, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    @Override
    public boolean needSave() {
        return this.m_needSave;
    }

    protected int getInvoiceID(int C_Order_ID) {
        int retValue;
        block6: {
            retValue = 0;
            String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=? AND DocStatus NOT IN ('VO','RE') ORDER BY C_Invoice_ID DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    @Override
    public void processOnline() {
        throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"ActionNotSupported"));
    }

    protected boolean isBankAccountProcessorExist(Properties ctx, String tender, String CCType, int AD_Client_ID, int C_Currency_ID, BigDecimal PayAmt, String trxName) {
        MBankAccountProcessor[] m_mBankAccountProcessors = MBankAccountProcessor.find((Properties)ctx, (String)tender, (String)CCType, (int)AD_Client_ID, (int)C_Currency_ID, (BigDecimal)PayAmt, (String)trxName);
        if (m_mBankAccountProcessors == null || m_mBankAccountProcessors.length == 0) {
            m_mBankAccountProcessors = MBankAccountProcessor.find((Properties)ctx, (String)tender, (String)CCType, (int)AD_Client_ID, (int)C_Currency_ID, (BigDecimal)Env.ZERO, (String)trxName);
        }
        return m_mBankAccountProcessors != null && m_mBankAccountProcessors.length != 0;
    }

    protected MBankAccountProcessor getBankAccountProcessor(Properties ctx, String tender, String CCType, int AD_Client_ID, int C_Currency_ID, BigDecimal PayAmt, String trxName) {
        MBankAccountProcessor[] m_mBankAccountProcessors = MBankAccountProcessor.find((Properties)ctx, (String)tender, (String)CCType, (int)AD_Client_ID, (int)C_Currency_ID, (BigDecimal)PayAmt, (String)trxName);
        if (m_mBankAccountProcessors == null || m_mBankAccountProcessors.length == 0) {
            m_mBankAccountProcessors = MBankAccountProcessor.find((Properties)ctx, (String)tender, (String)CCType, (int)AD_Client_ID, (int)C_Currency_ID, (BigDecimal)Env.ZERO, (String)trxName);
        }
        if (m_mBankAccountProcessors == null || m_mBankAccountProcessors.length == 0) {
            return null;
        }
        MBankAccountProcessor m_mBankAccountProcessor = null;
        int i = 0;
        while (i < m_mBankAccountProcessors.length) {
            MBankAccountProcessor bap = m_mBankAccountProcessors[i];
            if (bap.accepts(tender, CCType)) {
                m_mBankAccountProcessor = m_mBankAccountProcessors[i];
                break;
            }
            ++i;
        }
        return m_mBankAccountProcessor;
    }

    public GridTab getGridTab() {
        return this.m_mTab;
    }

    public boolean isOnlyRule() {
        return this.m_onlyRule;
    }

    @Override
    public boolean isApproved() {
        return true;
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    @Override
    public void setCustomizeValues(PO po) {
    }

    @Override
    public void setBankAccountProcessor(MBankAccountProcessor bankAccountProcessor) {
    }
}

