/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.IDFinder;
import org.apache.commons.codec.binary.Hex;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceUtils {
    public static int resolveReference(Properties ctx, Element e, String trxName) {
        String value = e.contents.toString();
        String referenceKey = e.attributes.getValue("reference-key");
        if (value != null && value.trim().length() > 0) {
            if (ReferenceUtils.isTableLookup(e)) {
                String[] names = referenceKey.split("[.]");
                if (names.length < 2) {
                    return 0;
                }
                String tableName = names[0];
                String searchColumn = names[1];
                return IDFinder.findIdByColumn(tableName, searchColumn, value.trim(), Env.getAD_Client_ID((Properties)ctx), trxName);
            }
            if (ReferenceUtils.isIDLookup(e)) {
                int id = Integer.parseInt(value);
                return id;
            }
            if (ReferenceUtils.isUUIDLookup(e)) {
                return IDFinder.findIdByColumn(referenceKey, PO.getUUIDColumnName((String)referenceKey), value.trim(), Env.getAD_Client_ID((Properties)ctx), trxName);
            }
            throw new IllegalArgumentException("Unknown table reference type=" + e.attributes.getValue("reference"));
        }
        return 0;
    }

    public static boolean isLookup(Element element) {
        return ReferenceUtils.isIDLookup(element) || ReferenceUtils.isUUIDLookup(element) || ReferenceUtils.isTableLookup(element);
    }

    public static boolean isIDLookup(Element element) {
        return "id".equals(element.attributes.getValue("reference"));
    }

    public static boolean isUUIDLookup(Element element) {
        return "uuid".equals(element.attributes.getValue("reference"));
    }

    public static boolean isTableLookup(Element element) {
        return "table".equals(element.attributes.getValue("reference"));
    }

    public static String getTableReference(String tableName, String searchColumn, int id, AttributesImpl atts) {
        String sql;
        String value;
        String keyColumn = String.valueOf(tableName) + "_ID";
        if (id > 0 && id <= 999999) {
            atts.addAttribute("", "", "reference", "CDATA", "id");
            String value2 = Integer.toString(id);
            return value2;
        }
        if (id == 0) {
            atts.addAttribute("", "", "reference", "CDATA", "id");
            return "";
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
        if (table == null) {
            throw new RuntimeException("Table Not Found. TableName=" + tableName);
        }
        String uuidColumnName = PO.getUUIDColumnName((String)tableName);
        if (table.getColumn(uuidColumnName) != null && (value = DB.getSQLValueString(null, (String)(sql = "SELECT " + uuidColumnName + " FROM " + tableName + " WHERE " + keyColumn + " = ?"), (int)id)) != null && value.trim().length() > 0) {
            atts.addAttribute("", "", "reference", "CDATA", "uuid");
            atts.addAttribute("", "", "reference-key", "CDATA", tableName);
            return value.trim();
        }
        if (searchColumn.indexOf(",") > 0) {
            String value3 = "";
            String[] columns = searchColumn.split("[,]");
            CPreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.prepareStatement((String)("SELECT " + searchColumn + " FROM " + tableName), null);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        int i = 0;
                        while (i < columns.length) {
                            String s;
                            Object o = rs.getObject(i + 1);
                            String string = s = o != null ? o.toString() : "";
                            if (s.length() > 0) {
                                char[] chars = Hex.encodeHex((byte[])s.getBytes("UTF-8"));
                                s = new String(chars);
                            }
                            value3 = i == 0 ? s : String.valueOf(value3) + "," + s;
                            ++i;
                        }
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Exception)e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            StringBuilder buffer = new StringBuilder();
            buffer.append(tableName).append(".").append(searchColumn);
            atts.addAttribute("", "", "reference", "CDATA", "table");
            atts.addAttribute("", "", "reference-key", "CDATA", buffer.toString());
            return value3;
        }
        sql = "SELECT " + searchColumn + " FROM " + tableName + " WHERE " + keyColumn + " = ?";
        value = DB.getSQLValueString(null, (String)sql, (int)id);
        StringBuilder buffer = new StringBuilder();
        buffer.append(tableName).append(".").append(searchColumn);
        atts.addAttribute("", "", "reference", "CDATA", "table");
        atts.addAttribute("", "", "reference-key", "CDATA", buffer.toString());
        return value;
    }
}

