/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MBPartnerProduct;
import org.compiere.model.MProductDownload;
import org.compiere.model.MProductPrice;
import org.compiere.model.Query;
import org.compiere.model.X_M_RelatedProduct;
import org.compiere.model.X_M_Replenish;
import org.compiere.model.X_M_Substitute;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class CopyProduct
extends SvrProcess {
    private int m_copyFromId;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_CopyFrom_ID")) {
                    this.m_copyFromId = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_ID")) {
                    this.m_copyFromId = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int toMProductID = this.getRecord_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From M_Product_ID=" + this.m_copyFromId + " to " + toMProductID);
        }
        if (toMProductID == 0) {
            throw new IllegalArgumentException("Target M_Product_ID == 0");
        }
        if (this.m_copyFromId == 0) {
            throw new IllegalArgumentException("Source M_Product_ID == 0");
        }
        List prices = new Query(this.getCtx(), "M_ProductPrice", "M_Product_ID=?", this.get_TrxName()).setParameters(new Object[]{this.m_copyFromId}).setOnlyActiveRecords(true).list();
        for (MProductPrice priceSrc : prices) {
            MProductPrice priceDst = new MProductPrice(this.getCtx(), 0, this.get_TrxName());
            priceDst.setM_Product_ID(toMProductID);
            priceDst.setM_PriceList_Version_ID(priceSrc.getM_PriceList_Version_ID());
            priceDst.setPrices(priceSrc.getPriceList(), priceSrc.getPriceStd(), priceSrc.getPriceLimit());
            priceDst.saveEx(this.get_TrxName());
        }
        int count = prices.size();
        List subs = new Query(this.getCtx(), "M_Substitute", "M_Product_ID=? and NOT substitute_ID=?", this.get_TrxName()).setParameters(new Object[]{this.m_copyFromId, toMProductID}).setOnlyActiveRecords(true).list();
        for (X_M_Substitute subSrc : subs) {
            X_M_Substitute subDst = new X_M_Substitute(this.getCtx(), 0, this.get_TrxName());
            subDst.setM_Product_ID(toMProductID);
            subDst.setSubstitute_ID(subSrc.getSubstitute_ID());
            subDst.setName(subSrc.getName());
            subDst.setDescription(subSrc.getDescription());
            subDst.saveEx(this.get_TrxName());
        }
        count += subs.size();
        List related = new Query(this.getCtx(), "M_RelatedProduct", "M_Product_ID=? and NOT relatedProduct_ID=?", this.get_TrxName()).setParameters(new Object[]{this.m_copyFromId, toMProductID}).setOnlyActiveRecords(true).list();
        for (X_M_RelatedProduct relatedSrc : related) {
            X_M_RelatedProduct relatedDst = new X_M_RelatedProduct(this.getCtx(), 0, this.get_TrxName());
            relatedDst.setM_Product_ID(toMProductID);
            relatedDst.setRelatedProduct_ID(relatedSrc.getRelatedProduct_ID());
            relatedDst.setRelatedProductType(relatedSrc.getRelatedProductType());
            relatedDst.setName(relatedSrc.getName());
            relatedDst.setDescription(relatedSrc.getDescription());
            relatedDst.saveEx(this.get_TrxName());
        }
        count += related.size();
        List replenish = new Query(this.getCtx(), "M_Replenish", "M_Product_ID=?", this.get_TrxName()).setParameters(new Object[]{this.m_copyFromId}).setOnlyActiveRecords(true).list();
        for (X_M_Replenish replenishSrc : replenish) {
            X_M_Replenish replenishDst = new X_M_Replenish(this.getCtx(), 0, this.get_TrxName());
            replenishDst.setM_Product_ID(toMProductID);
            replenishDst.setM_Warehouse_ID(replenishSrc.getM_Warehouse_ID());
            replenishDst.setM_WarehouseSource_ID(replenishSrc.getM_WarehouseSource_ID());
            replenishDst.setReplenishType(replenishSrc.getReplenishType());
            replenishDst.setM_Locator_ID(replenishSrc.getM_Locator_ID());
            replenishDst.setLevel_Min(replenishSrc.getLevel_Min());
            replenishDst.setLevel_Max(replenishSrc.getLevel_Max());
            replenishDst.saveEx(this.get_TrxName());
        }
        count += replenish.size();
        List bpList = new Query(this.getCtx(), "C_BPartner_Product", "M_Product_ID=?", this.get_TrxName()).setParameters(new Object[]{this.m_copyFromId}).setOnlyActiveRecords(true).list();
        for (MBPartnerProduct bpSrc : bpList) {
            MBPartnerProduct bpDst = new MBPartnerProduct(this.getCtx(), 0, this.get_TrxName());
            bpDst.setC_BPartner_ID(bpSrc.getC_BPartner_ID());
            bpDst.setDescription(bpSrc.getDescription());
            bpDst.setIsManufacturer(bpSrc.isManufacturer());
            bpDst.setM_Product_ID(toMProductID);
            bpDst.setManufacturer(bpSrc.getManufacturer());
            bpDst.setQualityRating(bpSrc.getQualityRating());
            bpDst.setShelfLifeMinDays(bpSrc.getShelfLifeMinDays());
            bpDst.setShelfLifeMinPct(bpSrc.getShelfLifeMinPct());
            bpDst.setVendorCategory(bpSrc.getVendorCategory());
            bpDst.setVendorProductNo(bpSrc.getVendorProductNo());
            bpDst.saveEx(this.get_TrxName());
        }
        count += bpList.size();
        List dlList = new Query(this.getCtx(), "M_ProductDownload", "M_Product_ID=?", this.get_TrxName()).setParameters(new Object[]{this.m_copyFromId}).setOnlyActiveRecords(true).list();
        for (MProductDownload dlSrc : dlList) {
            MProductDownload dlDst = new MProductDownload(this.getCtx(), 0, this.get_TrxName());
            dlDst.setM_Product_ID(toMProductID);
            dlDst.setName(dlSrc.getName());
            dlDst.setDownloadURL(dlSrc.getDownloadURL());
            dlDst.saveEx(this.get_TrxName());
        }
        return "@Copied@=" + (count += dlList.size());
    }
}

