/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.RowSet;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.adempiere.util.IProcessUI;
import org.compiere.apps.ADialog;
import org.compiere.apps.ClientProcessCtrl;
import org.compiere.apps.ProcessCtl;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class AReport
implements ActionListener {
    private MQuery m_query;
    private JPopupMenu m_popup = new JPopupMenu("ReportMenu");
    private ArrayList<KeyNamePair> m_list = new ArrayList();
    private static CLogger log = CLogger.getCLogger(AReport.class);
    IProcessUI parent;
    String m_whereExtended;
    int WindowNo;

    public AReport(int AD_Table_ID, JComponent invoker, MQuery query) {
        this(AD_Table_ID, invoker, query, null, 0);
    }

    public AReport(int AD_Table_ID, JComponent invoker, MQuery query, IProcessUI parent, int WindowNo) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("AD_Table_ID=" + AD_Table_ID + " " + query);
        }
        if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
            ADialog.error(0, invoker, "AccessCannotReport", query.getTableName());
            return;
        }
        this.m_query = query;
        this.parent = parent;
        this.WindowNo = WindowNo;
        this.getPrintFormats(AD_Table_ID, invoker);
    }

    public AReport(int AD_Table_ID, JComponent invoker, MQuery query, IProcessUI parent, int WindowNo, String whereExtended) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("AD_Table_ID=" + AD_Table_ID + " " + query);
        }
        if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
            ADialog.error(0, invoker, "AccessCannotReport", query.getTableName());
            return;
        }
        this.m_query = query;
        if (whereExtended != null && whereExtended.length() > 0 && this.m_query != null) {
            this.m_query.addRestriction(Env.parseContext((Properties)Env.getCtx(), (int)WindowNo, (String)whereExtended, (boolean)false));
        }
        this.parent = parent;
        this.WindowNo = WindowNo;
        this.m_whereExtended = whereExtended;
        this.getPrintFormats(AD_Table_ID, invoker);
    }

    private void getPrintFormats(int AD_Table_ID, JComponent invoker) {
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        RowSet rowSet = MPrintFormat.getAccessiblePrintFormats((int)AD_Table_ID, (int)-1, null);
        KeyNamePair pp = null;
        try {
            while (rowSet.next()) {
                pp = new KeyNamePair(rowSet.getInt(1), rowSet.getString(2));
                if (rowSet.getInt(3) != AD_Client_ID) continue;
                this.m_list.add(pp);
                this.m_popup.add(pp.toString()).addActionListener(this);
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
        }
        if (this.m_list.size() == 0) {
            if (pp == null) {
                this.createNewFormat(AD_Table_ID);
            } else {
                this.copyFormat(pp.getKey(), AD_Client_ID);
            }
        } else if (this.m_list.size() == 1 || invoker == null) {
            this.launchReport(this.m_list.get(0));
        } else if (invoker.isShowing()) {
            this.m_popup.show(invoker, 0, invoker.getHeight());
        }
    }

    private void createNewFormat(int AD_Table_ID) {
        MPrintFormat pf = MPrintFormat.createFromTable((Properties)Env.getCtx(), (int)AD_Table_ID);
        this.launchReport(pf);
    }

    private void copyFormat(int AD_PrintFormat_ID, int To_Client_ID) {
        MPrintFormat pf = MPrintFormat.copyToClient((Properties)Env.getCtx(), (int)AD_PrintFormat_ID, (int)To_Client_ID);
        this.launchReport(pf);
    }

    private void launchReport(KeyNamePair pp) {
        MPrintFormat pf = MPrintFormat.get((Properties)Env.getCtx(), (int)pp.getKey(), (boolean)false);
        this.launchReport(pf);
    }

    private void launchReport(MPrintFormat pf) {
        int Record_ID = 0;
        if (this.m_query.getRestrictionCount() == 1 && this.m_query.getCode(0) instanceof Integer) {
            Record_ID = (Integer)this.m_query.getCode(0);
        }
        PrintInfo info = new PrintInfo(pf.getName(), pf.getAD_Table_ID(), Record_ID);
        info.setDescription(this.m_query.getInfo());
        if (pf != null && pf.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", pf.getJasperProcess_ID(), pf.getAD_Table_ID(), Record_ID);
            ProcessCtl worker = ClientProcessCtrl.process(this.parent, this.WindowNo, pi, null);
        } else {
            ReportEngine re = new ReportEngine(Env.getCtx(), pf, this.m_query, info);
            re.setWhereExtended(this.m_whereExtended);
            re.setWindowNo(this.WindowNo);
            ReportCtl.preview((ReportEngine)re);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.m_popup.setCursor(Cursor.getPredefinedCursor(3));
        String cmd = e.getActionCommand();
        int i = 0;
        while (i < this.m_list.size()) {
            KeyNamePair pp = this.m_list.get(i);
            if (cmd.equals(pp.getName())) {
                this.launchReport(pp);
                return;
            }
            ++i;
        }
    }

    public static int getAD_Table_ID(String tableName) {
        return MTable.getTable_ID((String)tableName);
    }
}

