/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.tree;

import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.compiere.grid.tree.AdempiereTreeModel;
import org.compiere.grid.tree.TransferableTreeNode;
import org.compiere.model.MTreeNode;

public class VTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 2799737958477528717L;

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        MTreeNode node = (MTreeNode)tree.getSelectionPath().getLastPathComponent();
        return new TransferableTreeNode(node);
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int action) {
        if (action == 2) {
            JTree tree = (JTree)c;
            MTreeNode node = null;
            try {
                node = (MTreeNode)t.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node != null) {
                ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)node);
            }
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        return info.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        int index;
        if (!this.canImport(info)) {
            return false;
        }
        JTree tree = (JTree)info.getComponent();
        AdempiereTreeModel model = (AdempiereTreeModel)tree.getModel();
        Transferable t = info.getTransferable();
        MTreeNode to = null;
        MTreeNode from = null;
        try {
            from = (MTreeNode)t.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
        }
        catch (Exception e) {
            return false;
        }
        if (info.isDrop()) {
            JTree.DropLocation dl = (JTree.DropLocation)info.getDropLocation();
            to = (MTreeNode)dl.getPath().getLastPathComponent();
            if (from == to) {
                return false;
            }
            index = dl.getChildIndex();
            if (index == -1) {
                index = 0;
            }
        } else {
            MTreeNode selected = (MTreeNode)tree.getSelectionPath().getLastPathComponent();
            if (selected.isLeaf()) {
                to = (MTreeNode)selected.getParent();
                index = to.getIndex((TreeNode)selected) + 1;
            } else {
                to = selected;
                index = 0;
            }
        }
        model.insertNodeInto((MutableTreeNode)from, (MutableTreeNode)to, index);
        tree.scrollPathToVisible(new TreePath(from.getPath()));
        model.saveChangedNodes(from, to);
        return true;
    }
}

