/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.compiere.grid.IPaymentForm;
import org.compiere.grid.VPaymentFormDialog;
import org.compiere.grid.VPaymentFormFactory;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPaymentLookup;
import org.compiere.swing.CButton;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.NamePair;

public class VPaymentEditor
extends JComponent
implements VEditor,
ActionListener,
FocusListener {
    private static final long serialVersionUID = -1840246214698245287L;
    private static CLogger log = CLogger.getCLogger(VPaymentEditor.class);
    private CButton m_button = new CButton();
    private VComboBox m_combo = new VComboBox();
    private String m_columnName;
    private MPaymentLookup m_lookup;
    private Object m_value;
    private volatile boolean m_settingValue = false;
    private volatile boolean m_settingFocus = false;
    private volatile boolean m_haveFocus = false;
    private volatile boolean m_inserting = false;
    private String m_lastDisplay = "";
    private boolean m_stopediting = false;
    private GridField m_mField;

    public VPaymentEditor(GridField gridField, String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, MPaymentLookup lookup) {
        this.m_mField = gridField;
        super.setName(columnName);
        this.m_combo.setName(columnName);
        this.m_columnName = columnName;
        this.setMandatory(mandatory);
        this.m_lookup = lookup;
        if (this.m_lookup != null) {
            this.m_lookup.setMandatory(mandatory);
        }
        this.setLayout(new BorderLayout());
        this.m_button.addActionListener(this);
        this.m_button.setFocusable(false);
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setIcon(Env.getImageIcon((String)"Payment10.gif"));
        if (this.m_lookup != null) {
            if (!isReadOnly && isUpdateable) {
                this.m_lookup.fillComboBox(this.isMandatory(), true, true, false, false);
            }
            this.m_combo.setModel((ComboBoxModel)this.m_lookup);
            this.m_combo.addActionListener(this);
            this.m_combo.addFocusListener(this);
        }
        this.setUI(true);
        if (isReadOnly || !isUpdateable || this.m_lookup == null) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
    }

    @Override
    public void dispose() {
        this.m_button = null;
        this.m_lookup = null;
        this.m_mField = null;
        this.m_combo.getEditor().getEditorComponent().removeFocusListener(this);
        this.m_combo.removeFocusListener(this);
        this.m_combo.removeActionListener(this);
        this.m_combo.setModel((ComboBoxModel)new DefaultComboBoxModel());
        this.m_combo = null;
    }

    private void setUI(boolean initial) {
        if (initial) {
            Dimension size = this.m_combo.getPreferredSize();
            this.setPreferredSize(new Dimension(size));
            this.setMinimumSize(new Dimension(30, size.height));
            Dimension bSize = new Dimension(size.height, size.height);
            this.m_button.setPreferredSize(bSize);
        }
        this.remove(this.m_combo);
        this.remove(this.m_button);
        this.setBorder(null);
        this.add((Component)this.m_combo, "Center");
        this.add((Component)this.m_button, "East");
    }

    @Override
    public void setReadWrite(boolean value) {
        this.setReadWrite0(value);
        GridTab m_mTab = this.m_mField.getGridTab();
        String m_DocStatus = (String)m_mTab.getValue("DocStatus");
        if (m_DocStatus == null) {
            m_DocStatus = "";
        }
        if (m_DocStatus.equals("RE") || m_DocStatus.equals("VO") || m_DocStatus.equals("CL")) {
            this.m_button.setVisible(false);
            return;
        }
        boolean m_onlyRule = false;
        m_onlyRule = !m_DocStatus.equals("CO") && !m_DocStatus.equals("WP");
        boolean m_isSOTrx = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)this.m_mField.getWindowNo(), (String)"IsSOTrx"));
        if (!m_onlyRule && !m_isSOTrx && m_mTab.getValue("M_Warehouse_ID") != null) {
            m_onlyRule = true;
        }
        this.m_button.setVisible(value && !m_onlyRule);
    }

    private void setReadWrite0(boolean value) {
        boolean rw = value;
        if (this.m_lookup == null) {
            rw = false;
        }
        if (this.m_combo.isReadWrite() != value) {
            this.m_combo.setReadWrite(rw);
            this.setUI(false);
            if (value) {
                this.m_settingValue = true;
                this.refresh();
                this.m_settingValue = false;
            }
            this.setValue(this.m_value);
        }
    }

    @Override
    public boolean isReadWrite() {
        return this.m_combo.isReadWrite();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_combo.setMandatory(mandatory);
    }

    @Override
    public boolean isMandatory() {
        return this.m_combo.isMandatory();
    }

    @Override
    public void setBackground(boolean error) {
        this.m_combo.setBackground(error);
    }

    @Override
    public void requestFocus() {
        if (this.m_lookup != null) {
            this.m_combo.requestFocus();
        }
    }

    @Override
    public void setValue(Object value) {
        boolean notFound;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(this.m_columnName) + "=" + value);
        }
        this.m_settingValue = true;
        this.m_value = value;
        if (value == null) {
            this.m_combo.setValue(value);
            this.m_lastDisplay = "";
            this.m_settingValue = false;
            return;
        }
        if (this.m_lookup == null) {
            this.m_combo.setValue(value);
            this.m_lastDisplay = value.toString();
            this.m_settingValue = false;
            return;
        }
        this.m_lastDisplay = this.m_lookup.getDisplay(value);
        this.m_combo.setValue(value);
        if (this.m_lastDisplay.equals("<-1>")) {
            this.m_lastDisplay = "";
            this.m_value = null;
        }
        boolean bl = notFound = this.m_lastDisplay.startsWith("<") && this.m_lastDisplay.endsWith(">");
        if (this.m_combo.getSelectedItem() == null) {
            NamePair pp;
            if (notFound) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(String.valueOf(this.m_columnName) + "=" + value + ": Not found - " + this.m_lastDisplay);
                }
                this.m_lookup.refresh();
                this.m_combo.setValue(value);
                this.m_lastDisplay = this.m_lookup.getDisplay(value);
                boolean bl2 = notFound = this.m_lastDisplay.startsWith("<") && this.m_lastDisplay.endsWith(">");
            }
            if (notFound && value instanceof Integer && this.m_lookup.getDisplayType() != 13) {
                this.m_value = null;
                this.actionCombo(null);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.m_columnName) + "=" + value + ": Not found");
                }
            } else if (this.m_combo.getSelectedItem() == null && (pp = this.m_lookup.get(value)) != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.m_columnName) + " added to combo - " + pp);
                }
                this.m_combo.addItem(pp);
                this.m_combo.setValue(value);
            }
            if (this.m_combo.getSelectedItem() == null && value instanceof Integer && this.m_lookup.getDisplayType() != 13) {
                if (log.isLoggable(Level.INFO)) {
                    log.info(String.valueOf(this.m_columnName) + "=" + value + ": not in Lookup - set to NULL");
                }
                this.actionCombo(null);
                this.m_value = null;
            }
        }
        this.m_settingValue = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.m_stopediting) {
            return;
        }
        if (evt.getPropertyName().equals("FieldValue")) {
            this.m_inserting = "FieldValueInserting".equals(evt.getOldValue());
            this.setValue(evt.getNewValue());
            this.m_inserting = false;
        }
    }

    @Override
    public Object getValue() {
        return this.m_combo.getValue();
    }

    @Override
    public String getDisplay() {
        return this.m_combo.getDisplay();
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_settingValue || this.m_settingFocus || this.m_stopediting) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " - " + e.getActionCommand() + ", ComboValue=" + this.m_combo.getSelectedItem());
        }
        if (e.getSource() == this.m_combo) {
            String s;
            Object value = this.getValue();
            Object o = this.m_combo.getSelectedItem();
            if (o != null && (s = o.toString()).startsWith("~") && s.endsWith("~")) {
                if (log.isLoggable(Level.INFO)) {
                    log.info(String.valueOf(this.m_columnName) + " - selection inactive set to NULL");
                }
                value = null;
            }
            this.actionCombo(value);
        } else if (e.getSource() == this.m_button) {
            this.actionButton();
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.m_combo.addActionListener(listener);
    }

    private void actionCombo(Object value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Value=" + value);
        }
        try {
            this.fireVetoableChange(this.m_columnName, null, value);
        }
        catch (PropertyVetoException pve) {
            log.log(Level.SEVERE, this.m_columnName, (Throwable)pve);
        }
        boolean updated = false;
        Object updatedValue = value;
        if (updatedValue instanceof Object[] && ((Object[])updatedValue).length > 0) {
            updatedValue = ((Object[])updatedValue)[0];
        }
        if (updatedValue == null && this.m_value == null) {
            updated = true;
        } else if (updatedValue != null && value.equals(this.m_value)) {
            updated = true;
        }
        if (!updated) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.valueOf(this.m_columnName) + " - Value explicitly set - new=" + updatedValue + ", old=" + this.m_value);
            }
            this.setValue(updatedValue);
        }
    }

    private void actionButton() {
        IPaymentForm pf;
        this.m_button.setEnabled(false);
        if (this.m_lookup == null) {
            return;
        }
        this.m_combo.requestFocus();
        int windowNo = this.m_lookup.getWindowNo();
        Object newValue = this.getValue();
        if (newValue != null && (pf = VPaymentFormFactory.create(windowNo, this.getField().getGridTab(), (String)newValue)) != null) {
            VPaymentFormDialog dialog = (VPaymentFormDialog)pf.getWindow();
            if (dialog.isInitOK()) {
                dialog.setLocationRelativeTo(null);
                pf.showWindow();
                pf.closeWindow();
                this.getField().getGridTab().dataRefresh();
            } else {
                pf.closeWindow();
            }
        }
        this.m_button.setEnabled(true);
        this.m_combo.requestFocus();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.m_combo == null || this.m_combo.getEditor() == null) {
            return;
        }
        if (e.getSource() != this.m_combo && e.getSource() != this.m_combo.getEditor().getEditorComponent() || e.isTemporary() || this.m_haveFocus || this.m_lookup == null) {
            return;
        }
        if (this.m_lookup.isValidated() && this.m_lookup.isLoaded()) {
            this.m_haveFocus = true;
            return;
        }
        this.m_haveFocus = true;
        this.m_settingFocus = true;
        Object obj = this.m_lookup.getSelectedItem();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " - Start    Count=" + this.m_combo.getItemCount() + ", Selected=" + obj);
        }
        boolean popupVisible = this.m_combo.isPopupVisible();
        this.m_lookup.fillComboBox(this.isMandatory(), true, true, false, false);
        if (popupVisible) {
            this.m_combo.hidePopup();
            this.m_combo.showPopup();
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " - Update   Count=" + this.m_combo.getItemCount() + ", Selected=" + this.m_lookup.getSelectedItem());
        }
        this.m_lookup.setSelectedItem(obj);
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " - Selected Count=" + this.m_combo.getItemCount() + ", Selected=" + this.m_lookup.getSelectedItem());
        }
        this.m_settingFocus = false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object obj;
        if (e.isTemporary() || this.m_lookup == null || !this.m_button.isEnabled()) {
            return;
        }
        if (e.getSource() != this.m_combo && e.getSource() != this.m_combo.getEditor().getEditorComponent()) {
            return;
        }
        if (this.m_lookup.isValidated() && !this.m_lookup.hasInactive()) {
            this.m_haveFocus = false;
            return;
        }
        this.m_settingFocus = true;
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " = " + this.m_combo.getSelectedItem());
        }
        if ((obj = this.m_combo.getSelectedItem()) != null) {
            this.m_combo.setSelectedItem(obj);
            if (!this.m_combo.getSelectedItem().equals(obj)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.m_columnName) + " - added to combo - " + obj);
                }
                this.m_combo.addItem(obj);
                this.m_combo.setSelectedItem(obj);
            }
        }
        this.m_settingFocus = false;
        this.m_haveFocus = false;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.m_button.setToolTipText(text);
        this.m_combo.setToolTipText(text);
    }

    public int refresh() {
        if (this.m_lookup == null) {
            return -1;
        }
        if (!this.isReadWrite()) {
            this.m_lookup.removeAllElements();
            return 0;
        }
        return this.m_lookup.refresh();
    }

    public void setStopEditing(boolean stopediting) {
        this.m_stopediting = stopediting;
    }
}

