/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.adempiere.client.InfoManager;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.apps.search.Info;
import org.compiere.grid.ed.VBPartner;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VLocationDialog;
import org.compiere.grid.ed.ValuePreference;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.swing.CButton;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

public class VLookup
extends JComponent
implements VEditor,
ActionListener,
FocusListener {
    private static final long serialVersionUID = -8609913311212365705L;
    public static final int DISPLAY_LENGTH = 15;
    public static int FIELD_HIGHT = 0;
    private CTextField m_text = new CTextField(15);
    private CButton m_button = new CButton();
    private VComboBox m_combo = new VComboBox();
    private volatile boolean m_settingValue = false;
    private volatile boolean m_settingFocus = false;
    private volatile boolean m_haveFocus = false;
    private volatile boolean m_inserting = false;
    private String m_lastDisplay = "";
    private String m_columnName;
    private Lookup m_lookup;
    private boolean m_comboActive = true;
    private Object m_value;
    private boolean m_stopediting = false;
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mZoom;
    private CMenuItem mRefresh;
    private CMenuItem mBPartnerNew;
    private CMenuItem mBPartnerUpd;
    private CMenuItem m_location;
    private VLookup_mouseAdapter mouseAdapter;
    private CButton m_buttonSL = new CButton();
    boolean onlyShortListItems = false;
    private GridField m_mField = null;
    private static CLogger log = CLogger.getCLogger(VLookup.class);
    private String m_tableName = null;
    private String m_keyColumnName = null;

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getSource() == this.m_combo || e.getSource() == this.m_text || e.getSource() == this) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        JComponent editorComp = null;
        editorComp = this.m_lookup != null && this.m_lookup.getDisplayType() != 30 ? this.m_combo : this.m_text;
        InputMap map = editorComp.getInputMap(condition);
        ActionMap am = editorComp.getActionMap();
        if (map != null && am != null && this.isEnabled()) {
            Action action;
            Object binding = map.get(ks);
            Action action2 = action = binding == null ? null : am.get(binding);
            if (action != null) {
                return SwingUtilities.notifyAction(action, ks, e, editorComp, e.getModifiers());
            }
        }
        return false;
    }

    public static VLookup createBPartner(int WindowNo) {
        int AD_Column_ID = 3499;
        try {
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)WindowNo, (int)0, (int)AD_Column_ID, (int)30);
            return new VLookup("C_BPartner_ID", false, false, true, (Lookup)lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }

    public static VLookup createProduct(int WindowNo) {
        int AD_Column_ID = 3840;
        try {
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)WindowNo, (int)0, (int)AD_Column_ID, (int)30);
            return new VLookup("M_Product_ID", false, false, true, (Lookup)lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }

    public static VLookup createUser(int WindowNo) {
        int AD_Column_ID = 10443;
        try {
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)WindowNo, (int)0, (int)AD_Column_ID, (int)30);
            return new VLookup("AD_User_ID", false, false, true, (Lookup)lookup);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            return null;
        }
    }

    public VLookup(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        super.setName(columnName);
        this.m_combo.setName(columnName);
        this.m_columnName = columnName;
        this.setMandatory(mandatory);
        this.m_lookup = lookup;
        if (this.m_lookup != null) {
            this.m_lookup.setMandatory(mandatory);
        }
        this.setLayout(new BorderLayout());
        this.mouseAdapter = new VLookup_mouseAdapter(this);
        this.m_text.addActionListener(this);
        this.m_text.addFocusListener(this);
        this.m_text.addMouseListener(this.mouseAdapter);
        this.m_button.addActionListener(this);
        this.m_button.addMouseListener(this.mouseAdapter);
        this.m_button.setFocusable(false);
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        if (columnName.equals("C_BPartner_ID")) {
            this.m_button.setIcon(Env.getImageIcon((String)"BPartner10.gif"));
        } else if (columnName.equals("M_Product_ID")) {
            this.m_button.setIcon(Env.getImageIcon((String)"Product10.gif"));
        } else {
            this.m_button.setIcon(Env.getImageIcon((String)"PickOpen10.gif"));
        }
        boolean isShortListAvailable = false;
        if (this.m_lookup != null && (this.m_lookup.getDisplayType() == 19 || this.m_lookup.getDisplayType() == 18)) {
            String tableName_temp = this.m_lookup.getColumnName();
            int posPoint = tableName_temp.indexOf(".");
            String tableName = tableName_temp.substring(0, posPoint);
            MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
            boolean bl = isShortListAvailable = table.getColumnIndex("IsShortList") >= 0;
            if (isShortListAvailable) {
                this.setComboShortList(true);
                this.m_lookup.setShortList(true);
                this.m_buttonSL.addActionListener(this);
                this.m_buttonSL.addMouseListener(this.mouseAdapter);
                this.m_buttonSL.setFocusable(false);
                this.m_buttonSL.setMargin(new Insets(0, 0, 0, 0));
                this.m_buttonSL.setIcon(Env.getImageIcon((String)"LockX16.gif"));
                this.m_buttonSL.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"ShortListShortListItems"));
                ActionMap am = this.m_combo.getActionMap();
                am.put("shortlist", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VLookup.this.actionShortList();
                    }
                });
                this.m_combo.getInputMap(1).put(KeyStroke.getKeyStroke(76, 128), "shortlist");
            }
        }
        if (this.m_lookup != null && this.m_lookup.getDisplayType() != 30) {
            if (!isReadOnly && isUpdateable) {
                this.m_lookup.fillComboBox(this.isMandatory(), true, true, false, isShortListAvailable);
            }
            this.m_combo.setModel((ComboBoxModel)this.m_lookup);
            this.m_combo.addActionListener(this);
            this.m_combo.getEditor().getEditorComponent().addMouseListener(this.mouseAdapter);
            this.m_combo.addFocusListener(this);
            this.m_combo.getEditor().getEditorComponent().addFocusListener(this);
        }
        this.setUI(true);
        if (isReadOnly || !isUpdateable || this.m_lookup == null) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        if (this.m_lookup != null) {
            if (this.m_lookup.getDisplayType() == 17 && Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Role_ID") == 0 || this.m_lookup.getDisplayType() != 17) {
                this.mZoom = new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom"), Env.getImageIcon((String)"Zoom16.gif"));
                this.mZoom.addActionListener(this);
                this.popupMenu.add(this.mZoom);
            }
            this.mRefresh = new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh"), Env.getImageIcon((String)"Refresh16.gif"));
            this.mRefresh.addActionListener(this);
            this.popupMenu.add(this.mRefresh);
        }
        if (columnName.equals("C_BPartner_ID")) {
            this.mBPartnerNew = new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"New"), Env.getImageIcon((String)"InfoBPartner16.gif"));
            this.mBPartnerNew.addActionListener(this);
            this.mBPartnerNew.setVisible(this.isReadWrite());
            this.popupMenu.add(this.mBPartnerNew);
            this.mBPartnerUpd = new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"Update"), Env.getImageIcon((String)"InfoBPartner16.gif"));
            this.mBPartnerUpd.addActionListener(this);
            this.popupMenu.add(this.mBPartnerUpd);
        }
        if (columnName.toUpperCase().equals("C_BPARTNER_LOCATION_ID") || columnName.toUpperCase().equals("BILL_LOCATION_ID") || columnName.toUpperCase().equals("DROPSHIP_LOCATION_ID")) {
            this.m_location = new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"ShowLocation"), Env.getImageIcon((String)"InfoBPartner16.gif"));
            this.m_location.addActionListener(this);
            this.popupMenu.add(this.m_location);
        }
        if (this.m_lookup != null && this.m_lookup.getZoom() == 0) {
            this.mZoom.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_lookup = null;
        this.m_mField = null;
        this.m_buttonSL = null;
        this.m_combo.getEditor().getEditorComponent().removeFocusListener(this);
        this.m_combo.getEditor().getEditorComponent().removeMouseListener(this.mouseAdapter);
        this.m_combo.removeFocusListener(this);
        this.m_combo.removeActionListener(this);
        this.m_combo.setModel((ComboBoxModel)new DefaultComboBoxModel());
        this.m_combo = null;
    }

    private void setUI(boolean initial) {
        if (initial) {
            Dimension size = this.m_text.getPreferredSize();
            this.setPreferredSize(new Dimension(size));
            this.m_combo.setPreferredSize(new Dimension(size));
            this.setMinimumSize(new Dimension(30, size.height));
            FIELD_HIGHT = size.height;
            this.m_text.setBorder(null);
            Dimension bSize = new Dimension(size.height, size.height);
            this.m_button.setPreferredSize(bSize);
            this.m_buttonSL.setPreferredSize(bSize);
        }
        this.remove(this.m_combo);
        this.remove(this.m_button);
        this.remove(this.m_buttonSL);
        this.remove(this.m_text);
        if (!this.isReadWrite()) {
            LookAndFeel.installBorder(this, "TextField.border");
            this.add((Component)this.m_text, "Center");
            this.m_text.setReadWrite(false);
            this.m_combo.setReadWrite(false);
            this.m_comboActive = false;
        } else if (this.m_lookup != null && this.m_lookup.getDisplayType() != 30) {
            this.setBorder(null);
            this.add((Component)this.m_combo, "Center");
            this.m_comboActive = true;
            if (this.isComboShortList()) {
                this.add((Component)this.m_buttonSL, "East");
            }
        } else {
            LookAndFeel.installBorder(this, "TextField.border");
            this.add((Component)this.m_text, "Center");
            this.add((Component)this.m_button, "East");
            this.m_text.setReadWrite(true);
            this.m_comboActive = false;
        }
    }

    @Override
    public void setReadWrite(boolean value) {
        boolean rw = value;
        if (this.m_lookup == null) {
            rw = false;
        }
        if (this.m_combo.isReadWrite() != value) {
            this.m_combo.setReadWrite(rw);
            this.setUI(false);
            if (value && this.m_comboActive) {
                this.m_settingValue = true;
                this.refresh();
                this.m_settingValue = false;
            }
            if (this.m_comboActive) {
                this.setValue(this.m_value);
            }
        }
        if (this.mBPartnerNew != null) {
            this.mBPartnerNew.setVisible(value);
        }
    }

    @Override
    public boolean isReadWrite() {
        return this.m_combo.isReadWrite();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_combo.setMandatory(mandatory);
        this.m_text.setMandatory(mandatory);
    }

    @Override
    public boolean isMandatory() {
        return this.m_combo.isMandatory();
    }

    @Override
    public void setBackground(Color color) {
        this.m_text.setBackground(color);
        this.m_combo.setBackground(color);
    }

    @Override
    public void setBackground(boolean error) {
        this.m_text.setBackground(error);
        this.m_combo.setBackground(error);
    }

    @Override
    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
        this.m_combo.setForeground(fg);
    }

    @Override
    public void requestFocus() {
        if (this.m_lookup != null && this.m_lookup.getDisplayType() != 30) {
            this.m_combo.requestFocus();
        } else {
            this.m_text.requestFocus();
        }
    }

    @Override
    public void setValue(Object value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(this.m_columnName) + "=" + value);
        }
        this.m_settingValue = true;
        this.m_value = value;
        if (value == null) {
            this.m_combo.setValue(value);
            this.m_text.setText(null);
            this.m_lastDisplay = "";
            this.m_settingValue = false;
            return;
        }
        if (this.m_lookup == null) {
            this.m_combo.setValue(value);
            this.m_text.setText(value.toString());
            this.m_lastDisplay = value.toString();
            this.m_settingValue = false;
            return;
        }
        this.m_lastDisplay = this.m_lookup.getDisplay(value);
        this.m_combo.setValue(value);
        if (this.m_lastDisplay.equals("<-1>")) {
            this.m_lastDisplay = "";
            this.m_value = null;
        }
        boolean notFound = this.m_lastDisplay.startsWith("<") && this.m_lastDisplay.endsWith(">");
        this.m_text.setText(this.m_lastDisplay);
        this.m_text.setCaretPosition(0);
        if (this.m_combo.getSelectedItem() == null && (this.m_comboActive || this.m_inserting && this.m_lookup.getDisplayType() != 30)) {
            NamePair pp;
            if (notFound) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(String.valueOf(this.m_columnName) + "=" + value + ": Not found - " + this.m_lastDisplay);
                }
                this.m_lookup.refresh();
                this.m_combo.setValue(value);
                this.m_lastDisplay = this.m_lookup.getDisplay(value);
                this.m_text.setText(this.m_lastDisplay);
                this.m_text.setCaretPosition(0);
                boolean bl = notFound = this.m_lastDisplay.startsWith("<") && this.m_lastDisplay.endsWith(">");
            }
            if (notFound && value instanceof Integer && this.m_lookup.getDisplayType() != 13) {
                this.m_value = null;
                this.actionCombo(null);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.m_columnName) + "=" + value + ": Not found");
                }
            } else if (this.m_combo.getSelectedItem() == null && (pp = this.m_lookup.get(value)) != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.m_columnName) + " added to combo - " + pp);
                }
                this.m_combo.addItem(pp);
                this.m_combo.setValue(value);
            }
            if (this.m_combo.getSelectedItem() == null && value instanceof Integer && this.m_lookup.getDisplayType() != 13) {
                if (log.isLoggable(Level.INFO)) {
                    log.info(String.valueOf(this.m_columnName) + "=" + value + ": not in Lookup - set to NULL");
                }
                this.actionCombo(null);
                this.m_value = null;
            }
        }
        this.m_settingValue = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.m_stopediting) {
            return;
        }
        if (evt.getPropertyName().equals("FieldValue")) {
            this.m_inserting = "FieldValueInserting".equals(evt.getOldValue());
            this.setValue(evt.getNewValue());
            this.m_inserting = false;
        }
    }

    @Override
    public Object getValue() {
        if (this.m_comboActive) {
            return this.m_combo.getValue();
        }
        return this.m_value;
    }

    @Override
    public String getDisplay() {
        String retValue = null;
        retValue = this.m_comboActive ? this.m_combo.getDisplay() : (this.m_lookup == null ? (this.m_value == null ? null : this.m_value.toString()) : this.m_lookup.getDisplay(this.m_value));
        return retValue;
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null && MRole.getDefault().isShowPreference() && !mField.isEncrypted() && !mField.isEncryptedColumn()) {
            ValuePreference.addMenu(this, this.popupMenu);
        }
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_settingValue || this.m_settingFocus || this.m_stopediting) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " - " + e.getActionCommand() + ", ComboValue=" + this.m_combo.getSelectedItem());
        }
        if (e.getActionCommand().equals("ValuePreference")) {
            if (MRole.getDefault().isShowPreference() && !this.m_mField.isEncrypted() && !this.m_mField.isEncryptedColumn()) {
                ValuePreference.start(this.m_mField, this.getValue(), this.getDisplay());
            }
            return;
        }
        if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start(this.m_mField);
            return;
        }
        if (e.getSource() == this.m_combo) {
            String s;
            Object value = this.getValue();
            Object o = this.m_combo.getSelectedItem();
            if (o != null && (s = o.toString()).startsWith("~") && s.endsWith("~")) {
                if (log.isLoggable(Level.INFO)) {
                    log.info(String.valueOf(this.m_columnName) + " - selection inactive set to NULL");
                }
                value = null;
            }
            this.actionCombo(value);
        } else if (e.getSource() == this.m_button) {
            this.actionButton("");
        } else if (e.getSource() == this.m_text) {
            this.actionText();
        } else if (e.getSource() == this.mZoom) {
            this.actionZoom(this.m_combo.getSelectedItem());
        } else if (e.getSource() == this.mRefresh) {
            this.actionRefresh();
        } else if (e.getSource() == this.mBPartnerNew) {
            this.actionBPartner(true);
        } else if (e.getSource() == this.mBPartnerUpd) {
            this.actionBPartner(false);
        } else if (e.getSource() == this.m_location) {
            this.actionLocation();
        } else if (e.getSource() == this.m_buttonSL) {
            this.actionShortList();
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.m_combo.addActionListener(listener);
        this.m_text.addActionListener(listener);
    }

    private void actionCombo(Object value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Value=" + value);
        }
        try {
            this.fireVetoableChange(this.m_columnName, null, value);
        }
        catch (PropertyVetoException pve) {
            log.log(Level.SEVERE, this.m_columnName, (Throwable)pve);
        }
        boolean updated = false;
        Object updatedValue = value;
        if (updatedValue instanceof Object[] && ((Object[])updatedValue).length > 0) {
            updatedValue = ((Object[])updatedValue)[0];
        }
        if (updatedValue == null && this.m_value == null) {
            updated = true;
        } else if (updatedValue != null && value.equals(this.m_value)) {
            updated = true;
        }
        if (!updated) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.valueOf(this.m_columnName) + " - Value explicitly set - new=" + updatedValue + ", old=" + this.m_value);
            }
            this.setValue(updatedValue);
        }
    }

    private void actionButton(String queryValue) {
        this.m_button.setEnabled(false);
        if (this.m_lookup == null) {
            return;
        }
        this.m_text.requestFocus();
        JFrame frame = AEnv.getFrame(this);
        Object[] result = null;
        boolean cancelled = false;
        boolean multipleSelection = false;
        String whereClause = this.getWhereClause();
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(this.m_lookup.getColumnName()) + ", Zoom=" + this.m_lookup.getZoom() + " (" + whereClause + ")");
        }
        Info info = null;
        this.resetTabInfo();
        if (this.m_tableName == null) {
            this.getDirectAccessSQL("*");
        }
        if (queryValue.length() == 0 && this.m_text.getText().length() > 0) {
            queryValue = this.m_text.getText();
        }
        info = InfoManager.create((Frame)frame, true, this.m_lookup, this.m_mField, this.m_tableName, this.m_keyColumnName, queryValue, multipleSelection, whereClause);
        info.setVisible(true);
        cancelled = info.isCancelled();
        result = info.getSelectedKeys();
        if (result != null && result.length > 0) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config(String.valueOf(this.m_columnName) + " - Result = " + result.toString() + " (" + result.getClass().getName() + ")");
            }
            this.m_lookup.getDirect(result[0], false, true);
            if (info.isResetValue()) {
                this.actionCombo(null);
            }
            if (result.length > 1) {
                this.actionCombo(result);
            } else {
                this.actionCombo(result[0]);
            }
        } else if (cancelled) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config(String.valueOf(this.m_columnName) + " - Result = null (cancelled)");
            }
            this.actionCombo(null);
        } else {
            if (log.isLoggable(Level.CONFIG)) {
                log.config(String.valueOf(this.m_columnName) + " - Result = null (not cancelled)");
            }
            this.setValue(this.m_value);
        }
        this.m_button.setEnabled(true);
        this.m_text.requestFocus();
    }

    private String getWhereClause() {
        String validation;
        String whereClause = "";
        if (this.m_lookup == null) {
            return "";
        }
        if (this.m_lookup.getZoomQuery() != null) {
            whereClause = this.m_lookup.getZoomQuery().getWhereClause();
        }
        if ((validation = this.m_lookup.getValidation()) == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = String.valueOf(whereClause) + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            String validated = Env.parseContext((Properties)Env.getCtx(), (int)this.m_lookup.getWindowNo(), (String)whereClause, (boolean)false);
            if (validated.length() == 0) {
                log.severe(String.valueOf(this.m_columnName) + " - Cannot Parse=" + whereClause);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.m_columnName) + " - Parsed: " + validated);
                }
                return validated;
            }
        }
        return whereClause;
    }

    private void actionText() {
        int id;
        String finalSQL;
        block26: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String text;
            block24: {
                text = this.m_text.getText();
                if (text != null && text.length() > 0 && text.equals(this.m_lastDisplay)) {
                    log.finest("Nothing entered [SKIP]");
                    return;
                }
                if (text == null || text.length() == 0 || text.equals("%")) {
                    this.actionButton(text);
                    return;
                }
                text = text.toUpperCase();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(String.valueOf(this.m_columnName) + " - " + text);
                }
                pstmt = null;
                rs = null;
                finalSQL = Msg.parseTranslation((Properties)Env.getCtx(), (String)this.getDirectAccessSQL(text));
                id = -3;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)finalSQL, null);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            id = rs.getInt(1);
                            if (rs.next()) {
                                id = -1;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, finalSQL, (Throwable)e);
                        id = -2;
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            if (id == -3 && !text.endsWith("%")) {
                text = String.valueOf(text) + "%";
                finalSQL = Msg.parseTranslation((Properties)Env.getCtx(), (String)this.getDirectAccessSQL(text));
                try {
                    try {
                        pstmt = DB.prepareStatement((String)finalSQL, null);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            id = rs.getInt(1);
                            if (rs.next()) {
                                id = -1;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, finalSQL, (Throwable)e);
                        id = -2;
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        if (id <= 0) {
            if (id == -3) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.m_columnName) + " - Not Found - " + finalSQL);
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.fine(String.valueOf(this.m_columnName) + " - Not Unique - " + finalSQL);
            }
            this.m_value = null;
            this.actionButton(this.m_text.getText());
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(this.m_columnName) + " - Unique ID=" + id);
        }
        this.m_value = null;
        this.resetTabInfo();
        this.actionCombo(new Integer(id));
        if (id <= 0) {
            this.m_text.requestFocus();
        }
    }

    private String getDirectAccessSQL(String text) {
        StringBuffer sql;
        block39: {
            int AD_Reference_ID;
            sql = new StringBuffer();
            this.m_tableName = MQuery.getZoomTableName((String)this.m_columnName);
            this.m_keyColumnName = MQuery.getZoomColumnName((String)this.m_columnName);
            if (this.m_columnName.equals("M_Product_ID")) {
                this.resetTabInfo();
                sql.append("SELECT M_Product_ID FROM M_Product WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING((String)text)).append(" OR SKU LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPC LIKE ").append(DB.TO_STRING((String)text)).append(")");
            } else if (this.m_columnName.equals("C_BPartner_ID")) {
                sql.append("SELECT C_BPartner_ID FROM C_BPartner WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING((String)text)).append(")");
            } else if (this.m_columnName.equals("C_Order_ID")) {
                sql.append("SELECT C_Order_ID FROM C_Order WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (this.m_columnName.equals("C_Invoice_ID")) {
                sql.append("SELECT C_Invoice_ID FROM C_Invoice WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (this.m_columnName.equals("M_InOut_ID")) {
                sql.append("SELECT M_InOut_ID FROM M_InOut WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (this.m_columnName.equals("C_Payment_ID")) {
                sql.append("SELECT C_Payment_ID FROM C_Payment WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (this.m_columnName.equals("GL_JournalBatch_ID")) {
                sql.append("SELECT GL_JournalBatch_ID FROM GL_JournalBatch WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
            } else if (this.m_columnName.equals("SalesRep_ID")) {
                sql.append("SELECT AD_User_ID FROM AD_User WHERE UPPER(Name) LIKE ").append(DB.TO_STRING((String)text));
                this.m_tableName = "AD_User";
                this.m_keyColumnName = "AD_User_ID";
            }
            if (sql.length() > 0) {
                String wc = this.getWhereClause();
                if (wc != null && wc.length() > 0) {
                    sql.append(" AND ").append(wc);
                }
                sql.append(" AND IsActive='Y'");
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(String.valueOf(this.m_columnName) + " (predefined) " + sql.toString());
                }
                return MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
            }
            if (this.m_lookup != null && this.m_lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)this.m_lookup).getAD_Reference_Value_ID()) != 0) {
                String displayColumnName;
                block37: {
                    String query = "SELECT kc.ColumnName, dc.ColumnName, t.TableName FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Column dc ON (rt.AD_Display=dc.AD_Column_ID) INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
                    displayColumnName = null;
                    CPreparedStatement pstmt = null;
                    ResultSet rs2 = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)query, null);
                            pstmt.setInt(1, AD_Reference_ID);
                            rs2 = pstmt.executeQuery();
                            if (rs2.next()) {
                                this.m_keyColumnName = rs2.getString(1);
                                displayColumnName = rs2.getString(2);
                                this.m_tableName = rs2.getString(3);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, query, (Throwable)e);
                            DB.close(rs2, (Statement)pstmt);
                            rs2 = null;
                            pstmt = null;
                            break block37;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs2, (Statement)pstmt);
                        rs2 = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs2, (Statement)pstmt);
                    rs2 = null;
                    pstmt = null;
                }
                if (displayColumnName != null) {
                    sql = new StringBuffer();
                    sql.append("SELECT ").append(this.m_keyColumnName).append(" FROM ").append(this.m_tableName).append(" WHERE UPPER(").append(displayColumnName).append(") LIKE ").append(DB.TO_STRING((String)text)).append(" AND IsActive='Y'");
                    String wc = this.getWhereClause();
                    if (wc != null && wc.length() > 0) {
                        sql.append(" AND ").append(wc);
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(String.valueOf(this.m_columnName) + " (Table) " + sql.toString());
                    }
                    return MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
                }
            }
            String query = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID AND t.IsView='N') WHERE (c.ColumnName IN ('DocumentNo', 'Value', 'Name') OR c.IsIdentifier='Y') AND c.AD_Reference_ID IN (10,14) AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.IsKey='Y' AND cc.ColumnName=?)";
            sql = new StringBuffer();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)query, null);
                    pstmt.setString(1, this.m_keyColumnName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (sql.length() != 0) {
                            sql.append(" OR ");
                        }
                        this.m_tableName = rs.getString(1);
                        sql.append("UPPER(").append(rs.getString(2)).append(") LIKE ").append(DB.TO_STRING((String)text));
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, query, (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block39;
                }
            }
            catch (Throwable rs2) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw rs2;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (sql.length() == 0) {
            log.log(Level.SEVERE, String.valueOf(this.m_columnName) + " (TableDir) - no standard/identifier columns");
            return "";
        }
        StringBuffer retValue = new StringBuffer("SELECT ").append(this.m_columnName).append(" FROM ").append(this.m_tableName).append(" WHERE (").append(sql).append(")").append(" AND IsActive='Y'");
        String wc = this.getWhereClause();
        if (wc != null && wc.length() > 0) {
            retValue.append(" AND ").append(wc);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.valueOf(this.m_columnName) + " (TableDir) " + sql.toString());
        }
        return MRole.getDefault().addAccessSQL(retValue.toString(), this.m_tableName, false, false);
    }

    private void actionBPartner(boolean newRecord) {
        VBPartner vbp = new VBPartner((Frame)AEnv.getFrame(this), this.m_lookup.getWindowNo());
        int BPartner_ID = 0;
        if (!newRecord) {
            if (this.m_value instanceof Integer) {
                BPartner_ID = (Integer)this.m_value;
            } else if (this.m_value != null) {
                BPartner_ID = Integer.parseInt(this.m_value.toString());
            }
        }
        vbp.loadBPartner(BPartner_ID);
        vbp.setVisible(true);
        int result = vbp.getC_BPartner_ID();
        if (result == 0 && result == BPartner_ID) {
            return;
        }
        this.m_lookup.getDirect((Object)new Integer(result), false, true);
        this.actionCombo(new Integer(result));
    }

    private void actionLocation() {
        int BPLocation_ID = 0;
        if (this.m_value instanceof Integer) {
            BPLocation_ID = (Integer)this.m_value;
        } else if (this.m_value != null) {
            BPLocation_ID = Integer.parseInt(this.m_value.toString());
        }
        if (BPLocation_ID > 0) {
            MBPartnerLocation bpl = new MBPartnerLocation(Env.getCtx(), BPLocation_ID, null);
            MLocation location = new MLocation(Env.getCtx(), bpl.getC_Location_ID(), null);
            VLocationDialog ld = new VLocationDialog((Frame)AEnv.getFrame(this), Msg.getMsg((Properties)Env.getCtx(), (String)"Location"), location);
            ld.setVisible(true);
        }
    }

    private void actionZoom(Object selectedItem) {
        if (this.m_lookup == null) {
            return;
        }
        MQuery zoomQuery = this.m_lookup.getZoomQuery();
        Object value = this.getValue();
        if (value == null) {
            value = selectedItem;
        }
        if (value == null) {
            value = -1;
        }
        if (zoomQuery == null || value != null) {
            String keyColumnName;
            String keyTableName;
            block23: {
                zoomQuery = new MQuery();
                keyTableName = null;
                keyColumnName = null;
                if (this.m_lookup != null && this.m_lookup instanceof MLookup) {
                    int AD_Reference_ID = ((MLookup)this.m_lookup).getAD_Reference_Value_ID();
                    if (17 == this.m_lookup.getDisplayType()) {
                        keyColumnName = "AD_Ref_List_ID";
                        keyTableName = "AD_Ref_List";
                        value = DB.getSQLValue(null, (String)"SELECT AD_Ref_List_ID FROM AD_Ref_List WHERE AD_Reference_ID=? AND Value=?", (Object[])new Object[]{AD_Reference_ID, value});
                    } else if (AD_Reference_ID != 0) {
                        String query = "SELECT kc.ColumnName, kt.TableName FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Table kt ON (rt.AD_Table_ID=kt.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
                        CPreparedStatement pstmt = null;
                        ResultSet rs = null;
                        try {
                            try {
                                pstmt = DB.prepareStatement((String)query, null);
                                pstmt.setInt(1, AD_Reference_ID);
                                rs = pstmt.executeQuery();
                                if (rs.next()) {
                                    keyColumnName = rs.getString(1);
                                    keyTableName = rs.getString(2);
                                }
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, query, (Throwable)e);
                                DB.close(rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                    }
                }
            }
            if (keyColumnName != null && keyColumnName.length() != 0) {
                zoomQuery.addRestriction(keyColumnName, "=", value);
                zoomQuery.setZoomColumnName(keyColumnName);
                zoomQuery.setZoomTableName(keyTableName);
            } else {
                zoomQuery.addRestriction(this.m_columnName, "=", value);
                if (this.m_columnName.indexOf(".") > 0) {
                    zoomQuery.setZoomColumnName(this.m_columnName.substring(this.m_columnName.indexOf(".") + 1));
                    zoomQuery.setZoomTableName(this.m_columnName.substring(0, this.m_columnName.indexOf(".")));
                } else {
                    zoomQuery.setZoomColumnName(this.m_columnName);
                    zoomQuery.setZoomTableName(this.m_columnName.substring(0, this.m_columnName.length() - 3));
                }
            }
            zoomQuery.setZoomValue(value);
            zoomQuery.setRecordCount(1);
        }
        int AD_Window_ID = this.m_lookup.getZoom(zoomQuery);
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(this.m_columnName) + " - AD_Window_ID=" + AD_Window_ID + " - Query=" + zoomQuery + " - Value=" + value);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        AWindow frame = new AWindow(null);
        if (!frame.initWindow(AD_Window_ID, zoomQuery)) {
            this.setCursor(Cursor.getDefaultCursor());
            ValueNamePair pp = CLogger.retrieveError();
            String msg = pp == null ? "AccessTableNoView" : pp.getValue();
            ADialog.error(this.m_lookup.getWindowNo(), this, msg, pp == null ? "" : pp.getName());
        } else {
            AEnv.addToWindowManager(frame);
            if (Ini.isPropertyBool((String)"OpenWindowMaximized")) {
                AEnv.showMaximized(frame);
            } else {
                AEnv.showCenterScreen(frame);
            }
        }
        frame = null;
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void actionRefresh() {
        if (this.m_lookup == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object obj = this.m_combo.getSelectedItem();
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(this.m_columnName) + " #" + this.m_lookup.getSize() + ", Selected=" + obj);
        }
        if (!this.isReadWrite()) {
            this.m_settingValue = true;
            this.m_lookup.removeAllElements();
            this.m_lastDisplay = this.m_lookup.getDisplay(this.m_value);
            this.m_text.setText(this.m_lastDisplay);
            this.m_text.setCaretPosition(0);
            this.m_settingValue = false;
        } else {
            this.m_lookup.refresh();
            this.m_lookup.fillComboBox(this.isMandatory(), true, true, false, this.isComboShortList());
            this.m_combo.setSelectedItem(obj);
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(this.m_columnName) + " #" + this.m_lookup.getSize() + ", Selected=" + this.m_combo.getSelectedItem());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.m_combo == null || this.m_combo.getEditor() == null) {
            return;
        }
        if (e.getSource() != this.m_combo && e.getSource() != this.m_combo.getEditor().getEditorComponent() || e.isTemporary() || this.m_haveFocus || this.m_lookup == null) {
            return;
        }
        if (this.m_lookup.isValidated() && this.m_lookup.isLoaded()) {
            this.m_haveFocus = true;
            return;
        }
        this.m_haveFocus = true;
        this.m_settingFocus = true;
        Object obj = this.m_lookup.getSelectedItem();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " - Start    Count=" + this.m_combo.getItemCount() + ", Selected=" + obj);
        }
        boolean popupVisible = this.m_combo.isPopupVisible();
        this.m_lookup.fillComboBox(this.isMandatory(), true, true, false, this.isComboShortList());
        if (popupVisible) {
            this.m_combo.hidePopup();
            this.m_combo.showPopup();
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " - Update   Count=" + this.m_combo.getItemCount() + ", Selected=" + this.m_lookup.getSelectedItem());
        }
        this.m_lookup.setSelectedItem(obj);
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " - Selected Count=" + this.m_combo.getItemCount() + ", Selected=" + this.m_lookup.getSelectedItem());
        }
        this.m_settingFocus = false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object obj;
        if (e.isTemporary() || this.m_lookup == null || !this.m_buttonSL.isEnabled() || !this.m_button.isEnabled()) {
            return;
        }
        if (e.getSource() == this.m_text) {
            String text = this.m_text.getText();
            if (log.isLoggable(Level.CONFIG)) {
                log.config(String.valueOf(this.m_columnName) + " (Text) " + this.m_columnName + " = " + this.m_value + " - " + text);
            }
            this.m_haveFocus = false;
            if (this.m_value == null && this.m_text.getText().length() == 0) {
                return;
            }
            if (this.m_lastDisplay.equals(text)) {
                return;
            }
            this.actionText();
            return;
        }
        if (e.getSource() != this.m_combo && e.getSource() != this.m_combo.getEditor().getEditorComponent()) {
            return;
        }
        if (this.m_lookup.isValidated() && !this.m_lookup.hasInactive()) {
            this.m_haveFocus = false;
            return;
        }
        this.m_settingFocus = true;
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(this.m_columnName) + " = " + this.m_combo.getSelectedItem());
        }
        if ((obj = this.m_combo.getSelectedItem()) != null) {
            this.m_combo.setSelectedItem(obj);
            if (!this.m_combo.getSelectedItem().equals(obj)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.m_columnName) + " - added to combo - " + obj);
                }
                this.m_combo.addItem(obj);
                this.m_combo.setSelectedItem(obj);
            }
        }
        this.m_settingFocus = false;
        this.m_haveFocus = false;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.m_button.setToolTipText(text);
        this.m_text.setToolTipText(text);
        this.m_combo.setToolTipText(text);
    }

    private void resetTabInfo() {
        if (this.m_lookup == null) {
            return;
        }
        String columnName = this.m_columnName;
        String[] infoNames = "M_Product_ID".equals(columnName) ? new String[]{"M_Product_ID", "M_AttributeSetInstance_ID", "M_Locator_ID", "M_Lookup_ID"} : new String[]{};
        String[] stringArray = infoNames;
        int n = infoNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Env.setContext((Properties)Env.getCtx(), (int)this.m_lookup.getWindowNo(), (int)1113, (String)name, null);
            ++n2;
        }
    }

    public int refresh() {
        if (this.m_lookup == null) {
            return -1;
        }
        if (!this.isReadWrite()) {
            this.m_lookup.removeAllElements();
            return 0;
        }
        return this.m_lookup.refresh();
    }

    public void setStopEditing(boolean stopediting) {
        this.m_stopediting = stopediting;
    }

    private void actionShortList() {
        if (this.onlyShortListItems) {
            this.onlyShortListItems = false;
            this.m_lookup.setShortList(true);
            this.refresh();
            this.m_lookup.fillComboBox(this.isMandatory(), true, true, false, this.isComboShortList());
            this.m_buttonSL.setIcon(Env.getImageIcon((String)"LockX16.gif"));
            this.m_buttonSL.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"ShortListOnlyShortListItems"));
        } else {
            this.onlyShortListItems = true;
            this.m_lookup.setShortList(false);
            this.m_buttonSL.setIcon(Env.getImageIcon((String)"Lock16.gif"));
            this.m_buttonSL.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"ShortListAllItems"));
        }
        this.actionRefresh();
    }

    public void setComboShortList(boolean shortList) {
        this.m_combo.setShortListSearch(shortList);
    }

    public boolean isComboShortList() {
        return this.m_combo.isShortListSearch();
    }

    final class VLookup_mouseAdapter
    extends MouseAdapter {
        private VLookup m_adaptee;

        VLookup_mouseAdapter(VLookup adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            } else {
                this.m_adaptee.popupMenu.setVisible(false);
            }
        }
    }
}

