/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.compiere.apps.AEnv;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VImageDialog;
import org.compiere.model.GridField;
import org.compiere.model.MImage;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class VImage
extends JButton
implements VEditor,
ActionListener {
    private static final long serialVersionUID = 368261613546756534L;
    private int m_WindowNo;
    private MImage m_mImage = null;
    private boolean m_mandatory = false;
    private String m_columnName = "AD_Image_ID";
    private static CLogger log = CLogger.getCLogger(VImage.class);
    private GridField m_mField = null;

    public VImage(String columnName, int WindowNo) {
        super("-");
        this.m_columnName = columnName;
        this.m_WindowNo = WindowNo;
        super.addActionListener(this);
    }

    @Override
    public void dispose() {
        this.m_mImage = null;
    }

    @Override
    public void setValue(Object value) {
        int COLUMNSIZE = 220;
        int newValue = 0;
        if (value instanceof Integer) {
            newValue = (Integer)value;
        }
        if (newValue == 0) {
            this.m_mImage = null;
            super.setText("-");
            super.setIcon(null);
            super.setDisabledIcon(null);
            super.setToolTipText(null);
            return;
        }
        if (this.m_mImage == null || newValue != this.m_mImage.get_ID()) {
            this.m_mImage = MImage.get((Properties)Env.getCtx(), (int)newValue);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_mImage.toString());
        }
        super.setText(null);
        if (this.m_mImage.getImage() == null) {
            return;
        }
        ImageIcon image = new ImageIcon(this.m_mImage.getImage());
        if (image.getIconHeight() > 220 || image.getIconWidth() > 220) {
            if (image.getIconHeight() > image.getIconWidth()) {
                super.setIcon(new ImageIcon(this.m_mImage.getImage().getScaledInstance(-1, 220, 1)));
                super.setDisabledIcon(new ImageIcon(this.m_mImage.getImage().getScaledInstance(-1, 220, 1)));
            } else {
                super.setIcon(new ImageIcon(this.m_mImage.getImage().getScaledInstance(220, -1, 1)));
                super.setDisabledIcon(new ImageIcon(this.m_mImage.getImage().getScaledInstance(220, -1, 1)));
            }
        } else {
            super.setIcon(this.m_mImage.getIcon());
            super.setDisabledIcon(this.m_mImage.getIcon());
        }
        super.setToolTipText(this.m_mImage.getName());
        this.invalidate();
    }

    @Override
    public Object getValue() {
        if (this.m_mImage == null || this.m_mImage.get_ID() == 0) {
            return null;
        }
        return new Integer(this.m_mImage.get_ID());
    }

    @Override
    public String getDisplay() {
        return this.m_mImage.getName();
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (this.isEnabled() != rw) {
            this.setEnabled(rw);
        }
    }

    @Override
    public boolean isReadWrite() {
        return super.isEnabled();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setBackground(Color color) {
    }

    public void setBackground() {
    }

    @Override
    public void setBackground(boolean error) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        VImageDialog vid = new VImageDialog((Frame)AEnv.getWindow(this.m_WindowNo), this.m_mImage);
        vid.setVisible(true);
        int AD_Image_ID = vid.getAD_Image_ID();
        Integer newValue = null;
        if (AD_Image_ID != 0) {
            newValue = new Integer(AD_Image_ID);
        }
        this.m_mImage = null;
        this.setValue(newValue);
        try {
            this.fireVetoableChange(this.m_columnName, null, newValue);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }
}

