/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.util.Enumeration;
import org.apache.ecs.Attributes;
import org.apache.ecs.ECSDefaults;
import org.apache.ecs.Element;
import org.apache.ecs.Filter;
import org.apache.ecs.GenericElement;

public abstract class ElementAttributes
extends GenericElement
implements Attributes {
    private static final long serialVersionUID = 5646571780677625947L;
    private Filter attribute_filter = this.getFilter();
    private boolean filter_attribute_state = ECSDefaults.getDefaultFilterAttributeState();
    private char attribute_equality_sign = ECSDefaults.getDefaultAttributeEqualitySign();
    private char attribute_quote_char = ECSDefaults.getDefaultAttributeQuoteChar();
    private boolean attribute_quote = ECSDefaults.getDefaultAttributeQuote();

    @Override
    public Element setAttributeQuoteChar(char quote_char) {
        this.attribute_quote_char = quote_char;
        return this;
    }

    @Override
    public char getAttributeQuoteChar() {
        return this.attribute_quote_char;
    }

    @Override
    public Element setAttributeEqualitySign(char equality_sign) {
        this.attribute_equality_sign = equality_sign;
        return this;
    }

    @Override
    public char getAttributeEqualitySign() {
        return this.attribute_equality_sign;
    }

    @Override
    public boolean getAttributeQuote() {
        return this.attribute_quote;
    }

    @Override
    public Element setAttributeQuote(boolean attribute_quote) {
        this.attribute_quote = attribute_quote;
        return this;
    }

    public Element setID(String id) {
        this.addAttribute("id", id);
        return this;
    }

    public Element setClass(String element_class) {
        this.addAttribute("class", element_class);
        return this;
    }

    public Element setLang(String lang) {
        this.addAttribute("lang", lang);
        return this;
    }

    public Element setStyle(String style2) {
        this.addAttribute("style", style2);
        return this;
    }

    public Element setDir(String dir) {
        this.addAttribute("dir", dir);
        return this;
    }

    public Element setTitle(String title2) {
        this.addAttribute("title", title2);
        return this;
    }

    protected boolean getAttributeFilterState() {
        return this.filter_attribute_state;
    }

    @Override
    public Element setAttributeFilterState(boolean filter_attribute_state) {
        this.filter_attribute_state = filter_attribute_state;
        return this;
    }

    @Override
    public Element setAttributeFilter(Filter attribute_filter) {
        this.filter_attribute_state = true;
        this.attribute_filter = attribute_filter;
        return this;
    }

    @Override
    public Filter getAttributeFilter() {
        return this.attribute_filter;
    }

    @Override
    public Element addAttribute(String attribute_name, Object attribute_value) {
        this.getElementHashEntry().put(attribute_name, attribute_value);
        return this;
    }

    @Override
    public Element addAttribute(String attribute_name, int attribute_value) {
        this.getElementHashEntry().put(attribute_name, new Integer(attribute_value));
        return this;
    }

    @Override
    public Element addAttribute(String attribute_name, String attribute_value) {
        if (attribute_name != null && attribute_value != null) {
            this.getElementHashEntry().put(attribute_name, attribute_value);
        }
        return this;
    }

    @Override
    public Element addAttribute(String attribute_name, Integer attribute_value) {
        this.getElementHashEntry().put(attribute_name, attribute_value);
        return this;
    }

    @Override
    public Element removeAttribute(String attribute_name) {
        try {
            this.getElementHashEntry().remove(attribute_name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public boolean hasAttribute(String attribute) {
        return this.getElementHashEntry().containsKey(attribute);
    }

    public Enumeration<String> attributes() {
        return this.getElementHashEntry().keys();
    }

    public String getAttribute(String attribute) {
        return (String)this.getElementHashEntry().get(attribute);
    }

    @Override
    protected String createStartTag() {
        StringBuilder out = new StringBuilder();
        out.append(this.getStartTagChar());
        if (this.getBeginStartModifierDefined()) {
            out.append(this.getBeginStartModifier());
        }
        out.append(this.getElementType());
        Enumeration<String> en = this.getElementHashEntry().keys();
        String value = null;
        while (en.hasMoreElements()) {
            String attr = en.nextElement();
            value = this.getAttributeFilterState() ? this.getAttributeFilter().process(this.getElementHashEntry().get(attr).toString()) : (String)this.getElementHashEntry().get(attr);
            out.append(' ');
            out.append(this.alterCase(attr));
            if (!value.equalsIgnoreCase("ECS_NO_ATTRIBUTE_VALUE") && this.getAttributeQuote()) {
                out.append(this.getAttributeEqualitySign());
                out.append(this.getAttributeQuoteChar());
                out.append(value);
                out.append(this.getAttributeQuoteChar());
                continue;
            }
            if (this.getAttributeQuote()) continue;
            out.append(this.getAttributeEqualitySign());
            out.append(value);
        }
        if (this.getBeginEndModifierDefined()) {
            out.append(this.getBeginEndModifier());
        }
        out.append(this.getEndTagChar());
        return out.toString();
    }
}

