/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jms.JMSException;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.BlobUploadStrategy;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.commons.net.ftp.FTPClient;

public class FTPBlobUploadStrategy
implements BlobUploadStrategy {
    private URL url;
    private String ftpUser = "";
    private String ftpPass = "";
    private BlobTransferPolicy transferPolicy;

    public FTPBlobUploadStrategy(BlobTransferPolicy transferPolicy) throws MalformedURLException {
        this.transferPolicy = transferPolicy;
        this.url = new URL(this.transferPolicy.getUploadUrl());
        this.setUserInformation(this.url.getUserInfo());
    }

    public URL uploadFile(ActiveMQBlobMessage message, File file) throws JMSException, IOException {
        return this.uploadStream(message, new FileInputStream(file));
    }

    public URL uploadStream(ActiveMQBlobMessage message, InputStream in) throws JMSException, IOException {
        String connectUrl = this.url.getHost();
        int port = this.url.getPort() < 1 ? 21 : this.url.getPort();
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(connectUrl, port);
        }
        catch (ConnectException e) {
            throw new JMSException("Problem connecting the FTP-server");
        }
        if (!ftp.login(this.ftpUser, this.ftpPass)) {
            ftp.quit();
            ftp.disconnect();
            throw new JMSException("Cant Authentificate to FTP-Server");
        }
        String path = this.url.getPath();
        String workingDir = path.substring(0, path.lastIndexOf("/"));
        String filename = message.getMessageId().toString().replaceAll(":", "_");
        ftp.setFileType(2);
        String url = !ftp.changeWorkingDirectory(workingDir) ? this.url.toString().replaceFirst(this.url.getPath(), "") + "/" : this.url.toString();
        ftp.storeFile(filename, in);
        ftp.quit();
        ftp.disconnect();
        return new URL(url + filename);
    }

    private void setUserInformation(String userInfo) {
        if (userInfo != null) {
            String[] userPass = userInfo.split(":");
            if (userPass.length > 0) {
                this.ftpUser = userPass[0];
            }
            if (userPass.length > 1) {
                this.ftpPass = userPass[1];
            }
        } else {
            this.ftpUser = "anonymous";
            this.ftpPass = "anonymous";
        }
    }
}

