/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ActionHandler;
import org.jpedal.objects.acroforms.ConvertToString;
import org.jpedal.objects.acroforms.FixImageIcon;
import org.jpedal.objects.acroforms.FormFactory;
import org.jpedal.objects.acroforms.FormObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class DefaultFormFactory
implements FormFactory {
    private static final boolean debugUnimplemented = false;
    private static boolean showIconImages = false;
    private AcroRenderer acrorend;
    private boolean printAllouts;
    private boolean printouts;
    private ActionHandler formsActionHandler;

    private DefaultFormFactory() {
        this.printouts = this.printAllouts = false;
    }

    public DefaultFormFactory(AcroRenderer acroRenderer, ActionHandler actionHandler) {
        this.printouts = this.printAllouts = false;
        this.acrorend = acroRenderer;
        this.formsActionHandler = actionHandler;
    }

    public void reset(AcroRenderer acroRenderer, ActionHandler actionHandler) {
        this.acrorend = acroRenderer;
        this.formsActionHandler = actionHandler;
    }

    public Component annotationButton(FormObject formObject) {
        JButton jButton = new JButton();
        this.setupButton(jButton, formObject);
        this.setupUniversalFeatures(jButton, formObject);
        return jButton;
    }

    public Component comboBox(FormObject formObject) {
        String[] stringArray = formObject.itemsList;
        JComboBox<Object> jComboBox = stringArray == null ? new JComboBox() : new JComboBox<String>(stringArray);
        String string = formObject.selectedItem;
        if (formObject.valuesMap != null) {
            jComboBox.setSelectedItem(formObject.valuesMap.get(string));
        } else {
            jComboBox.setSelectedItem(string);
        }
        if (this.printouts) {
            System.out.println("currently selected value=" + string);
        }
        if (formObject.flags[18]) {
            if (this.printouts) {
                System.out.println("drop list and an editable text box");
            }
            jComboBox.setEditable(true);
        } else {
            if (this.printouts) {
                System.out.println("only a drop list");
            }
            jComboBox.setEditable(false);
        }
        this.setupUniversalFeatures(jComboBox, formObject);
        if (formObject.flags != null && formObject.flags[1]) {
            jComboBox.setEditable(false);
            jComboBox.setEnabled(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jComboBox);
            }
        }
        return jComboBox;
    }

    public Component checkBoxBut(FormObject formObject) {
        JCheckBox jCheckBox = new JCheckBox();
        this.setupButton(jCheckBox, formObject);
        this.setupUniversalFeatures(jCheckBox, formObject);
        if (formObject.flags != null && formObject.flags[1]) {
            jCheckBox.setEnabled(false);
            jCheckBox.setDisabledIcon(jCheckBox.getIcon());
            jCheckBox.setDisabledSelectedIcon(jCheckBox.getSelectedIcon());
        }
        return jCheckBox;
    }

    public Component listField(FormObject formObject) {
        String[] stringArray = formObject.itemsList;
        JList<Object> jList = stringArray != null ? new JList<String>(stringArray) : new JList();
        if (!formObject.flags[21]) {
            jList.setSelectionMode(0);
        }
        if (formObject.topIndex != null) {
            jList.setSelectedIndices(formObject.topIndex);
            if (this.printouts) {
                System.out.println("topIndex should be=" + ConvertToString.convertArrayToString(formObject.topIndex));
            }
        } else {
            String string = formObject.selectedItem;
            if (formObject.valuesMap != null) {
                jList.setSelectedValue(formObject.valuesMap.get(string), true);
            } else {
                jList.setSelectedValue(string, true);
            }
            if (this.printouts) {
                System.out.println("currently selected value=" + string);
            }
        }
        this.setupUniversalFeatures(jList, formObject);
        return jList;
    }

    public Component multiLinePassword(FormObject formObject) {
        String string = formObject.textString;
        int n = formObject.maxTextLength;
        JPasswordField jPasswordField = n != -1 ? new JPasswordField(string, n) : new JPasswordField(string);
        jPasswordField.setEchoChar('*');
        if (this.printouts) {
            System.out.println("there is a password to be entered that can be MULTILINED");
        }
        this.setupUniversalFeatures(jPasswordField, formObject);
        this.setupTextFeatures(jPasswordField, formObject);
        if (formObject.flags != null && formObject.flags[1]) {
            jPasswordField.setEnabled(false);
            jPasswordField.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jPasswordField);
            }
        }
        return jPasswordField;
    }

    public Component multiLineText(FormObject formObject) {
        JTextArea jTextArea = new JTextArea(formObject.textString);
        jTextArea.setLineWrap(true);
        int n = formObject.maxTextLength;
        if (n != -1) {
            jTextArea.setColumns(n);
            if (this.printouts) {
                System.out.println("textlength added=" + n);
            }
        }
        this.setupUniversalFeatures(jTextArea, formObject);
        if (formObject.flags != null && formObject.flags[1]) {
            jTextArea.setEnabled(false);
            jTextArea.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jTextArea);
            }
        }
        return jTextArea;
    }

    public Component signature(FormObject formObject) {
        JButton jButton = new JButton();
        this.setupButton(jButton, formObject);
        this.setupUniversalFeatures(jButton, formObject);
        if (formObject.flags != null && formObject.flags[1]) {
            jButton.setEnabled(false);
            jButton.setDisabledIcon(jButton.getIcon());
            jButton.setDisabledSelectedIcon(jButton.getSelectedIcon());
        }
        return jButton;
    }

    public Component pushBut(FormObject formObject) {
        JButton jButton = new JButton();
        this.setupButton(jButton, formObject);
        this.setupUniversalFeatures(jButton, formObject);
        if (formObject.flags != null && formObject.flags[1]) {
            jButton.setEnabled(false);
            jButton.setDisabledIcon(jButton.getIcon());
            jButton.setDisabledSelectedIcon(jButton.getSelectedIcon());
        }
        return jButton;
    }

    public Component radioBut(FormObject formObject) {
        JRadioButton jRadioButton = new JRadioButton();
        this.setupButton(jRadioButton, formObject);
        this.setupUniversalFeatures(jRadioButton, formObject);
        if (formObject.flags != null && formObject.flags[1]) {
            jRadioButton.setEnabled(false);
            jRadioButton.setDisabledIcon(jRadioButton.getIcon());
            jRadioButton.setDisabledSelectedIcon(jRadioButton.getSelectedIcon());
        }
        return jRadioButton;
    }

    public Component singleLinePassword(FormObject formObject) {
        JPasswordField jPasswordField = new JPasswordField(formObject.textString);
        jPasswordField.setEchoChar('*');
        int n = formObject.maxTextLength;
        if (n != -1) {
            jPasswordField.setColumns(n);
            if (this.printouts) {
                System.out.println("textlength added=" + n);
            }
        }
        this.setupUniversalFeatures(jPasswordField, formObject);
        this.setupTextFeatures(jPasswordField, formObject);
        if (formObject.flags != null && formObject.flags[1]) {
            jPasswordField.setEnabled(false);
            jPasswordField.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jPasswordField);
            }
        }
        return jPasswordField;
    }

    public Component singleLineText(FormObject formObject) {
        JTextField jTextField = new JTextField(formObject.textString);
        int n = formObject.maxTextLength;
        if (n != -1) {
            jTextField.setColumns(n);
            if (this.printouts) {
                System.out.println("textlength added=" + n);
            }
        }
        this.setupUniversalFeatures(jTextField, formObject);
        this.setupTextFeatures(jTextField, formObject);
        if (formObject.flags != null && formObject.flags[1]) {
            jTextField.setEnabled(false);
            jTextField.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + jTextField);
            }
        }
        return jTextField;
    }

    private void setupTextFeatures(JTextField jTextField, FormObject formObject) {
        if (formObject.allignment != -1) {
            jTextField.setHorizontalAlignment(formObject.allignment);
        }
    }

    private void setupButton(AbstractButton abstractButton, FormObject formObject) {
        abstractButton.setText(formObject.normalCaption);
        abstractButton.setContentAreaFilled(false);
        if (formObject.downCaption != null || formObject.rolloverCaption != null) {
            abstractButton.addMouseListener(this.formsActionHandler.setupChangingCaption(formObject.normalCaption, formObject.rolloverCaption, formObject.downCaption));
        }
        if (formObject.appearancesUsed) {
            this.appearanceImages(formObject, abstractButton, showIconImages);
        }
        if (formObject.textPosition != -1) {
            switch (formObject.textPosition) {
                case 0: {
                    abstractButton.setIcon(null);
                    break;
                }
                case 1: {
                    abstractButton.setText(null);
                    break;
                }
                case 2: {
                    abstractButton.setVerticalTextPosition(3);
                    break;
                }
                case 3: {
                    abstractButton.setVerticalTextPosition(1);
                    break;
                }
                case 4: {
                    abstractButton.setHorizontalTextPosition(4);
                    break;
                }
                case 5: {
                    abstractButton.setHorizontalTextPosition(2);
                    break;
                }
                case 6: {
                    abstractButton.setText(null);
                }
            }
        }
        Insets insets = new Insets(0, 0, 0, 0);
        abstractButton.setMargin(insets);
    }

    private void appearanceImages(FormObject formObject, AbstractButton abstractButton, boolean bl) {
        String string = formObject.defaultState;
        if (this.printouts) {
            System.out.println("default state=" + string);
        }
        if (string != null && string.equals(formObject.normalOnState)) {
            abstractButton.setSelected(true);
        }
        if (formObject.hasNormalOff()) {
            abstractButton.setText(null);
            abstractButton.setIcon(new FixImageIcon(formObject.normalOffImage));
            if (bl) {
                ShowGUIMessage.showGUIMessage("normalAppOffImage", formObject.normalOffImage, "normalAppOff");
            }
        }
        if (formObject.hasNormalOn()) {
            abstractButton.setText(null);
            abstractButton.setSelectedIcon(new FixImageIcon(formObject.normalOnImage));
            if (bl) {
                ShowGUIMessage.showGUIMessage("normalAppOnImage", formObject.normalOnImage, "normalAppOn");
            }
        }
        if (formObject.noDownIcon) {
            abstractButton.setPressedIcon(abstractButton.getIcon());
        } else {
            BufferedImage bufferedImage = null;
            BufferedImage bufferedImage2 = null;
            if (formObject.offsetDownIcon && !formObject.hasDownImage()) {
                if (formObject.hasNormalOff()) {
                    if (formObject.hasNormalOn()) {
                        bufferedImage2 = this.createPressedLook(formObject.normalOnImage);
                        bufferedImage = this.createPressedLook(formObject.normalOffImage);
                    } else {
                        bufferedImage = this.createPressedLook(formObject.normalOffImage);
                    }
                } else if (formObject.hasNormalOn()) {
                    bufferedImage = this.createPressedLook(formObject.normalOnImage);
                }
            } else if (formObject.invertDownIcon) {
                if (formObject.hasNormalOff()) {
                    if (formObject.hasNormalOn()) {
                        bufferedImage = this.invertImage(formObject.normalOffImage);
                        bufferedImage2 = this.invertImage(formObject.normalOnImage);
                    } else {
                        bufferedImage = this.invertImage(formObject.normalOffImage);
                    }
                } else if (formObject.hasNormalOn()) {
                    bufferedImage = this.invertImage(formObject.normalOnImage);
                }
            } else {
                bufferedImage = formObject.downOffImage;
                bufferedImage2 = formObject.downOnImage;
            }
            if (bufferedImage == null && bufferedImage2 == null) {
                if (formObject.hasNormalOff()) {
                    if (formObject.hasNormalOn()) {
                        bufferedImage = this.invertImage(formObject.normalOffImage);
                        bufferedImage2 = this.invertImage(formObject.normalOnImage);
                    } else {
                        bufferedImage = this.invertImage(formObject.normalOffImage);
                    }
                } else if (formObject.hasNormalOn()) {
                    bufferedImage = this.invertImage(formObject.normalOnImage);
                }
            }
            if (bl) {
                ShowGUIMessage.showGUIMessage("downAppOffImage", formObject.downOffImage, "downAppOff");
                ShowGUIMessage.showGUIMessage("downAppOnImage", formObject.downOnImage, "downAppOn");
            }
            if (bufferedImage == null || bufferedImage2 == null) {
                if (bufferedImage != null) {
                    abstractButton.setText(null);
                    abstractButton.setPressedIcon(new FixImageIcon(bufferedImage));
                } else if (bufferedImage2 != null) {
                    abstractButton.setText(null);
                    abstractButton.setPressedIcon(new FixImageIcon(bufferedImage2));
                }
                if (this.printouts) {
                    System.out.println("CHECK there is an off or on down image not both does this work, DefaultAcro.createAppearanceImages");
                }
            } else {
                if (abstractButton.isSelected()) {
                    abstractButton.setPressedIcon(new FixImageIcon(bufferedImage2));
                } else {
                    abstractButton.setPressedIcon(new FixImageIcon(bufferedImage));
                }
                abstractButton.addActionListener(this.formsActionHandler.setupChangingDownIcon(bufferedImage, bufferedImage2));
            }
        }
        if (formObject.hasRolloverOff()) {
            abstractButton.setRolloverEnabled(true);
            abstractButton.setText(null);
            abstractButton.setRolloverIcon(new FixImageIcon(formObject.rolloverOffImage));
            if (bl) {
                ShowGUIMessage.showGUIMessage("rolloverAppOffImage", formObject.rolloverOffImage, "rolloverAppOff");
            }
        }
        if (formObject.hasRolloverOn()) {
            abstractButton.setRolloverEnabled(true);
            abstractButton.setText(null);
            abstractButton.setRolloverSelectedIcon(new FixImageIcon(formObject.rolloverOnImage));
            if (bl) {
                ShowGUIMessage.showGUIMessage("rolloverAppOnImage", formObject.rolloverOnImage, "rolloverAppOn");
            }
        }
    }

    private BufferedImage invertImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        byte[] byArray = new byte[256];
        for (int i = 0; i < 200; ++i) {
            byArray[i] = (byte)(256 - i);
        }
        ByteLookupTable byteLookupTable = new ByteLookupTable(0, byArray);
        LookupOp lookupOp = new LookupOp(byteLookupTable, null);
        lookupOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private BufferedImage createPressedLook(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null) + 2, image.getHeight(null) + 2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(image, 1, 1, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void setupUniversalFeatures(JComponent jComponent, FormObject formObject) {
        jComponent.setOpaque(false);
        if (formObject.textFont != null) {
            jComponent.setFont(formObject.textFont);
        }
        jComponent.setForeground(formObject.textColor);
        Border border = this.createBorderStyle(formObject.border, formObject.borderColor, Color.white);
        jComponent.setBorder(border);
        if (this.printouts) {
            System.out.println("borderStyle=" + border);
        }
        if (formObject.backgroundColor != null) {
            jComponent.setBackground(formObject.backgroundColor);
            jComponent.setOpaque(true);
        }
        this.setupMouseListener(jComponent, formObject);
        if (this.printouts) {
            System.out.println("flagNum=" + formObject.characteristic);
        }
    }

    private void setupMouseListener(Component component, FormObject formObject) {
        if (formObject.characteristic[0] || formObject.characteristic[1] || formObject.characteristic[5]) {
            component.setVisible(false);
        }
        if (formObject.characteristic[8]) {
            component.addMouseListener(this.formsActionHandler.setupCommand("togglenoview", this.acrorend));
        }
        if (formObject.enteredAction != null) {
            if (component instanceof JComboBox) {
                ((JComboBox)component).getComponent(0).addMouseListener(this.formsActionHandler.setupEnteredAction(formObject.enteredAction, this.acrorend));
            } else {
                component.addMouseListener(this.formsActionHandler.setupEnteredAction(formObject.enteredAction, this.acrorend));
            }
        }
        if (formObject.exitedAction != null) {
            if (component instanceof JComboBox) {
                ((JComboBox)component).getComponent(0).addMouseListener(this.formsActionHandler.setupExitedAction(formObject.exitedAction, this.acrorend));
            } else {
                component.addMouseListener(this.formsActionHandler.setupExitedAction(formObject.exitedAction, this.acrorend));
            }
        }
        if (formObject.activateAction != null) {
            Iterator iterator = formObject.activateAction.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Object k = iterator.next();
                if (k.equals("ResetForm")) {
                    if (component instanceof JComboBox) {
                        ((JComboBox)component).getComponent(0).addMouseListener(this.formsActionHandler.setupCommand("ResetForm", this.acrorend));
                        continue;
                    }
                    component.addMouseListener(this.formsActionHandler.setupCommand("ResetForm", this.acrorend));
                    continue;
                }
                if (k.equals("Print")) {
                    if (component instanceof JComboBox) {
                        ((JComboBox)component).getComponent(0).addMouseListener(this.formsActionHandler.setupCommand("Print", this.acrorend));
                        continue;
                    }
                    component.addMouseListener(this.formsActionHandler.setupCommand("Print", this.acrorend));
                    continue;
                }
                if (k.equals("SaveAs")) {
                    if (component instanceof JComboBox) {
                        ((JComboBox)component).getComponent(0).addMouseListener(this.formsActionHandler.setupCommand("SaveAs", this.acrorend));
                        continue;
                    }
                    component.addMouseListener(this.formsActionHandler.setupCommand("SaveAs", this.acrorend));
                    continue;
                }
                if (k.equals("Hide")) {
                    if (component instanceof JComboBox) {
                        ((JComboBox)component).getComponent(0).addMouseListener(this.formsActionHandler.setupHideAction((Map)formObject.activateAction.get("Hide"), this.acrorend));
                        continue;
                    }
                    component.addMouseListener(this.formsActionHandler.setupHideAction((Map)formObject.activateAction.get("Hide"), this.acrorend));
                    continue;
                }
                if (k.equals("SubmitForm")) {
                    object = (Map)formObject.activateAction.get("SubmitForm");
                    if (component instanceof JComboBox) {
                        ((JComboBox)component).getComponent(0).addMouseListener(this.formsActionHandler.setupSubmitAction((Map)object, this.acrorend));
                        continue;
                    }
                    component.addMouseListener(this.formsActionHandler.setupSubmitAction((Map)object, this.acrorend));
                    continue;
                }
                if (k.equals("Popup")) {
                    if (component instanceof JComboBox) {
                        ((JComboBox)component).getComponent(0).addMouseListener(this.formsActionHandler.setupClickedAction(formObject.activateAction, this.acrorend));
                        continue;
                    }
                    component.addMouseListener(this.formsActionHandler.setupClickedAction(formObject.activateAction, this.acrorend));
                    continue;
                }
                if (k.equals("URL")) {
                    object = (String)formObject.activateAction.get("URL");
                    ((JComponent)component).setToolTipText((String)object);
                    continue;
                }
                LogWriter.writeFormLog("key not implemented DefaultFormFactory.setupMouseListener key=" + k, false);
            }
        }
        if (formObject.validateValue != null) {
            if (component instanceof JComboBox) {
                ((JComboBox)component).getComponent(0).addPropertyChangeListener(this.formsActionHandler.setupValidateAction(formObject.validateValue));
            } else {
                component.addPropertyChangeListener(this.formsActionHandler.setupValidateAction(formObject.validateValue));
            }
        }
    }

    private Border createBorderStyle(Object object, Color color, Color color2) {
        Object v;
        if (this.printouts) {
            System.out.println("createBorderStyle() color=" + color + " background color=" + color2 + "\n\tfield=" + object);
        }
        Map map = new HashMap<String, String>();
        if (object == null) {
            map.put("S", "/S");
            map.put("W", "1");
        } else if (object instanceof Map) {
            map = (Map)object;
        } else {
            LogWriter.writeFormLog("{DefaultFormFactory.createBorderStyle} border stream is String DefaultFormFactory.createBorderStyle", false);
        }
        if (color2 == null && this.printouts) {
            System.out.println("background border color null");
        }
        if (color == null) {
            if (this.printouts) {
                System.out.println("border color null");
            }
            return null;
        }
        Border border = null;
        String string = (String)map.get("W");
        if (this.printouts) {
            System.out.println("width=" + string);
        }
        String string2 = (String)map.get("S");
        string2 = Strip.checkRemoveLeadingSlach(string2);
        if (this.printouts) {
            System.out.println("style=" + string2);
        }
        if (string2.equals("U")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() U CHECK=" + ConvertToString.convertMapToString(map, null));
            }
            border = BorderFactory.createMatteBorder(0, 0, Integer.parseInt(string), 0, color);
        } else if (string2.equals("I")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() I CHECK=" + ConvertToString.convertMapToString(map, null));
            }
            border = BorderFactory.createEtchedBorder(color, color2);
        } else if (string2.equals("B")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() B CHECK=" + ConvertToString.convertMapToString(map, null));
            }
            border = BorderFactory.createBevelBorder(1, color, color2);
        } else if (string2.equals("S")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() S CHECK=" + ConvertToString.convertMapToString(map, null));
            }
            border = BorderFactory.createLineBorder(color, Integer.parseInt(string));
        } else if (!string2.equals("D") || (v = map.get("D")) instanceof String || v instanceof Map) {
            // empty if block
        }
        return border;
    }
}

