/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;

public final class JRFiller {
    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters, Connection conn) throws JRException {
        JRBaseFiller filler = JRFiller.createFiller(jasperReportsContext, jasperReport);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, conn);
        }
        catch (JRFillInterruptedException e) {
            throw new JRException("The report filling thread was interrupted.", e);
        }
        return jasperPrint;
    }

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JRBaseFiller filler = JRFiller.createFiller(jasperReportsContext, jasperReport);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, dataSource);
        }
        catch (JRFillInterruptedException e) {
            throw new JRException("The report filling thread was interrupted.", e);
        }
        return jasperPrint;
    }

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        JRBaseFiller filler = JRFiller.createFiller(jasperReportsContext, jasperReport);
        try {
            JasperPrint jasperPrint = filler.fill(parameters);
            return jasperPrint;
        }
        catch (JRFillInterruptedException e) {
            throw new JRException("The report filling thread was interrupted.", e);
        }
    }

    public static JRBaseFiller createFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport) throws JRException {
        JRBaseFiller filler = null;
        switch (jasperReport.getPrintOrderValue()) {
            case HORIZONTAL: {
                filler = new JRHorizontalFiller(jasperReportsContext, jasperReport);
                break;
            }
            case VERTICAL: {
                filler = new JRVerticalFiller(jasperReportsContext, jasperReport);
            }
        }
        return filler;
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, Connection conn) throws JRException {
        return JRFiller.fill((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jasperReport, parameters, conn);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        return JRFiller.fill((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jasperReport, parameters, dataSource);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        return JRFiller.fill(DefaultJasperReportsContext.getInstance(), jasperReport, parameters);
    }

    public static JRBaseFiller createFiller(JasperReport jasperReport) throws JRException {
        return JRFiller.createFiller(DefaultJasperReportsContext.getInstance(), jasperReport);
    }

    private JRFiller() {
    }
}

