/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.design.JRDesignSubreportReturnValue;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreportReturnValue;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.type.CalculationEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FillReturnValues {
    private static final Log log = LogFactory.getLog(FillReturnValues.class);
    private final JRBaseFiller filler;
    private JRFillSubreportReturnValue[] returnValues;
    private JRFillBand band;

    public FillReturnValues(JRSubreportReturnValue[] values, JRFillObjectFactory factory, JRBaseFiller filler) {
        this.filler = filler;
        if (values != null && values.length > 0) {
            ArrayList<JRFillSubreportReturnValue> returnValuesList = new ArrayList<JRFillSubreportReturnValue>(values.length * 2);
            for (JRSubreportReturnValue returnValue : values) {
                JRFillSubreportReturnValue fillReturnValue = factory.getSubreportReturnValue(returnValue);
                this.addReturnValue(fillReturnValue, returnValuesList, factory, filler);
            }
            this.returnValues = new JRFillSubreportReturnValue[returnValuesList.size()];
            returnValuesList.toArray(this.returnValues);
        }
    }

    public FillReturnValues(List<ReturnValue> values, JRFillObjectFactory factory, JRBaseFiller filler) {
        this.filler = filler;
        if (values != null && !values.isEmpty()) {
            ArrayList<JRFillSubreportReturnValue> returnValuesList = new ArrayList<JRFillSubreportReturnValue>(values.size() * 2);
            for (ReturnValue returnValue : values) {
                JRFillSubreportReturnValue fillReturnValue = factory.getReturnValue(returnValue);
                this.addReturnValue(fillReturnValue, returnValuesList, factory, filler);
            }
            this.returnValues = new JRFillSubreportReturnValue[returnValuesList.size()];
            returnValuesList.toArray(this.returnValues);
        }
    }

    protected JRFillSubreportReturnValue addReturnValue(JRFillSubreportReturnValue returnValue, List<JRFillSubreportReturnValue> returnValueList, JRFillObjectFactory factory, JRBaseFiller filler) {
        CalculationEnum calculation = returnValue.getCalculationValue();
        switch (calculation) {
            case AVERAGE: 
            case VARIANCE: {
                JRSubreportReturnValue countVal = this.createHelperReturnValue(returnValue, "_COUNT", CalculationEnum.COUNT);
                this.addDerivedReturnValue(countVal, returnValueList, factory, filler);
                JRSubreportReturnValue sumVal = this.createHelperReturnValue(returnValue, "_SUM", CalculationEnum.SUM);
                this.addDerivedReturnValue(sumVal, returnValueList, factory, filler);
                filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                JRSubreportReturnValue varianceVal = this.createHelperReturnValue(returnValue, "_VARIANCE", CalculationEnum.VARIANCE);
                this.addDerivedReturnValue(varianceVal, returnValueList, factory, filler);
                filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
            case DISTINCT_COUNT: {
                JRSubreportReturnValue countVal = this.createDistinctCountHelperReturnValue(returnValue);
                this.addDerivedReturnValue(countVal, returnValueList, factory, filler);
                filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
        }
        returnValueList.add(returnValue);
        return returnValue;
    }

    protected JRFillSubreportReturnValue addDerivedReturnValue(JRSubreportReturnValue parentReturnValue, List<JRFillSubreportReturnValue> returnValueList, JRFillObjectFactory factory, JRBaseFiller filler) {
        JRFillSubreportReturnValue returnValue = factory.getSubreportReturnValue(parentReturnValue);
        returnValue.setDerived(true);
        return this.addReturnValue(returnValue, returnValueList, factory, filler);
    }

    protected JRSubreportReturnValue createHelperReturnValue(JRSubreportReturnValue returnValue, String nameSuffix, CalculationEnum calculation) {
        JRDesignSubreportReturnValue helper = new JRDesignSubreportReturnValue();
        helper.setToVariable(returnValue.getToVariable() + nameSuffix);
        helper.setSubreportVariable(returnValue.getSubreportVariable());
        helper.setCalculation(calculation);
        helper.setIncrementerFactoryClassName(helper.getIncrementerFactoryClassName());
        return helper;
    }

    protected JRSubreportReturnValue createDistinctCountHelperReturnValue(JRSubreportReturnValue returnValue) {
        JRDesignSubreportReturnValue helper = new JRDesignSubreportReturnValue();
        helper.setToVariable(returnValue.getToVariable() + "_DISTINCT_COUNT");
        helper.setSubreportVariable(returnValue.getSubreportVariable());
        helper.setCalculation(CalculationEnum.NOTHING);
        helper.setIncrementerFactoryClassName(helper.getIncrementerFactoryClassName());
        return helper;
    }

    public void setBand(JRFillBand band) {
        this.band = band;
        band.registerReturnValues(this);
    }

    public void saveReturnVariables() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("saving return variables on band " + this.band));
        }
        if (this.returnValues != null && this.band != null) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                String varName = this.returnValues[i].getToVariable();
                this.band.saveVariable(varName);
            }
        }
    }

    public boolean usesForReturnValue(String variableName) {
        boolean used = false;
        if (this.returnValues != null) {
            for (int j = 0; j < this.returnValues.length; ++j) {
                JRFillSubreportReturnValue returnValue = this.returnValues[j];
                if (!returnValue.getToVariable().equals(variableName)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("variable " + variableName + " used for return value of " + returnValue.getSubreportVariable()));
                }
                used = true;
                break;
            }
        }
        return used;
    }

    public void copyValues(SourceContext sourceContext) {
        if (this.returnValues != null && this.returnValues.length > 0) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                this.copyValue(this.returnValues[i], sourceContext);
            }
        }
    }

    protected void copyValue(JRFillSubreportReturnValue returnValue, SourceContext sourceContext) {
        try {
            JRFillVariable variable = this.filler.getVariable(returnValue.getToVariable());
            Object value = sourceContext.getVariableValue(returnValue.getSubreportVariable());
            if (log.isTraceEnabled()) {
                log.trace((Object)("copying value " + value + " of " + returnValue.getSubreportVariable() + " to " + returnValue.getToVariable()));
            }
            Object newValue = returnValue.getIncrementer().increment(variable, value, AbstractValueProvider.getCurrentValueProvider());
            variable.setOldValue(newValue);
            variable.setValue(newValue);
            variable.setIncrementedValue(newValue);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void checkReturnValues(SourceContext sourceContext) throws JRException {
        if (this.returnValues != null && this.returnValues.length > 0) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                JRFillSubreportReturnValue returnValue = this.returnValues[i];
                if (returnValue.isDerived()) continue;
                String subreportVariableName = returnValue.getSubreportVariable();
                JRVariable subrepVariable = sourceContext.getVariable(subreportVariableName);
                if (subrepVariable == null) {
                    throw new JRException("Source variable " + subreportVariableName + " not found for return value " + returnValue.getToVariable() + ".");
                }
                JRFillVariable variable = this.filler.getVariable(returnValue.getToVariable());
                if (returnValue.getCalculationValue() == CalculationEnum.COUNT || returnValue.getCalculationValue() == CalculationEnum.DISTINCT_COUNT) {
                    if (Number.class.isAssignableFrom(variable.getValueClass())) continue;
                    throw new JRException("Variable " + returnValue.getToVariable() + " must have a numeric type.");
                }
                if (variable.getValueClass().isAssignableFrom(subrepVariable.getValueClass()) || Number.class.isAssignableFrom(variable.getValueClass()) && Number.class.isAssignableFrom(subrepVariable.getValueClass())) continue;
                throw new JRException("Variable " + returnValue.getToVariable() + " is not assignable from source variable " + subreportVariableName);
            }
        }
    }

    public static interface SourceContext {
        public JRVariable getVariable(String var1);

        public Object getVariableValue(String var1);
    }
}

