/*************************************************************************************************/
/*!
   	@file		Regist.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include <shlwapi.h>
#pragma comment(lib, "shlwapi.lib")

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define
/**************************************************************************************************
"RegKey" class 
**************************************************************************************************/
class RegKey
{
public:
	enum OpenType
	{
		Read , 
		Write , 
	};
// variable member
private:
	HKEY	m_key;
	
// private functions
private:

// public functions
public:
//=================================================================================================
RegKey() : m_key( NULL )
{
}
//=================================================================================================
RegKey
		(
		HKEY	key
		) : m_key( key )
{
}
//=================================================================================================
RegKey
		(
		RegKey&	obj
		) : m_key( obj.Detach() )
{
}
//=================================================================================================
~RegKey()
{
	Close();
}
//=================================================================================================
RegKey& operator=
		(
		RegKey& obj
		)
{
	Close();
	m_key	= obj.Detach();
	return *this;
}
//=================================================================================================
bool Open
		(
		HKEY			parent , 
		const wchar_t*	subkey , 
		OpenType		type
		)
{
	Close();
	if( type == Read )
	{
		if( ERROR_SUCCESS != RegOpenKeyExW( parent , subkey , 0 , KEY_READ , &m_key ) )
			return false;
	}
	else if( type == Write )
	{
		if( ERROR_SUCCESS != RegCreateKeyExW( parent , subkey , 0 , NULL , 0 , KEY_WRITE , NULL , &m_key , NULL ) )
			return false;
	}
	return true;
}
//=================================================================================================
bool Open
		(
		const RegKey&	parent , 
		const wchar_t*	subkey , 
		OpenType		type
		)
{
	return Open( parent.m_key , subkey , type );
}
//=================================================================================================
void Close()
{
	if( m_key != NULL )
	{
		cb_verify( ERROR_SUCCESS == ::RegCloseKey( m_key ) );
	}
	m_key	= NULL;
}
//=================================================================================================
void Attach
		(
		HKEY	key
		)
{
	Close();
	m_key	= key;
}
//=================================================================================================
HKEY Detach()
{
	HKEY	key = m_key;
	m_key	= NULL;
	return key;
}
//=================================================================================================
uint32 GetSubkeyNum()
{
	if( m_key == NULL )
		return 0;
		
	DWORD		subkeynum = 0;
	if( ERROR_SUCCESS != ::RegQueryInfoKey
			(
			m_key , 
			0 , 0 , 0 , 
			&subkeynum , 
			0 , 0 , 0 , 0 , 0 , 0 , 0
			) )
			return 0;
	return subkeynum;
}
//=================================================================================================
bool GetSubkeyName
		(
		uint32		index , 
		wstring*	name
		)
{
	if( m_key == NULL )
		return false;
	DWORD		subkeymaxlen = 0;
	if( ERROR_SUCCESS != ::RegQueryInfoKey
			(
			m_key , 
			0 , 0 , 0 , 0 , 
			&subkeymaxlen , 
			0 , 0 , 0 , 0 , 0 , 0
			) )
			return false;

	Array<wchar_t>	data( subkeymaxlen );
	DWORD			size = subkeymaxlen;
	if( ERROR_SUCCESS != ::RegEnumKeyExW( m_key , index , data.GetPtr() , &size , 0 , 0 , 0 , 0 ) )
		return false;
	store( name , wstring( ( const wchar_t* )data.GetConstPtr() ) );
	return true;
}
//=================================================================================================
bool DeleteSubkey
		(
		const wchar_t*	name
		)
{
	if( ERROR_SUCCESS != SHDeleteKey( m_key , name ) )
		return false;
	return true;
}
//=================================================================================================
bool GetStringValue
		(
		const wchar_t*	name , 
		wstring*		value
		)
{
	DWORD	datatype = 0 , datasize = 0;
	if( ERROR_SUCCESS != RegQueryValueExW( m_key , name , 0 , &datatype , 0 , &datasize ) )
		return false;
	if( datatype != REG_SZ )
		return false;
	Array<uint8>	data( datasize );
	if( ERROR_SUCCESS != RegQueryValueExW( m_key , name , 0 , &datatype , data.GetPtr() , &datasize ) )
		return false;
	if( datasize == 0 )
		return false;
	store( value , wstring( (const wchar_t*)data.GetConstPtr() ) );
	return true;
}
//=================================================================================================
bool SetStringValue
		(
		const wchar_t*	name , 
		const wstring&	value
		)
{
	if( ERROR_SUCCESS != RegSetValueExW
			(
			m_key , 
			name , 
			0 ,
			REG_SZ , 
			( const BYTE* )value.c_str() , 
			( DWORD )value.length() * sizeof( wchar_t )
			) )
			return false;
	return true;
			
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
cb_inline
bool _RegQueryInfoKey
		(
		HKEY	hkey , 
		uint32*	rsubkeynum , 
		uint32*	rsubkeymaxlen
		)
{
	DWORD		subkeynum = 0 , subkeymaxlen = 0;
	if( ERROR_SUCCESS != ::RegQueryInfoKey
			(
			hkey , 
			0 , 0 , 0 , 
			&subkeynum , 
			&subkeymaxlen , 
			0 , 0 , 0 , 0 , 0 , 0
			) )
			return false;
	store( rsubkeynum , subkeynum );
	store( rsubkeymaxlen , subkeymaxlen );
	return true;
}
//=================================================================================================
cb_inline
bool _RegEnumKey
		(
		HKEY		hkey , 
		DWORD		index , 
		wstring*	name , 
		uint32		maxlen	
		)
{
	Array<wchar_t>	data( maxlen );
	DWORD			size = maxlen;
	if( ERROR_SUCCESS != ::RegEnumKeyExW( hkey , index , data.GetPtr() , &size , 0 , 0 , 0 , 0 ) )
		return false;
	*name	= ( const wchar_t* )data.GetConstPtr();
	return true;
}
//=================================================================================================
cb_inline
bool _RegQueryValue_reg_sz
		(
		HKEY			hkey , 
		const wchar_t*	name , 
		wstring*		value
		)
{
	DWORD	datatype = 0 , datasize = 0;
	if( ERROR_SUCCESS != RegQueryValueExW( hkey , name , 0 , &datatype , 0 , &datasize ) )
		return false;
	if( datatype != REG_SZ )
		return false;
	Array<uint8>	data( datasize );
	if( ERROR_SUCCESS != RegQueryValueExW( hkey , name , 0 , &datatype , data.GetPtr() , &datasize ) )
		return false;
	if( datasize == 0 )
		return false;
	*value	= (const wchar_t*)data.GetConstPtr();
	return true;
}
//=================================================================================================
cb_inline
void _RegCloseKey
		(
		HKEY&		hkey
		)
{
	if( hkey != NULL )
		RegCloseKey( hkey );
	hkey	= NULL;
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
