/*************************************************************************************************/
/*!
   	@file		Thread.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#ifdef cb_windows
#include <windows.h>
#endif

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

#ifdef cb_windows
/**************************************************************************************************
"CriticalSection" class 
**************************************************************************************************/
class CriticalSection
{
	cb_copy_impossible( CriticalSection );

// variable member
private:
	CRITICAL_SECTION	m_section;

// public functions
public:
//=================================================================================================
CriticalSection()
{
	::InitializeCriticalSection( &m_section );
}
//=================================================================================================
~CriticalSection()
{
	::DeleteCriticalSection( &m_section );
}
//=================================================================================================
void Lock()
{
	::EnterCriticalSection( &m_section );
}
//=================================================================================================
bool TryLock()
{
	if( FALSE == ::TryEnterCriticalSection( &m_section ) )
		return false;
	return true;
}
//=================================================================================================
void Unlock()
{
	::LeaveCriticalSection( &m_section );
}
};
/**************************************************************************************************
"Autolock" class 
**************************************************************************************************/
class Autolock
{
	cb_copy_impossible( Autolock );
	
// variable member
private:
	CriticalSection*	m_cs;
	
// private functions
private:
// public functions
public:
//=================================================================================================
Autolock
		(
		CriticalSection&	cs
		) : m_cs( &cs )
{
	m_cs->Lock();
}
//=================================================================================================
~Autolock()
{
	m_cs->Unlock();	
}
};
/**************************************************************************************************
"Thread" class 
**************************************************************************************************/
class Thread
{
	cb_copy_impossible( Thread );

// variable member
private:
	 HANDLE		m_handle;
	 
// private functions
private:
//=================================================================================================
static
DWORD WINAPI ThreadProcStatic
		(
		LPVOID	data
		)
{
	return ( ( Thread* )data )->ThreadProc();
}
// protected functions
protected:
//=================================================================================================
virtual
int ThreadProc() = 0;

// public functions
public:
//=================================================================================================
Thread() : m_handle( NULL )
{
}
//=================================================================================================
~Thread()
{
	Destroy();
}
//=================================================================================================
bool Create
		(
		uint32*		threadid = 0
		)
{
	Destroy();
	DWORD	id;
	m_handle = CreateThread
			(
			NULL , 
			0 , 
			( LPTHREAD_START_ROUTINE )ThreadProcStatic , 
			( LPVOID )this , 
			0 , 
			&id 
			);
	if( m_handle == NULL )
		return false;
	store( threadid , (uint32)id );
	return true;
}
//=================================================================================================
void Destroy()
{
	::WaitForSingleObject( m_handle , INFINITE );
	if( m_handle != NULL )
		CloseHandle( m_handle );
	m_handle	= NULL;
}
//=================================================================================================
bool IsThreadExist()
{
	return m_handle == NULL ? false : true;
}
};
#endif
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
