/*************************************************************************************************/
/*!
   	@file		iPath.h
	@author 	Fanzo
 	@date 		2008/5/7
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iOutlineGen.h"
#include	"iEdgemapOutline.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

#pragma pack( push , 1 )		//set align
enum PathSegType
{
	Move_PathSegType , 
	Line_PathSegType , 
	BezierQ_PathSegType , 
	BezierC_PathSegType , 
	ArcAngle_PathSegType , 
	ArcSweep_PathSegType , 
};
enum PathNodeType
{
	Expr_PathNodeType , 
	Factor_PathNodeType , 
};
class PathSeg
{
public:
	PathSegType	m_type;
	PathSeg*	m_next;
	PathSeg
		(
		PathSegType	type
		) : m_type( type ) , m_next( 0 ){}
};
class PathSegMove : public PathSeg
{
public:
	float		m_sx;
	float		m_sy;
	faffine		m_transform;
	bool		m_close;
	PathSegMove() : PathSeg( Move_PathSegType ) , m_close( false ){}
};
class PathSegLine : public PathSeg
{
public:
	float	m_tx;
	float	m_ty;
	PathSegLine() : PathSeg( Line_PathSegType ){}
};
class PathSegBezierQ : public PathSeg
{
public:
	float	m_hx;
	float	m_hy;
	float	m_tx;
	float	m_ty;
	PathSegBezierQ() : PathSeg( BezierQ_PathSegType ){}
};
class PathSegBezierC : public PathSeg
{
public:
	float	m_h0x;
	float	m_h0y;
	float	m_h1x;
	float	m_h1y;
	float	m_tx;
	float	m_ty;
	PathSegBezierC() : PathSeg( BezierC_PathSegType ){}
};
class PathSegArcAngle : public PathSeg
{
public:
	float	m_cx;
	float	m_cy;
	float	m_dy;
	float	m_angle;
	PathSegArcAngle() : PathSeg( ArcAngle_PathSegType ){}
};
class PathSegArcSweep : public PathSeg
{
public:
	float	m_rx;
	float	m_ry;
	float	m_x_axis_rot;
	bool	m_large;
	bool	m_sweep;
	float	m_tx;
	float	m_ty;
	PathSegArcSweep() : PathSeg( ArcSweep_PathSegType ){}
};
class PathInfo
{
public:
	faffine		m_transform;
	PathSeg*	m_first;
	PathSeg*	m_last;
	PathInfo() : m_first(0) , m_last(0){}
};
class PathNode
{
public:
	PathNodeType		m_type;
	PathNode
		(
		PathNodeType	type
		) : m_type( type ){}
};
class PathNodeExpr : public PathNode
{
public:
	faffine			m_transform;
	PathOperator	m_ope;
	PathNode*		m_left;
	PathNode*		m_right;
	PathNodeExpr() : 
			PathNode( Expr_PathNodeType ) , 
			m_ope( And_PathOperator ) , 
			m_left( 0 ) , 
			m_right( 0 ){}
};
class PathNodeFactor : public PathNode
{
public:
	PathInfo		m_info;
	PathNodeFactor() : 
			PathNode( Factor_PathNodeType ){}
};
class PathLogicInfo
{
public:
	faffine		m_transform;
	PathNode*	m_node;
	PathLogicInfo() : m_node( 0 ){}
};
#pragma pack( pop )			//release align

/**************************************************************************************************
 "IPathLogicInfo" interface 
***************************************************************************************************/
cb_guid_define( IPathLogicInfo_IID , 0xECA45DAD , 0x4E85491e , 0x9AD2FB43 , 0xBF739B6B );
class IPathLogicInfo;
typedef icubic::iface_object< IPathLogicInfo , IPathLogicInfo_IID >		iPathLogicInfo;
typedef icubic::iface_reference< IPathLogicInfo , IPathLogicInfo_IID >	rPathLogicInfo;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPathLogicInfo
{
public:
//=================================================================================================
//!	get path info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
const PathLogicInfo* cb_call GetPathLogicInfo() = 0;
};

/**************************************************************************************************
 "IPathInfo" interface 
***************************************************************************************************/
cb_guid_define( IPathInfo_IID , 0xF0F8C1F5 , 0x9D4E4922 , 0xBA9D2D50 , 0xD6FFCBBB );
class IPathInfo;
typedef icubic::iface_object< IPathInfo , IPathInfo_IID >		iPathInfo;
typedef icubic::iface_reference< IPathInfo , IPathInfo_IID >	rPathInfo;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPathInfo : public IPathLogicInfo
{
public:
//=================================================================================================
//!	get path info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
const PathInfo* cb_call GetPathInfo() = 0;
};

/**************************************************************************************************
 "IPathTo" interface 
***************************************************************************************************/
cb_guid_define( IPathTo_IID , 0x66ACC64A , 0xAC3A4f05 , 0x8A99B3A3 , 0xF0934DD1 );
class IPathTo;
typedef icubic::iface_object< IPathTo , IPathTo_IID >		iPathTo;
typedef icubic::iface_reference< IPathTo , IPathTo_IID >	rPathTo;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPathTo
{
public:
//=================================================================================================
//!	move
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Move
		(
		const fvector2&		pos , 
		const faffine&		transform , 
		bool				close
		) = 0;
//=================================================================================================
//!	move
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Move
		(
		int				pntnum , 
		const float*	pnt , 		//!< [in] sx , sy
		const faffine&	transform , 
		bool			close
		) = 0;
//=================================================================================================
//!	Line
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Line
		(
		const fvector2&		tp
		) = 0;
//=================================================================================================
//!	Line
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Line
		(
		int					pntnum , 
		const fvector2*		pnt			//!< [in] tp,tp,...
		) = 0;
//=================================================================================================
//!	Line
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Line
		(
		int				pntnum , 
		const float*	pnt				//!< [in] tx , ty , ...
		) = 0;
//=================================================================================================
//!	BezierQ
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call BezierQ
		(
		const fvector2&		hp , 
		const fvector2&		tp
		) = 0;
//=================================================================================================
//!	BezierQ
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call BezierQ
		(
		int				pntnum , 
		const fvector2*	pnt			//!< [in] hp , tp , ...
		) = 0;
//=================================================================================================
//!	BezierQ
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call BezierQ
		(
		int				pntnum , 
		const float*	pnt		//!< [in] hx , hy , tx , ty...
		) = 0;
//=================================================================================================
//!	BezierC
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call BezierC
		(
		const fvector2&		h0p , 
		const fvector2&		h1p , 
		const fvector2&		tp
		) = 0;
//=================================================================================================
//!	BezierC
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call BezierC
		(
		int					pntnum , 
		const fvector2*		pnt			//!< [in] h0p , h1p , tp , ...
		) = 0;
//=================================================================================================
//!	BezierC
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call BezierC
		(
		int				pntnum , 
		const float*	pnt		//!< [in] h0x , h0y , h1x , h1y , tx , ty...
		) = 0;
//=================================================================================================
//!	Arc
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Arc
		(
		const fvector2&		cp , 
		float				dy , 
		float				angle
		) = 0;
//=================================================================================================
//!	Arc
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Arc
		(
		float				rx , 
		float				ry , 
		float				x_axis_rot , 
		bool				large , 
		bool				sweep , 
		const fvector2&		tp
		) = 0;
};
/**************************************************************************************************
 "IPath" interface 
***************************************************************************************************/
cb_guid_define( IPath_IID , 0x2DF61383 , 0x3E9B47af , 0x890FA5B5 , 0xA0D27E62 );
class IPath;
typedef icubic::iface_object< IPath , IPath_IID >	iPath;
typedef icubic::iface_reference< IPath , IPath_IID >	rPath;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPath : public IPathTo , public IPathInfo
{
public:
//=================================================================================================
//!	reset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Reset() = 0;
//=================================================================================================
//!	copy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Copy
		(
		IPathInfo*	src
		) = 0;
//=================================================================================================
//!	set affine
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call MulTransform
		(
		const faffine&	affine
		) = 0;
//=================================================================================================
//!	get affine
//!	@retval			---
//-------------------------------------------------------------------------------------------------
/*
virtual
faffine cb_call GetTransform()const = 0;
*/
//=================================================================================================
//!	reset affine
//!	@retval			---
//-------------------------------------------------------------------------------------------------
/*
virtual
void cb_call ResetTransform() = 0;
*/
};

/**************************************************************************************************
 "IPathLogic" interface 
***************************************************************************************************/
cb_guid_define( IPathLogic_IID , 0x3AF1D6C1 , 0xA36B4d04 , 0xBF8BD777 , 0x7022774D );
class IPathLogic;
typedef icubic::iface_object< IPathLogic , IPathLogic_IID >		iPathLogic;
typedef icubic::iface_reference< IPathLogic , IPathLogic_IID >	rPathLogic;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPathLogic : public IPathTo , public IPathLogicInfo
{
public:
//=================================================================================================
//!	reset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Reset() = 0;
//=================================================================================================
//!	copy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Copy
		(
		IPathLogicInfo*	src
		) = 0;
//=================================================================================================
//!	logic
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Operate
		(
		PathOperator		ope , 
		IPathLogicInfo*		src , 
		const faffine&		affine
		) = 0;
//=================================================================================================
//!	set affine
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call MulTransform
		(
		const faffine&	affine
		) = 0;
//=================================================================================================
//!	get affine
//!	@retval			---
//-------------------------------------------------------------------------------------------------
/*
virtual
faffine cb_call GetTransform()const = 0;
*/
//=================================================================================================
//!	reset affine
//!	@retval			---
//-------------------------------------------------------------------------------------------------
/*
virtual
void cb_call ResetTransform() = 0;
*/
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
