/*************************************************************************************************/
/*!
   	@file		PaintTexture.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iPaint.h"
#include	"iFace/iTexture.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PaintTexture_bs" class 
**************************************************************************************************/
template<class t_interface>
class PaintTexture_bs : 
	public t_interface
{
// variable member
protected:
	iTexture	m_gen;
	faffine		m_transform;
	faffine		m_dtouv;

// "IPaint" interface functions
public:
//=================================================================================================
IPaint::Type cb_call PaintType()
{
	return ( ITexture::Color == m_gen->TextureType() ) ? IPaint::Color : IPaint::Image;
}
//=================================================================================================
rgba cb_call PaintColor()
{
	return m_gen->TextureColor();
}
//=================================================================================================
pixelformat	cb_call PaintImageFormat()
{
	return m_gen->TextureImageFormat();
}
//=================================================================================================
bool cb_call BeginPaintImage()
{
	if( m_gen == false )
		return false;
	isize	size = m_gen->TextureSize();
	if( size.width == 0 || size.height == 0 )
		return false;
	DPI		dpi	= m_gen->TextureDPI();
	m_dtouv	= faffine::GetScale( 1.0f / size.width , 1.0f / size.height ) * m_transform;;
	return m_gen->BeginTextureImage();
}
//=================================================================================================
void cb_call PaintImage
		(
		void				*image , 
		int					len , 
		const fvector2&		x , 
		const fvector2&		y
		)
{
	m_gen->TextureImage( image , len , m_dtouv.Transform( x ) , m_dtouv.Transform( y ) );
}
//=================================================================================================
void cb_call EndPaintImage()
{
	m_gen->EndTextureImage();
}

// "IPaintTexture" interface functions
public:
//=================================================================================================
void cb_call SetTexture
		(
		iTexture	&gen
		)
{
	m_gen	= gen;
}
//=================================================================================================
void cb_call ReleaseTexture()
{
	m_gen.release();
}
//=================================================================================================
void cb_call SetTransform
		(
		const faffine&		trans
		)
{
	m_transform	= trans;
}
//=================================================================================================
faffine cb_call GetTransform()const
{
	return m_transform;
}
};
/**************************************************************************************************
"PaintTexture" class 
**************************************************************************************************/
class PaintTexture : 
	public PaintTexture_bs<IPaintTexture> , 
	virtual public object_base
{
// query
	query_begin();
	iface_hook( IPaint , IPaint_IID )
	iface_hook( IPaintTexture , IPaintTexture_IID )
	query_end( object_base );
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
