/*************************************************************************************************/
/*!
   	@file		PaintGradLinear.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iPaint.h"
#include	"NormTable.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PaintGradLinear" class 
**************************************************************************************************/
template<class t_interface>
class PaintGradLinear_bs : 
	public t_interface
{
// member class
private:
	class ColorTbl
	{
	public:
		float	m_rate;
		rgba	m_color;
		bool operator<
			(
			const ColorTbl&	obj
			)const
		{
			if( m_rate < obj.m_rate )
				return true;
			return false;
		}
		bool operator>
			(
			const ColorTbl&	obj
			)const
		{
			if( m_rate > obj.m_rate )
				return true;
			return false;
		}
	};

// variable member
private:
	// param
	fvector2				m_start_pos;
	fvector2				m_target_pos;
	iNormTable_f			m_blendtbl;
	faffine					m_transform;
	
	// calc
	Array<ColorTbl>			m_calc_colortbl;
	Array<ColorTbl>			m_colortbl;
	fvector2				m_calc_vec_unit_mrl;
	
	// render
	pixelformat				m_destformat;
	
// private functions
private:
//=================================================================================================
//!	get blendtbl
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const float* GetBlendTbl()
{
	if( m_blendtbl == false )
		return TableLinearR_f();
	return m_blendtbl->GetNormTable();
}
//=================================================================================================
//!	x to offset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float ToL
		(
		const fvector2&		pos
		)const
{
	return ( pos - m_start_pos ).Inner( m_calc_vec_unit_mrl );
}
//=================================================================================================
//!	x to offset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float ToL
		(
		float		ls , 
		float		lt , 
		int			len , 
		float		x
		)const
{
	return ( lt - ls ) * x / len + ls;
}
//=================================================================================================
//!	offset to x
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float ToX
		(
		float		ls , 
		float		lt , 
		int			len , 
		float		l
		)
{
	return len * ( l - ls ) / ( lt - ls );
}
//=================================================================================================
//!	fx to x
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int ToIntX
		(
		float		fx , 
		int			len
		)
{
	int	x = ( int )floorf( fx + 0.5f );
	return x < len ? x : len;
}
//=================================================================================================
//!	and
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool ClipP
		(
		float		ls , 
		float		lt ,
		float		cs , 
		float		ct ,  
		int			len , 
		int*		x
		)
{
	if( ct <= ls )
		return false;
	if( cs >= lt )
		return false;
		
	if( lt <= ct )
		*x	= len;
	else
		*x	= ToIntX( ToX( ls , lt , len , ct ) , len );
	return true;
}
//=================================================================================================
//!	and
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool ClipM
		(
		float		ls , 
		float		lt ,
		float		cs , 
		float		ct ,  
		int			len , 
		int*		x
		)
{
	if( ct >= ls )
		return false;
	if( cs <= lt )
		return false;
		
	if( lt >= ct )
		*x	= len;
	else
		*x	= ToIntX( ToX( ls , lt , len , ct ) , len );
	return true;
}
//=================================================================================================
//!	render
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void RenderE
		(
		pixelformat			format , 
		void				*image , 
		int					len , 
		float				ls
		)
{
	// initialize	
	int			pixbyte	= get_pixel_byte( format );
	uint8*		pixel	= ( uint8* )image;
	int			tblnum	= m_calc_colortbl.GetDatanum();
	ColorTbl	*cs		= &m_calc_colortbl[0];
	ColorTbl	*ce		= &m_calc_colortbl[tblnum-1];
	if( ls <= cs->m_rate || tblnum == 1 )
	{
		pp_blender_onezero_c( to_pp_format( format ) , pixel , len , to_pp_color( cs->m_color ) );
		return;
	}
	else if( ls >= ce->m_rate )
	{
		pp_blender_onezero_c( to_pp_format( format ) , pixel , len , to_pp_color( ce->m_color ) );
		return;
	}
	// center
	const float*	blendtbl = GetBlendTbl();
	ColorTbl	*c = cs;
	c++;
	int		tbloff;
	for( tbloff = 1 ; tbloff < tblnum ; tbloff++ )
	{
		float	dl	= c->m_rate - (c-1)->m_rate;
		if( (c-1)->m_rate <= ls && ls <=c->m_rate && dl != 0.0f )
		{
			float	st	= ( ls - (c-1)->m_rate ) / dl;
			pp_gradation_linear_f( to_pp_format( format ) , pixel , len , to_pp_color( (c-1)->m_color ) , to_pp_color( c->m_color ) , st , st , blendtbl );
		}
		c++;
	}
}
//=================================================================================================
//!	render
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void RenderP
		(
		pixelformat			format , 
		void				*image , 
		int					len , 
		float				ls , 
		float				lt
		)
{
	// initialize	
	int			pixbyte	= get_pixel_byte( format );
	uint8*		pixel	= ( uint8* )image;
	int			tblnum	= m_calc_colortbl.GetDatanum();
	ColorTbl	*cs		= &m_calc_colortbl[0];
	ColorTbl	*ce		= &m_calc_colortbl[tblnum-1];
	if( lt <= cs->m_rate || tblnum == 1 )
	{
		pp_blender_onezero_c( to_pp_format( format ) , pixel , len , to_pp_color( cs->m_color ) );
		return;
	}
	else if( ls >= ce->m_rate )
	{
		pp_blender_onezero_c( to_pp_format( format ) , pixel , len , to_pp_color( ce->m_color ) );
		return;
	}

	// start
	ColorTbl	*c = cs;
	int			sx = 0;
	if( ls < c->m_rate && c->m_rate <= lt )
	{
		float	ftx	= ToX( ls , lt , len , c->m_rate );
		int		tx	= ToIntX( ftx , len );
		if( sx < tx )
		{
			pp_blender_onezero_c( to_pp_format( format ) , pixel + pixbyte * sx , tx - sx , to_pp_color( c->m_color ) );
			sx	= tx;
		}
	}
	// center
	const float*	blendtbl = GetBlendTbl();
	c++;
	int		tbloff;
	for( tbloff = 1 ; tbloff < tblnum ; tbloff++ )
	{
		int		tx;
		if( true == ClipP( ls , lt , (c-1)->m_rate , c->m_rate , len , &tx ) )
		{
			float	dl	= c->m_rate - (c-1)->m_rate;
			if( sx < tx && dl != 0.0f )
			{
				float	st	= ( ToL( ls , lt , len , (float)sx + 0.5f ) - (c-1)->m_rate ) / dl;
				float	tt	= ( ToL( ls , lt , len , (float)tx - 0.5f ) - (c-1)->m_rate ) / dl;
				pp_gradation_linear_f( to_pp_format( format ) , pixel + pixbyte * sx , tx-sx , to_pp_color( (c-1)->m_color ) , to_pp_color( c->m_color ) , st , tt , blendtbl );
				sx = tx;
			}
		}
		c++;
	}
	// last
	if( sx < len )
		pp_blender_onezero_c( to_pp_format( format ) , pixel + pixbyte * sx , len - sx , to_pp_color( ce->m_color ) );
}
//=================================================================================================
//!	render
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void RenderM
		(
		pixelformat			format , 
		void				*image , 
		int					len , 
		float				ls , 
		float				lt
		)
{
	// initialize	
	int			pixbyte	= get_pixel_byte( format );
	uint8*		pixel	= ( uint8* )image;
	int			tblnum	= m_calc_colortbl.GetDatanum();
	ColorTbl	*cs		= &m_calc_colortbl[tblnum-1];
	ColorTbl	*ce		= &m_calc_colortbl[0];
	if( lt >= cs->m_rate || tblnum == 1 )
	{
		pp_blender_onezero_c( to_pp_format( format ) , pixel , len , to_pp_color( cs->m_color ) );
		return;
	}
	else if( ls <= ce->m_rate )
	{
		pp_blender_onezero_c( to_pp_format( format ) , pixel , len , to_pp_color( ce->m_color ) );
		return;
	}

	// start
	ColorTbl	*c = cs;
	int			sx = 0;
	if( lt < c->m_rate && c->m_rate <= ls )
	{
		float	ftx	= ToX( ls , lt , len , c->m_rate );
		int		tx	= ToIntX( ftx , len );
		if( sx < tx )
		{
			pp_blender_onezero_c( to_pp_format( format ) , pixel + pixbyte * sx , tx - sx , to_pp_color( c->m_color ) );
			sx	= tx;
		}
	}
	// center
	c--;
	const float*	blendtbl = GetBlendTbl();
	int		tbloff;
	for( tbloff = 1 ; tbloff < tblnum ; tbloff++ )
	{
		int		tx;
		if( true == ClipM( ls , lt , (c+1)->m_rate , c->m_rate , len , &tx ) )
		{
			float	dl	= c->m_rate - (c+1)->m_rate;
			if( sx < tx && dl != 0.0f )
			{
				float	st	= ( ToL( ls , lt , len , (float)sx + 0.5f ) - (c+1)->m_rate ) / dl;
				float	tt	= ( ToL( ls , lt , len , (float)tx - 0.5f ) - (c+1)->m_rate ) / dl;
				pp_gradation_linear_f( to_pp_format( format ) , pixel + pixbyte * sx , tx-sx , to_pp_color( (c+1)->m_color ) , to_pp_color( c->m_color ) , st , tt , blendtbl );
				sx = tx;
			}
		}
		c--;
	}
	// last
	if( sx < len )
		pp_blender_onezero_c( to_pp_format( format ) , pixel + pixbyte * sx , len - sx , to_pp_color( ce->m_color ) );
}
// "IPaint" interface functions
public:
//=================================================================================================
IPaint::Type cb_call PaintType()
{
	return IPaint::Image;
}
//=================================================================================================
rgba cb_call PaintColor()
{
	return rgba();
}
//=================================================================================================
pixelformat	cb_call PaintImageFormat()
{
	return m_destformat;
}
//=================================================================================================
bool cb_call BeginPaintImage()
{
	return true;
}
//=================================================================================================
void cb_call PaintImage
		(
		void				*image , 
		int					len , 
		const fvector2&		sp , 
		const fvector2&		tp
		)
{
	float	ls		= ToL( m_transform.Transform(sp) );
	float	lt		= ToL( m_transform.Transform(tp) );
	
	if( ls == lt )
		RenderE( m_destformat , image , len , ls );
	else if( ls < lt )
		RenderP( m_destformat , image , len , ls , lt );
	else if( ls > lt )
		RenderM( m_destformat , image , len , ls , lt );
}
//=================================================================================================
void cb_call EndPaintImage()
{
}
// "IPaintGradLinear" interface functions
public:
//=================================================================================================
void cb_call SetTransform
		(
		const faffine&	trans
		)
{
	m_transform	= trans;
}
//=================================================================================================
faffine cb_call GetTransform()
{
	return m_transform;
}
//=================================================================================================
bool cb_call SetGradationVector
		(
		const fvector2	&start_pos , 
		const fvector2	&target_pos
		)
{
	if( start_pos == target_pos )
		return false;
	m_start_pos		= start_pos;
	m_target_pos	= target_pos;
	
	fvector2	vec		= m_target_pos - m_start_pos;
	float		l		= vec.Length();
	m_calc_vec_unit_mrl	= vec / l / l;
	return true;
}
//=================================================================================================
void cb_call GetGradationVector
		(
		fvector2*	start , 
		fvector2*	target
		)
{
	if( start != 0 )	*start	= m_start_pos;
	if( target != 0 )	*target = m_target_pos;
}
//=================================================================================================
bool cb_call SetColorTable
		(
		int			num , 
		const float	rate[] ,		//!< [in] it need to be 0.0 - 1.0
		const rgba	color[]
		)
{
	if( num <= 1 )
		return false;
		
	m_calc_colortbl.Resize( num );
	m_colortbl.Resize( num );
	int		off;
	for( off = 0 ; off < num ; off++ )
	{
		m_colortbl[ off ].m_rate	= rate[ off ];
		m_colortbl[ off ].m_color	= color[ off ];
		m_calc_colortbl[ off ].m_rate	= rate[ off ];
		m_calc_colortbl[ off ].m_color	= color[ off ];
	}
	BubbleSort( m_calc_colortbl.GetPtr() , num );

	return true;
}
//=================================================================================================
int cb_call GetColorTableNum()
{
	return m_colortbl.GetDatanum();
}
//=================================================================================================
void cb_call GetColorTable
		(
		float	rate[] , 
		rgba	color[]
		)
{
	int		off , num = m_colortbl.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		rate[off]	= m_colortbl[off].m_rate;
		color[off]	= m_colortbl[off].m_color;
	}
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PaintGradLinear_bs() : m_destformat( rgba_pixelformat )
{
	float	rate[] = { 0.0f , 1.0f };
	rgba	color[] = { rgba( 255 , 0 , 0 ) , rgba( 255 , 255 , 255 ) };
	SetColorTable( sizeof( rate ) / sizeof( rate[ 0 ] ) , rate , color );
//	SetGradationVector( fvector2( 50.0f , 0.0f ) , fvector2( 60.0f , 0.0f ) );
//	SetGradationVector( fvector2( 50.0f , 50.0f ) , fvector2( 51.0f , 51.0f ) );
	SetGradationVector( fvector2( 0.0f , 0.0f ) , fvector2( 100.0f , 100.0f ) );
	
}
//=================================================================================================
//!	set interpolate table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetInterpolateTable
		(
		iNormTable_f&		interpolate_tbl
		)
{
	if( interpolate_tbl == false )
		return;
	m_blendtbl	= interpolate_tbl;
}
};
/**************************************************************************************************
"PaintGradLinear" class 
**************************************************************************************************/
class PaintGradLinear : 
	public PaintGradLinear_bs<IPaintGradLinear> , 
	virtual public object_base 
{
// query
	query_begin();
	iface_hook( IPaint , IPaint_IID )
	iface_hook( IPaintGradLinear , IPaintGradLinear_IID )
	query_end( object_base );
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
