/*************************************************************************************************/
/*!
   	@file		GraphicsUnit.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"value_ip" class 
**************************************************************************************************/
class value_ip
{
public:
	enum Unit
	{
		inch = 0 ,	
		px , 
	};
	float	m_value;
	Unit	m_unit;
	
//=================================================================================================
value_ip() : 
		m_value( 0.0f ) , 
		m_unit( inch )
{
}
//=================================================================================================
value_ip
		(
		Unit	unit , 
		float	value
		) : m_unit( unit ) , m_value( value )
{
}
};
/**************************************************************************************************
"value_ipl" class 
**************************************************************************************************/
class value_ipl
{
public:
	enum Unit
	{
		inch = 0 ,	
		px , 
		logical , 
	};
	float	m_value;
	Unit	m_unit;
	
//=================================================================================================
value_ipl() : 
		m_value( 0.0f ) , 
		m_unit( logical )
{
}
//=================================================================================================
value_ipl
		(
		Unit	unit , 
		float	value
		) : m_unit( unit ) , m_value( value )
{
}
};
/**************************************************************************************************
"value_iplr" class 
**************************************************************************************************/
class value_iplr
{
public:
	enum  Unit
	{
		inch = 0 ,	
		px , 
		logical , 
		ratio , 
	};
	float	m_value;
	Unit	m_unit;
	
//=================================================================================================
value_iplr() : 
		m_value( 0.0f ) , 
		m_unit( logical )
{
}
//=================================================================================================
value_iplr
		(
		Unit	unit , 
		float	value
		) : m_unit( unit ) , m_value( value )
{
}
};
/**************************************************************************************************
"value_ipr" class 
**************************************************************************************************/
class value_ipr
{
public:
	enum  Unit
	{
		inch = 0 ,	
		px , 
		ratio , 
	};
	float	m_value;
	Unit	m_unit;
	
//=================================================================================================
value_ipr() : 
		m_value( 0.0f ) , 
		m_unit( px )
{
}
//=================================================================================================
value_ipr
		(
		Unit	unit , 
		float	value
		) : m_unit( unit ) , m_value( value )
{
}
};
/**************************************************************************************************
"t_unit_v" class 
**************************************************************************************************/
template<class t_value>
class t_unit_v
{
public:
	t_value		x , y;

//=================================================================================================
t_unit_v()
{
}
//=================================================================================================
t_unit_v
		(
		const t_value&	xx , 
		const t_value&	yy
		) : 
		x( xx ) , 
		y( yy )
{
}
//=================================================================================================
t_unit_v
		(
		typename t_value::Unit	unit , 
		float					x , 
		float					y
		) : 
		x( unit , x ) , 
		y( unit , y )
{
}
};
typedef t_unit_v<value_ip>		unit_ip;

/**************************************************************************************************
"t_point_v" class 
**************************************************************************************************/
template<class t_value>
class t_point_v
{
public:
	t_value		x , y;

//=================================================================================================
t_point_v()
{
}
//=================================================================================================
t_point_v
		(
		typename t_value::Unit	unit , 
		const fvector2&			r
		) : 
		x( unit , r.x ) , 
		y( unit , r.y )
{
}
//=================================================================================================
t_point_v
		(
		const t_value&	xx , 
		const t_value&	yy
		) : 
		x( xx ) , 
		y( yy )
{
}
};
typedef t_point_v<value_iplr>	point_iplr;
typedef t_point_v<value_ipr>	point_ipr;
typedef t_point_v<value_ip>		point_ip;

/**************************************************************************************************
"t_points_v" class 
**************************************************************************************************/
template<class t_value>
class t_points_v
{
private:
	Array<t_point_v<t_value>>	m_points;
	
public:
//=================================================================================================
t_points_v()
{
}
//=================================================================================================
t_points_v
		(
		const t_points_v<t_value>&	obj
		) : m_points( obj.GetPointnum() )
{
	int		off , num = obj.GetPointnum();
	for( off = 0 ; off < num ; off++ )
		m_points[ off ] = obj[ off ];
}
//=================================================================================================
t_points_v
		(
		typename t_value::Unit	unit , 
		int						num , 
		const fvector2*			pnt
		) : m_points( num )
{
	int		off;
	for( off = 0 ; off < num ; off++ )
		m_points[off]	= t_point_v<t_value>( unit , pnt[off] );
}
//=================================================================================================
t_points_v
		(
		int						num , 
		const t_point_v<t_value>*	pnt
		) : m_points( num )
{
	int		off;
	for( off = 0 ; off < num ; off++ )
		m_points[off]	= pnt[off];
}
//=================================================================================================
t_points_v<t_value>& operator=
		(
		const t_points_v<t_value>& obj
		)
{
	int		off , num = obj.GetPointnum();
	m_points.Resize( num );
	for( off = 0 ; off < num ; off++ )
		m_points[ off ] = obj[ off ];
	return *this;
}
//=================================================================================================
t_point_v<t_value>& operator[]
		(
		int		n
		)
{
	return m_points[ n ];
}
//=================================================================================================
const t_point_v<t_value>& operator[]
		(
		int		n
		)const
{
	return m_points[ n ];
}
//=================================================================================================
void SetPointnum
		(
		int		num
		)
{
	m_points.Resize( num );
}
//=================================================================================================
int GetPointnum()const
{
	return m_points.GetDatanum();
}
//=================================================================================================
const t_point_v<t_value>* GetPtr()const
{
	return m_points.GetPtr();
}
//=================================================================================================
void SetPoints
		(
		typename t_value::Unit	unit , 
		int						num , 
		const fvector2*			pnt
		)
{
	int		off;
	m_points.Resize( num );
	for( off = 0 ; off < num ; off++ )
		m_points[off]	= t_point_v<t_value>( unit , pnt[off] );
}
//=================================================================================================
void SetPoints
		(
		int							num , 
		const t_point_v<t_value>*	pnt
		)
{
	int		off;
	m_points.Resize( num );
	for( off = 0 ; off < num ; off++ )
		m_points[off]	= pnt[off];
}
};
typedef t_points_v<value_ipr>	points_ipr;
typedef t_points_v<value_ip>	points_ip;

/**************************************************************************************************
"t_size_v" class 
**************************************************************************************************/
template<class t_value>
class t_size_v
{
public:
	t_value		width , height;
	
//=================================================================================================
t_size_v()
{
}
//=================================================================================================
t_size_v
		(
		typename t_value::Unit	unit , 
		const fsize&			r
		) : 
		width( unit , r.width ) , 
		height( unit , r.height )
{
}
//=================================================================================================
t_size_v
		(
		const t_value&	xx , 
		const t_value&	yy
		) : 
		x( xx ) , 
		y( yy )
{
}
};
typedef t_size_v<value_ip>		size_ip;

/**************************************************************************************************
"t_rect_v" class 
**************************************************************************************************/
template<class t_value>
class t_rect_v
{
public:
	t_value		x , y , w , h;

//=================================================================================================
t_rect_v()
{
}
//=================================================================================================
t_rect_v
		(
		typename t_value::Unit	unit , 
		const frect&			r
		)
{
	frect	n = r.Normalize();
	x	= t_value( unit , n.xmin );
	y	= t_value( unit , n.ymin );
	w	= t_value( unit , n.xmax - n.xmin );
	h	= t_value( unit , n.ymax - n.ymin );
}
//=================================================================================================
t_rect_v
		(
		const t_value&	xx , 
		const t_value&	yy , 
		const t_value&	ww , 
		const t_value&	hh
		) : 
		x( xx ) , 
		y( yy ) , 
		w( ww ) , 
		h( hh )
{
}
};
typedef t_rect_v<value_iplr>	rect_iplr;
typedef t_rect_v<value_ipr>		rect_ipr;

/**************************************************************************************************
"DPI" class 
**************************************************************************************************/
class DPI
{
public:
	enum Device
	{
		Display , 
	};
// variable member
private:
	float		m_dpi[2];
	
// private functions
private:
//=================================================================================================
float Clip
		(
		float	dpi
		)
{
	return max( dpi , 0.0f );
}
// public functions
public:
//=================================================================================================
DPI
		(
		Device	type = Display
		)
{
	SetDPI( type );
}
//=================================================================================================
DPI
		(
		const DPI&	obj
		)
{
	m_dpi[0]	= obj.m_dpi[0];
	m_dpi[1]	= obj.m_dpi[1];
}
//=================================================================================================
DPI
		(
		float	dpi_x , 
		float	dpi_y
		)
{
	SetDPI( dpi_x , dpi_y );
}
//=================================================================================================
bool operator==
		(
		const DPI&	obj
		)const
{
	if( m_dpi[0] != obj.m_dpi[0] )
		return false;
	if( m_dpi[1] != obj.m_dpi[1] )
		return false;
	return true;
}
//=================================================================================================
bool operator!=
		(
		const DPI&	obj
		)const
{
	if( *this == obj )
		return false;
	return true;
}
//=================================================================================================
float operator[]
		(
		int		n
		)const
{
	if( n <= 0 )
		return m_dpi[0];
	else
		return m_dpi[1];
}
//=================================================================================================
void SetDPI
		(
		Device	type
		)
{
	if( type == Display )
	{
#ifdef cb_windows
		HDC		hdc	= ::GetDC( NULL );
		m_dpi[0]	= (float)::GetDeviceCaps( hdc , LOGPIXELSX );
		m_dpi[1]	= (float)::GetDeviceCaps( hdc , LOGPIXELSY );
		::ReleaseDC( NULL , hdc );
#else
	#error	Unknown os
#endif
	}
}
//=================================================================================================
void SetDPI
		(
		float	dpi_x , 
		float	dpi_y
		)
{
	m_dpi[0]	= Clip( dpi_x );
	m_dpi[1]	= Clip( dpi_y );
}
//=================================================================================================
float SetDPI_x
		(
		float	dpi_x
		)
{
	m_dpi[0]	= Clip( dpi_x );
	return m_dpi[0];
}
//=================================================================================================
float SetDPI_y
		(
		float	dpi_y
		)
{
	m_dpi[1]	= Clip( dpi_y );
	return m_dpi[1];
}
//=================================================================================================
float GetDPI_x()const
{
	return m_dpi[0];
}
//=================================================================================================
float GetDPI_y()const
{
	return m_dpi[1];
}
//=================================================================================================
float		ItoD_x( float	x )const						{ return m_dpi[0] * x; }
float		ItoD_y( float	y )const						{ return m_dpi[1] * y; }
fvector2	ItoD( const fvector2& p )const					{ return fvector2( ItoD_x( p.x ) , ItoD_y( p.y ) ); }
fsize		ItoD( const fsize& p )const						{ return fsize( ItoD_x( p.width ) , ItoD_y( p.height ) ); }
frect		ItoD( const frect& p )const						{ return frect( ItoD( p.Min() ) , ItoD( p.Max() ) ).Normalize(); }
faffine		ItoD_xy()const									{ return faffine::GetScale( m_dpi[0] , m_dpi[1] ); }
//=================================================================================================
float		DtoI_x( float	x )const						{ return x / m_dpi[0]; }
float		DtoI_y( float	y )const						{ return y / m_dpi[1]; }
fvector2	DtoI( const fvector2& p )const					{ return fvector2( DtoI_x( p.x ) , DtoI_y( p.y ) ); }
fsize		DtoI( const fsize& p )const						{ return fsize( DtoI_x( p.width ) , DtoI_y( p.height ) ); }
frect		DtoI( const frect& p )const						{ return frect( DtoI( p.Min() ) , DtoI( p.Max() ) ).Normalize(); }
faffine		DtoI_xy()const									{ return faffine::GetScale( 1.0f/m_dpi[0] , 1.0f/m_dpi[1] ); }
//=================================================================================================
float		DtoD_x( const DPI& dpi , float x )const			{ return ( *this == dpi ) ? x : ( ( m_dpi[0] * x ) / dpi.m_dpi[0] ); }
float		DtoD_y( const DPI& dpi , float y )const			{ return ( *this == dpi ) ? y : ( ( m_dpi[1] * y ) / dpi.m_dpi[1] ); }
fvector2	DtoD( const DPI& dpi , const fvector2& p )const	{ return fvector2( DtoD_x( dpi , p.x ) , DtoD_y( dpi , p.y ) ); }
fsize		DtoD( const DPI& dpi , const fsize& p )const	{ return fsize( DtoD_x( dpi , p.width ) , DtoD_y( dpi , p.height ) ); }
frect		DtoD( const DPI& dpi , const frect& p )const	{ return frect( DtoD( dpi , p.Min() ) , DtoD( dpi , p.Max() ) ).Normalize(); }
faffine		DtoD_xy( const DPI& dpi )const					{ return (*this == dpi ) ? faffine() : faffine::GetScale( m_dpi[0] / dpi.m_dpi[0] , m_dpi[1] / dpi.m_dpi[1] ); }
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
