/*************************************************************************************************/
/*!
   	@file		Graphics.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iGraphicsCmds.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"GraphicsCmds" class 
**************************************************************************************************/
class GraphicsCmds_bs : public IGraphicsCmds
{
protected:
	class CmdSeg : public IGraphicsCmdsInfo::CmdSeg
	{
	public:
		iGraphicsCmd	m_cmd_obj;
	};
// variable member
protected:
	IGraphicsCmdsInfo::Info			m_info;
	IGraphicsCmdsInfo::CmdSeg*		m_last;
	
// "IGraphicsCmdsInfo" interface functions
//=================================================================================================
const IGraphicsCmdsInfo::Info* cb_call GetGraphicsCmdsInfo()
{
	return &m_info;
}
// "IGraphicsCmds" interface functions
public:
//=================================================================================================
void cb_call Reset()
{
	IGraphicsCmdsInfo::CmdSeg*	p = m_info.m_first;
	while( p != 0 )
	{
		IGraphicsCmdsInfo::CmdSeg*	n	= p->m_next;
		delete p;
		p	= n;
	}
	m_info.m_first	= 0;
	m_last			= 0;
}
//=================================================================================================
void cb_call AddCmd
		(
		iGraphicsCmd&		cmd
		)
{
	CmdSeg*	seg = new CmdSeg();
	seg->m_cmd_obj	= cmd;
	seg->m_cmd		= cmd.ptr();
	( m_last == 0 ? m_info.m_first : m_last->m_next ) = seg;
	m_last	= seg;
}
// public functions
public:
//=================================================================================================
GraphicsCmds_bs() : m_last( 0 )
{
}
//=================================================================================================
~GraphicsCmds_bs()
{
	Reset();
}
};
/**************************************************************************************************
"GraphicsCmds" class 
**************************************************************************************************/
class GraphicsCmds : 
	public GraphicsCmds_bs , 
	virtual public object_base
{
	query_begin();
	iface_hook( IGraphicsCmds , IGraphicsCmds_IID )
	iface_hook( IGraphicsCmdsInfo , IGraphicsCmdsInfo_IID )
	query_end( object_base );
};

/**************************************************************************************************
"GraphicsCmdsPlayer" class 
**************************************************************************************************/
class GraphicsCmdsPlayer_bs : public IGraphicsCmdsPlayer
{
protected:
	class Attr
	{
	public:
		// coord
		Coord_view				m_coord;
		irect					m_clip_rect;
		iPathLogicInfo			m_clip_view;
		iPathLogicInfo			m_clip;
		iEdgemapOutline			m_clip_edgemap;
		faffine					m_transform;
		antialias				m_antialias;
		
	// public functions
	public:
		//=================================================================================================
		Attr()
		{
		}
		//=================================================================================================
		void Initialize
				(
				const DPI&		dpi , 
				const isize&	size
				)
		{
			m_coord			= Coord_view( faffine() , dpi , frect( size ) );
			m_clip_rect		= frect( size );
			m_clip_view.release();
			m_clip.release();
			m_transform		= faffine();
			m_antialias		= x4_antialias;
		}
	};
	class AttrCmd : public IGraphicsAttrCmd
	{
	private:
		instance<SurfaceDestViewport>	m_surface;
		Stackdata<Attr>						m_stack;
		
		//work
		instance<OutlineGenPaint>		m_outlinegen_paint;
		PathToEdgemap_bs					m_path_to_edgemap;
	
	//"IGraphicsAttrCmd" interface functions
	public:
		//=================================================================================================
		void cb_call PushAttr()
		{
			Attr*	prev = &( *m_stack );
			m_stack.Push();
			( *m_stack ) = ( *prev );
		}
		//=================================================================================================
		void cb_call PopAttr()
		{
			if( m_stack.GetDatanum() <= 1 )
				return;
			m_stack.Pop();
		}
		//=================================================================================================
		antialias cb_call GetAntialias()
		{
			return m_stack->m_antialias;
		}
		//=================================================================================================
		void cb_call SetAntialias
				(
				antialias	anti
				)
		{
			m_stack->m_antialias	= anti;
			m_stack->m_clip_edgemap.release();
		}		
		//=================================================================================================
		iSurfaceDest cb_call GetSurface()
		{
			m_surface->SetClip( m_stack->m_clip_rect );
			return (iSurfaceDest)m_surface;
		}
		//=================================================================================================
		Coord_view cb_call GetCoord()
		{
			return m_stack->m_coord;
		}
		//=================================================================================================
		void cb_call SetCoord
				(
				const faffine&		vtod , 
				const DPI&			dpi , 
				const frect&		view
				)
		{
			m_stack->m_clip_edgemap.release();

			m_stack->m_coord.SetView( vtod , dpi , view );
			faffine	tod		= m_stack->m_coord.GetVtoD();
			frect	v		= m_stack->m_coord.GetView();
			if( tod.m[0][1] == 0.0f && tod.m[1][0] == 0.0f )
			{
				frect	tv	= frect( tod.Transform( v.Min() ) , tod.Transform( v.Max() ) ).Normalize();
				irect	itv	= tv;
				if( (float)itv.xmin == tv.xmin 
				&&  (float)itv.xmax == tv.xmax
				&&  (float)itv.ymin == tv.ymin
				&&  (float)itv.ymax == tv.ymax )
				{
					m_stack->m_clip_rect &= itv;
					return;
				}
			}
			fvector2	pnt[] = 
			{
				tod.Transform( fvector2( v.xmin , v.ymin ) ) , 
				tod.Transform( fvector2( v.xmax , v.ymin ) ) , 
				tod.Transform( fvector2( v.xmax , v.ymax ) ) , 
				tod.Transform( fvector2( v.xmin , v.ymax ) ) , 
			};
			instance<PathLogic>	clip;
			clip->Move( pnt[0] , faffine() , true );
			clip->Line( 3 , &pnt[1] );
			if( m_stack->m_clip_view == true )
				clip->Operate( And_PathOperator , m_stack->m_clip_view , faffine() );
			m_stack->m_clip_view = (iPathLogicInfo)clip;
		}
		//=================================================================================================
		faffine cb_call GetTransform()
		{
			return m_stack->m_transform;
		}
		//=================================================================================================
		void cb_call SetTransform
				(
				const faffine&	trans
				)
		{
			m_stack->m_transform	= m_stack->m_transform * trans;
		}
		//=================================================================================================
		void cb_call SetClip
				(
				IPathLogicInfo*	clip , 
				const faffine&	transform
				)
		{
			instance<PathLogic>	path;
			path->Copy( clip );
			path->MulTransform( m_stack->m_coord.PtoD() * m_stack->m_transform * transform );
			if( m_stack->m_clip == true )
				path->Operate( And_PathOperator , m_stack->m_clip , faffine() );
			m_stack->m_clip	= (iPathLogicInfo)path;
		}
		//=================================================================================================
		void cb_call ReleaseClip()
		{
			if( m_stack->m_clip == false )
				return;
			m_stack->m_clip_edgemap.release();
			m_stack->m_clip.release();
		}
		//=================================================================================================
		iEdgemapOutline GetClip()
		{
			if( m_stack->m_clip_edgemap == true )
				return m_stack->m_clip_edgemap;

			if( m_stack->m_clip == false )
			{
				if( m_stack->m_clip_view == true )
				{
					instance<EdgemapOutline>		edgemap;
					m_outlinegen_paint->SetSampleScale( 1.0f );
					m_path_to_edgemap.ToEdgemap
						(
						(iEdgemapOutline)edgemap , 
						m_stack->m_clip_view , 
						faffine() ,
						(iOutlineGen)m_outlinegen_paint , 
						Winding_PathFillRule , 			
						faffine() , 
						m_surface->GetDestAvailableArea() , 
						m_stack->m_antialias
						);
					m_stack->m_clip_edgemap	= (iEdgemapOutline)edgemap;
				}
			}
			else
			{
				if( m_stack->m_clip_view == false )
				{
					instance<EdgemapOutline>		edgemap;
					m_outlinegen_paint->SetSampleScale( 1.0f );
					m_path_to_edgemap.ToEdgemap
						(
						(iEdgemapOutline)edgemap , 
						m_stack->m_clip , 
						faffine() ,
						(iOutlineGen)m_outlinegen_paint , 
						Winding_PathFillRule , 			
						faffine() , 
						m_surface->GetDestAvailableArea() , 
						m_stack->m_antialias
						);
					m_stack->m_clip_edgemap	= (iEdgemapOutline)edgemap;
				}
				else
				{
					instance<EdgemapOutline>		edgemap;
					m_outlinegen_paint->SetSampleScale( 1.0f );
					m_path_to_edgemap.ToEdgemap
						(
						(iEdgemapOutline)edgemap , 
						m_stack->m_clip , 
						faffine() ,
						(iOutlineGen)m_outlinegen_paint , 
						Winding_PathFillRule , 			
						m_stack->m_clip_view , 
						faffine() , 
						(iOutlineGen)m_outlinegen_paint , 
						Winding_PathFillRule , 			
						faffine() , 
						m_surface->GetDestAvailableArea() , 
						m_stack->m_antialias
						);
					m_stack->m_clip_edgemap	= (iEdgemapOutline)edgemap;
				}
			}
			return m_stack->m_clip_edgemap;
		}
	// public functions	
	public:
		//=================================================================================================
		AttrCmd()
		{
		}
		//=================================================================================================
		void BeginCmd
				(
				iSurfaceDest&	surface , 
				const faffine&	vtod , 
				const DPI&		dpi , 
				const fsize&	view
				)
		{
			m_surface->SetSurface( surface );
			m_stack.Reset();
			m_stack.Push();
			m_stack->Initialize( surface->GetDestDPI() , surface->GetDestSize() );
			SetCoord( vtod , dpi , view );
		}
		//=================================================================================================
		void EndCmd()
		{
			m_surface->ReleaseSurface();
		}
	};

// variable member
protected:
	// surface
	AttrCmd								m_stack;
	
// "IGraphicsCmdsPlayer" interface functions
public:
//=================================================================================================
void cb_call ExecuteCmds
		(
		iSurfaceDest&		surface , 
		const faffine&		vtod , 
		const DPI&			dpi , 
		const fsize&		view , 
		IGraphicsCmdsInfo*	cmds
		)
{
	m_stack.BeginCmd( surface , vtod , dpi , view );
	
	const IGraphicsCmdsInfo::Info*		info	= cmds->GetGraphicsCmdsInfo();
	const IGraphicsCmdsInfo::CmdSeg*	cmd		= info->m_first;
	while( cmd != 0 )
	{
		cmd->m_cmd->ExecuteCmd( &m_stack );
		cmd	= cmd->m_next;
	}

	m_stack.EndCmd();
}
// public functions
public:
//=================================================================================================
GraphicsCmdsPlayer_bs()
{
}
//=================================================================================================
~GraphicsCmdsPlayer_bs()
{
}
};
/**************************************************************************************************
"GraphicsCmdsPlayer" class 
**************************************************************************************************/
class GraphicsCmdsPlayer : 
	public GraphicsCmdsPlayer_bs , 
	virtual public object_base
{
// query
	query_begin();
	iface_hook( IGraphicsCmdsPlayer , IGraphicsCmdsPlayer_IID )
	query_end( object_base );
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
