/*************************************************************************************************/
/*!
   	@file		ConvertPP.h
	@author 	Fanzo
 	@date 		2008/4/24
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iSurface.h"
#include	"iFace/iTexture.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	to pp_format
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
pp_format to_pp_format
		(
		pixelformat		format
		)
{
	return ( pp_format )format;
}
//=================================================================================================
//!	to pp_color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
pp_color to_pp_color
		(
		const rgba&	color
		)
{
	pp_color	t;
	t.r		= (uint16)(( uint32 )color.r * 256 / 255);
	t.g		= (uint16)(( uint32 )color.g * 256 / 255);
	t.b		= (uint16)(( uint32 )color.b * 256 / 255);
	t.a		= (uint16)(( uint32 )color.a * 256 / 255);
	return t;
}
//=================================================================================================
//!	to pp_color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
pp_color to_pp_color
		(
		const rgba&		color , 
		uint8			alpha
		)
{
	pp_color	t;
	t.r		= (uint16)(( uint32 )color.r * 256 / 255);
	t.g		= (uint16)(( uint32 )color.g * 256 / 255);
	t.b		= (uint16)(( uint32 )color.b * 256 / 255);
	t.a		= (uint16)(( uint32 )color.a * ( uint32 )alpha * 256 / ( 255 * 255 ) );
	return t;
}
//=================================================================================================
//!	to pp_color
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
pp_alpha to_pp_alpha
		(
		uint8	alpha
		)
{
	pp_alpha	t;
	t.a		= ( ( uint32 )alpha * 256 / 255 );
	return t;
}
//=================================================================================================
//!	to pp_wrap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
pp_wraptype to_pp_wraptype
		(
		Wraptype	wrap
		)
{
	return ( pp_wraptype )wrap;
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
