/*************************************************************************************************/
/*!
   	@file		blenderonezero.h
	@author 	Fanzo
 	@date 		2008/4/6
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"BlenderOnezero" class 
**************************************************************************************************/
class BlenderOnezero : 
	virtual public object_base , 
	public IBlender
{
// query
	query_begin();
	iface_hook( IBlender , IBlender_IID )
	query_end( object_base );
	
// variable member
private:

// private functions
private:

// "IBlender" interface functions
public:
//=================================================================================================
//!	blend
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call BlendColor
		(
		pixelformat		destformat , 
		void			*dest , 
		int				len , 
		const rgba&	color
		)
{
	pp_blender_onezero_c( to_pp_format( destformat ) , dest , len , to_pp_color( color ) );
}
//=================================================================================================
//!	blend
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call BlendImage
		(
		pixelformat			destformat , 
		void*				dest , 
		pixelformat			srcformat , 
		const void*			src ,
		int					len ,
		const rgba&			color , 
		uint8				alpha
		)
{
	pp_blender_onezero_m( to_pp_format( destformat ) , dest , to_pp_format( srcformat ) , src , len , to_pp_color( color ) , to_pp_alpha( alpha ) );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
BlenderOnezero()
{
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
