/*************************************************************************************************/
/*!
   	@file		object.h
	@author 	Fanzo
 	@date 		2008/2/28
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iObject.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define		query_begin()											\
protected:															\
void* query_oride													\
		(															\
		const icubic::guid &riid									\
		)const														\
{																	

#define		iface_hook( iface_class , iface_guid )					\
	if( riid == iface_guid::get_const() )							\
		return const_cast<iface_class*>( static_cast< const iface_class* >( this ) );

#define		super_hook( SUPER_CLASS )								\
	{																\
		void*	p = SUPER_CLASS::query_oride( riid );				\
		if( p != 0 )												\
			return p;												\
	}

#define		query_null_end()										\
	return 0;														\
}

#define		query_end( SUPER_CLASS )								\
	return SUPER_CLASS::query_oride( riid );						\
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"ClassToObject" class 
**************************************************************************************************/
template<class t_class,class t_iface,class t_iface_iid>
class ClassToObject : 
	virtual public object_base , 
	public t_class
{
	query_begin();
	iface_hook( t_iface , t_iface_iid )
	query_end( object_base );
public:
ClassToObject(){}
};


class reference;

/**************************************************************************************************
"object" class 
**************************************************************************************************/
class object
{
	friend class reference;

// variable member
private:
	iobject_count	*m_counter;
	iobject			*m_object;

// public functions
public:
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
virtual
~object()
{
	if( m_counter == 0 )
		return;
	if( m_counter->dec_object_count() == 0 )
		m_object->delete_object();
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
object() : 
	m_counter( 0 ) , 
	m_object( 0 )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
object
		(
		iobject		*pobject
		) : 
		m_counter( pobject->get_object_count() ) , 
		m_object( pobject )
{
	cb_assert( pobject != 0 , L"initialize zero pointer" );
}
//=================================================================================================
//!	initialize
//-------------------------------------------------------------------------------------------------
void initialize
		(
		iobject		*pobject
		)
{
	cb_assert( pobject != 0 , L"initialize zero pointer" );

	release();
	m_counter	= pobject->get_object_count();
	m_object	= pobject;
}
//=======================================================================
//!	copy construct
//-----------------------------------------------------------------------
object
		(
		const object	&obj
		) : 
		m_counter( 0 ) , 
		m_object( 0 )
{
	if( obj.m_object == 0 )
		return;
	obj.m_counter->inc_object_count();

	m_counter	= obj.m_counter;
	m_object	= obj.m_object;
}
//=======================================================================
//!	query
//-----------------------------------------------------------------------
void* query
		(
		const icubic::guid &guid
		)const
{
	if( m_object == 0 )
		return 0;
	return m_object->query( guid );
}
//=======================================================================
//!	release
//-----------------------------------------------------------------------
void release()
{
	if( m_counter == 0 )
		return;
	if( m_counter->dec_object_count() == 0 )
	{
		m_object->delete_object();
	}
	m_counter	= 0;
	m_object	= 0;
}
//=======================================================================
//!	substitution
//-----------------------------------------------------------------------
object& operator=
		(
		const object& obj
		)
{
	if( obj.m_counter != 0 )
		obj.m_counter->inc_object_count();
	if( m_counter != 0 )
	{
		if( m_counter->dec_object_count() == 0 )
			m_object->delete_object();
	}
	m_counter= obj.m_counter;
	m_object = obj.m_object;

	return *this;
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator==
		(
		bool	b
		)const
{
	return m_counter != 0 ? ( b == true ) : ( b == false );
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator!=
		(
		bool	b
		)const
{
	return m_counter == 0 ? ( b == true ) : ( b == false );
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator==
		(
		const object	&obj
		)const
{
	return m_object == obj.m_object ? true : false;
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator!=
		(
		const object	&obj
		)const
{
	return m_object != obj.m_object ? true : false;
}
};

/**************************************************************************************************
"reference" class 
**************************************************************************************************/
class reference
{
// variable member
private:
	iobject_count	*m_counter;
	iobject			*m_object;

// private functions
private:
// protect functions
protected:
// public functions
public:
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
virtual
~reference()
{
	if( m_counter == 0 )
		return;
	m_counter->release_reference();
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
reference() : 
	m_counter( 0 ) , 
	m_object( 0 )
{
}
//=======================================================================
//!	copy construct
//-----------------------------------------------------------------------
reference
		(
		const reference	&ref
		) : 
		m_counter( 0 ) , 
		m_object( 0 )
{
	if( ref.m_counter == 0 )
		return;
	ref.m_counter->inc_reference_count();

	m_counter	= ref.m_counter;
	m_object	= ref.m_object;
}
//=======================================================================
//!	copy construct
//-----------------------------------------------------------------------
reference
		(
		const object	&obj
		) : 
		m_counter( 0 ) , 
		m_object( 0 )
{
	if( obj.m_counter == 0 )
		return;
	obj.m_counter->inc_reference_count();

	m_counter	= obj.m_counter;
	m_object	= obj.m_object;
}
//=======================================================================
//!	release
//-----------------------------------------------------------------------
void release()
{
	if( m_counter == 0 )
		return;
	m_counter->release_reference();
	m_counter	= 0;
	m_object	= 0;
}
//=================================================================================================
//!	lock object
//!	@retval			---
//-------------------------------------------------------------------------------------------------
object lock()const
{
	if( m_counter == 0 )
		return object();
	if( m_counter->inc_object_count() == 0 )
		return object();
	return object( m_object );
}
//=======================================================================
//!	substitution
//-----------------------------------------------------------------------
reference& operator=
		(
		const reference& ref
		)
{
	if( ref.m_counter != 0 )
		ref.m_counter->inc_reference_count();
	if( m_counter != 0 )
		m_counter->release_reference();

	m_counter= ref.m_counter;
	m_object = ref.m_object;

	return *this;
}
//=======================================================================
//!	substitution
//-----------------------------------------------------------------------
reference& operator=
		(
		const object& obj
		)
{
	if( obj.m_counter != 0 )
		obj.m_counter->inc_reference_count();
	if( m_counter != 0 )
		m_counter->release_reference();

	m_counter= obj.m_counter;
	m_object = obj.m_object;

	return *this;
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator==
		(
		bool	b
		)const
{
	return m_counter != 0 ? ( b == true ) : ( b == false );
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator!=
		(
		bool	b
		)const
{
	return m_counter == 0 ? ( b == true ) : ( b == false );
}
};
/**************************************************************************************************
"iface_object" class 
**************************************************************************************************/
template< class t_iface_name , class t_guid>
class iface_reference;

template< class t_iface_name , class t_guid = icubic::null_guid >
class iface_object
{
	friend iface_reference<t_iface_name,t_guid>;

// variable member
private:
	object			m_object;
	t_iface_name*	m_ptr;

// private functions
private:
// protect functions
protected:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
iface_object() : m_ptr( 0 )
{
}
//=================================================================================================
//!	copy construct
//-------------------------------------------------------------------------------------------------
iface_object
		(
		const iface_object<t_iface_name , t_guid>&	obj
		) : m_object( obj.m_object ) , m_ptr( obj.m_ptr )
{
}
//=================================================================================================
//!	copy construct
//-------------------------------------------------------------------------------------------------
iface_object
		(
		const object&	obj
		) : m_ptr( 0 )
{
	m_ptr	= static_cast<t_iface_name*>( obj.query( t_guid::get_const() ) );
	if( m_ptr != 0 )
		m_object	= obj;
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_iface_name* ptr()
{
	cb_assert( m_ptr != 0 , L"zero pointer accessed." );
	return m_ptr;
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const t_iface_name* ptr()const
{
	cb_assert( m_ptr != 0 , L"zero pointer accessed." );
	return m_ptr;
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_iface_name* operator->()
{
	cb_assert( m_ptr != 0 , L"zero pointer accessed." );
	return m_ptr;
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const t_iface_name* operator->()const
{
	cb_assert( m_ptr != 0 , L"zero pointer accessed." );
	return m_ptr;
}
//=======================================================================
//!	release
//-----------------------------------------------------------------------
void release()
{
	m_object.release();
	m_ptr	= 0;
}
//=======================================================================
//!	substitution
//-----------------------------------------------------------------------
iface_object<t_iface_name , t_guid>& operator=
		(
		const iface_object<t_iface_name , t_guid>&	obj
		)
{
	m_object	= obj.m_object;
	m_ptr		= obj.m_ptr;
	return *this;
}
//=======================================================================
//!	substitution
//-----------------------------------------------------------------------
iface_object<t_iface_name , t_guid>& operator=
		(
		const object&	obj
		)
{
	m_ptr	= static_cast<t_iface_name*>(obj.query( t_guid::get_const() ));
	if( m_ptr != 0 )
		m_object = obj;
	else
		m_object.release();
	return *this;
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator==
		(
		bool	b
		)const
{
	return m_ptr != 0 ? ( b == true ) : ( b == false );
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator!=
		(
		bool	b
		)const
{
	return m_ptr == 0 ? ( b == true ) : ( b == false );
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator==
		(
		const iface_object< t_iface_name , t_guid >&	obj
		)const
{
	return m_object == obj.m_object;
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator!=
		(
		const iface_object< t_iface_name , t_guid >&	obj
		)const
{
	return *this == obj ? false : true;
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
template< class s_iface_name , class s_guid >
bool operator==
		(
		const iface_object< s_iface_name , s_guid >&	obj
		)const
{
	return m_object == (object)obj;
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
template< class s_iface_name , class s_guid >
bool operator!=
		(
		const iface_object< s_iface_name , s_guid >&	obj
		)const
{
	return *this == obj ? false : true;
}
//=================================================================================================
//! cast
//!	@retval			---
//-------------------------------------------------------------------------------------------------
operator object()const
{
	return m_object;
}
//=================================================================================================
//!	cast
//!	@retval			---
//-------------------------------------------------------------------------------------------------
operator t_iface_name*()
{
	cb_assert( m_ptr != 0 , L"zero pointer accessed." );
	return m_ptr;
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
operator const t_iface_name*()const
{
	cb_assert( m_ptr != 0 , L"zero pointer accessed." );
	return m_ptr;
}
};

/**************************************************************************************************
"iface_reference" class 
**************************************************************************************************/
template< class t_iface_name , class t_guid = icubic::null_guid >
class iface_reference
{
// variable member
private:
	reference		m_reference;
	t_iface_name*	m_ptr;

// private functions
private:
// protect functions
protected:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
iface_reference() : m_ptr( 0 )
{
}
//=================================================================================================
//!	copy construct
//-------------------------------------------------------------------------------------------------
iface_reference
		(
		const iface_reference<t_iface_name , t_guid>&	obj
		) : m_reference( obj.m_reference ) , m_ptr( obj.m_ptr )
{
}
//=================================================================================================
//!	copy construct
//-------------------------------------------------------------------------------------------------
iface_reference
		(
		const object&	obj
		) : m_ptr( 0 )
{
	m_ptr	= static_cast<t_iface_name*>( obj.query( t_guid::get_const() ) );
	if( m_ptr != 0 )
		m_reference	= obj;
}
//=================================================================================================
//!	copy construct
//-------------------------------------------------------------------------------------------------
iface_reference
		(
		const reference&	ref
		) : m_ptr( 0 )
{
	object		obj = ref.lock();
	if( obj == false )
		return;
	m_ptr	= static_cast<t_iface_name*>( obj.query( t_guid::get_const() ) );
	if( m_ptr != 0 )
		m_reference	= obj;
}
//=======================================================================
//!	lock
//-----------------------------------------------------------------------
iface_object<t_iface_name , t_guid> lock()
{
	object	obj = m_reference.lock();
	if( obj == false )
		return iface_object<t_iface_name , t_guid>();
	
	iface_object<t_iface_name , t_guid>	r;
	r.m_object	= obj;
	r.m_ptr		= m_ptr;
	return r;
}
//=======================================================================
//!	release
//-----------------------------------------------------------------------
void release()
{
	m_reference.release();
	m_ptr	= 0;
}
//=======================================================================
//!	substitution
//-----------------------------------------------------------------------
iface_reference<t_iface_name , t_guid>& operator=
		(
		const iface_reference<t_iface_name , t_guid>&	ref
		)
{
	m_reference	= ref.m_reference;
	m_ptr		= ref.m_ptr;
	return *this;
}
//=======================================================================
//!	substitution
//-----------------------------------------------------------------------
iface_reference<t_iface_name , t_guid>& operator=
		(
		const object&	obj
		)
{
	m_ptr	= static_cast<t_iface_name*>( obj.query( t_guid::get_const() ) );
	if( m_ptr != 0 )
		m_reference = obj;
	else
		m_reference.release();
	return *this;
}
//=======================================================================
//!	substitution
//-----------------------------------------------------------------------
iface_reference<t_iface_name , t_guid>& operator=
		(
		const reference&	ref
		)
{
	object	obj = ref.lock();
	if( obj == false )
	{
		release();
		return *this;
	}
	m_ptr	= static_cast<t_iface_name*>( obj.query( t_guid::get_const() ) );
	if( m_ptr != 0 )
		m_reference = obj;
	else
		m_reference.release();
	return *this;
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator==
		(
		bool	b
		)const
{
	return ( m_reference == b );
}
//=======================================================================
//!	compare
//-----------------------------------------------------------------------
bool operator!=
		(
		bool	b
		)const
{
	return ( m_reference != b );
}
//=================================================================================================
//! cast
//!	@retval			---
//-------------------------------------------------------------------------------------------------
operator reference()const
{
	return m_reference;
}
};

/**************************************************************************************************
"instance" class 
**************************************************************************************************/
template<class t_class >
class instance
{
// variable member
private:
	t_class		*m_ptr;
	object		m_object;

// private functions
private:
// protect functions
protected:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
instance() : m_ptr( new t_class() ) , m_object( static_cast<iobject*>(m_ptr) )
{
}
//=================================================================================================
//!	ref operator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_class* operator->()const
{
	return m_ptr;
}
//=================================================================================================
//! cast
//!	@retval			---
//-------------------------------------------------------------------------------------------------
operator object()const
{
	return m_object;
}
};

#pragma pack( push , 4 )		//set align

/**************************************************************************************************
"object_count" class 
**************************************************************************************************/
class object_count : public iobject_count
{
// variable member
private:
	long		m_object_count;
	long		m_reference_count;
	
// "iobject_count" iface functions
public:
//=================================================================================================
//!	Add object count
//!	@retval			---
//-------------------------------------------------------------------------------------------------
long cb_call inc_object_count()
{
	while( true )
	{
		long count = static_cast< long const volatile& >( m_object_count );
		if( count == 0 ) 
			return 0;
		if( cb_atomic_compare_exchange( &m_object_count, count + 1, count ) == count ) 
			return count + 1;
	}
}
//=================================================================================================
//!	Release object count
//!	@retval			---
//-------------------------------------------------------------------------------------------------
long cb_call dec_object_count()
{
	return cb_atomic_decrement( &m_object_count );
}
//=================================================================================================
//!	Add reference count
//!	@retval			---
//-------------------------------------------------------------------------------------------------
long cb_call inc_reference_count()
{
	return cb_atomic_increment( &m_reference_count );
}
//=================================================================================================
//!	release reference count
//!	@retval			---
//-------------------------------------------------------------------------------------------------
long cb_call release_reference()
{
	long count = cb_atomic_decrement( &m_reference_count );
	if( count == 0 )
		delete this;
	return count;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
object_count() : 
		m_object_count( 1 ) , 
		m_reference_count( 1 )
{
	cb_assert( ( uint32 )( &m_object_count ) % 4 == 0 , L"alignment error!" );
	cb_assert( ( uint32 )( &m_reference_count ) % 4 == 0 , L"alignment error!" );
}

};
#pragma pack( pop )			//release align

/**************************************************************************************************
"object_base" class 
**************************************************************************************************/
class object_base : public iobject
{
	cb_copy_impossible( object_base );

// variable member
private:
	iobject_count		*m_object_countPtr;

// "iobject" interface functions
public:
//=================================================================================================
//!	get icount_object ptr
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iobject_count* cb_call get_object_count()
{
	return m_object_countPtr;
}
//=================================================================================================
//!	delete
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call delete_object()
{
	delete this;
}
//=================================================================================================
//!	query
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void* cb_call query
		(
		const icubic::guid		&guid
		)const
{
	return query_oride( guid );
}

// protect functions
protected:
//=================================================================================================
//!	query
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void* query_oride
		(
		const icubic::guid	&guid
		)const
{
	return 0;
}
//=================================================================================================
//!	get this object
//!	@retval			---
//-------------------------------------------------------------------------------------------------
object this_object()
{
	m_object_countPtr->inc_object_count();
	return object( this );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
object_base() : m_object_countPtr( new object_count() )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
virtual
~object_base()
{
	m_object_countPtr->release_reference();
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
bool operator==
		( 
		bool			b , 
		const object	&obj
		)
{
	return ( obj == b );
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
bool operator!=
		( 
		bool			b , 
		const object	&obj
		)
{
	return ( obj != b );
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
bool operator==
		( 
		bool			b , 
		const reference	&ref
		)
{
	return ( ref == b );
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
bool operator!=
		( 
		bool			b , 
		const reference	&ref
		)
{
	return ( ref != b );
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_iface_name , class t_guid>
cb_inline
bool operator==
		(
		bool										b , 
		const iface_object<t_iface_name , t_guid>	&obj
		)
{
	return ( obj == b );
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_iface_name , class t_guid>
cb_inline
bool operator!=
		(
		bool										b , 
		const iface_object<t_iface_name , t_guid>	&obj
		)
{
	return ( obj != b );
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_iface_name , class t_guid>
cb_inline
bool operator==
		(
		bool											b , 
		const iface_reference<t_iface_name , t_guid>	&ref
		)
{
	return ( ref == b );
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_iface_name , class t_guid>
cb_inline
bool operator!=
		(
		bool											b , 
		const iface_reference<t_iface_name , t_guid>	&ref
		)
{
	return ( ref != b );
}


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
