/*************************************************************************************************/
/*!
   	@file		sb_cpp_load.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
// loadbyte
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_loadbyte2
		(
		const uint8*	src , 
		uint8*			dest
		)
{
	*(uint16*)dest	= *(const uint16*)src;
}
//=================================================================================================
cb_inline
void sb_cpp_loadbyte2_endiancg
		(
		const uint8*	src , 
		uint8*			dest
		)
{
	dest[0]	= src[1];
	dest[1]	= src[0];
}
//=================================================================================================
cb_inline
void sb_cpp_loadbyte3
		(
		const uint8*	src , 
		uint8*			dest
		)
{
	dest[0]	= src[0];
	dest[1]	= src[1];
	dest[2]	= src[2];
}
//=================================================================================================
cb_inline
void sb_cpp_loadbyte3_endiancg
		(
		const uint8*	src , 
		uint8*			dest
		)
{
	dest[0]	= src[2];
	dest[1]	= src[1];
	dest[2]	= src[0];
}
//=================================================================================================
cb_inline
void sb_cpp_loadbyte4
		(
		const uint8*	src , 
		uint8*			dest
		)
{
	*(uint32*)dest	= *(const uint32*)src;
}
//=================================================================================================
cb_inline
void sb_cpp_loadbyte4_endiancg
		(
		const uint8*	src , 
		uint8*			dest
		)
{
	dest[0]	= src[3];
	dest[1]	= src[2];
	dest[2]	= src[1];
	dest[3]	= src[0];
}
//=================================================================================================
cb_inline
void sb_cpp_loadbyte8
		(
		const uint8*	src , 
		uint8*			dest
		)
{
	((uint32*)dest)[0]	= ((const uint32*)src)[0];
	((uint32*)dest)[1]	= ((const uint32*)src)[1];
}
//=================================================================================================
cb_inline
void sb_cpp_loadbyte8_endiancg
		(
		const uint8*	src , 
		uint8*			dest
		)
{
	dest[0]	= src[7];
	dest[1]	= src[6];
	dest[2]	= src[5];
	dest[3]	= src[4];
	dest[4]	= src[3];
	dest[5]	= src[2];
	dest[6]	= src[1];
	dest[7]	= src[0];
}
//=================================================================================================
// load
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_load_int8align8
		(
		const void*		src , 
		sb_value&		dest
		)
{
	dest.m_int32	= (int32)( *(const uint8*)src ) - 128;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int16align16lsb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte2( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte2_endiancg( (const uint8*)src , &dest.m_byte[4-2] );
#endif
	dest.m_uint32	<<= 32-16;
	dest.m_int32	>>= 32-16;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int16align16msb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte2_endiancg( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte2( (const uint8*)src , &dest.m_byte[4-2] );
#endif
	dest.m_uint32	<<= 32-16;
	dest.m_int32	>>= 32-16;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int24align24lsb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte3( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte3_endiancg( (const uint8*)src , &dest.m_byte[4-3] );
#endif
	dest.m_uint32	<<= 32-24;
	dest.m_int32	>>= 32-24;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int24align24msb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte3_endiancg( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte3( (const uint8*)src , &dest.m_byte[4-3] );
#endif
	dest.m_uint32	<<= 32-24;
	dest.m_int32	>>= 32-24;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int32align32lsb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[4-4] );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_load_int32align32msb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[4-4] );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_load_float32align32lsb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[4-4] );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_load_float32align32msb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[4-4] );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_load_float64align64lsb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte8( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte8_endiancg( (const uint8*)src , &dest.m_byte[4-4] );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_load_float64align64msb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte8_endiancg( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte8( (const uint8*)src , &dest.m_byte[4-4] );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_load_int16align32lsb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[4-4] );
#endif
	dest.m_uint32	<<= 32-16;
	dest.m_int32	>>= 32-16;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int16align32msb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[4-4] );
#endif
	dest.m_uint32	<<= 32-16;
	dest.m_int32	>>= 32-16;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int18align32lsb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[4-4] );
#endif
	dest.m_uint32	<<= 32-18;
	dest.m_int32	>>= 32-18;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int18align32msb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[4-4] );
#endif
	dest.m_uint32	<<= 32-18;
	dest.m_int32	>>= 32-18;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int20align32lsb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[4-4] );
#endif
	dest.m_uint32	<<= 32-20;
	dest.m_int32	>>= 32-20;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int20align32msb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[4-4] );
#endif
	dest.m_uint32	<<= 32-20;
	dest.m_int32	>>= 32-20;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int24align32lsb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[4-4] );
#endif
	dest.m_uint32	<<= 32-24;
	dest.m_int32	>>= 32-24;
}
//=================================================================================================
cb_inline
void sb_cpp_load_int24align32msb
		(
		const void*		src , 
		sb_value&		dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( (const uint8*)src , &dest.m_byte[0] );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( (const uint8*)src , &dest.m_byte[4-4] );
#endif
	dest.m_uint32	<<= 32-24;
	dest.m_int32	>>= 32-24;
}
//=================================================================================================
// sb_cpp_store
//=================================================================================================
//=================================================================================================
cb_inline
void sb_cpp_store_int8align8
		(
		const sb_value&	src , 
		void*			dest
		)
{
	*(uint8*)dest	= (uint8)( src.m_int32 + 128 );
}
//=================================================================================================
cb_inline
void sb_cpp_store_int16align16lsb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte2( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte2_endiancg( &src.m_byte[4-2] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int16align16msb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte2_endiancg( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte2( &src.m_byte[4-2] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int24align24lsb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte3( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte3_endiancg( &src.m_byte[4-3] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int24align24msb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte3_endiancg( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte3( &src.m_byte[4-3] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int32align32lsb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int32align32msb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_float32align32lsb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_float32align32msb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_float64align64lsb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte8( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte8_endiancg( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_float64align64msb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte8_endiancg( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte8( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int16align32lsb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int16align32msb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int18align32lsb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int18align32msb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int20align32lsb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int20align32msb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int24align32lsb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4_endiancg( &src.m_byte[4-4] , (uint8*)dest );
#endif
}
//=================================================================================================
cb_inline
void sb_cpp_store_int24align32msb
		(
		const sb_value&	src , 
		void*			dest
		)
{
#ifdef cb_little_endian
	sb_cpp_loadbyte4_endiancg( &src.m_byte[0] , (uint8*)dest );
#elif defined( cb_big_endian )
	sb_cpp_loadbyte4( &src.m_byte[4-4] , (uint8*)dest );
#endif
}


};	//namespace

#pragma pack( pop )			//release align
